/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.hidserv;

import java.io.File;
import org.torproject.metrics.hidserv.Aggregator;
import org.torproject.metrics.hidserv.ComputedNetworkFractions;
import org.torproject.metrics.hidserv.DocumentStore;
import org.torproject.metrics.hidserv.ExtrapolatedHidServStats;
import org.torproject.metrics.hidserv.Extrapolator;
import org.torproject.metrics.hidserv.Parser;
import org.torproject.metrics.hidserv.ReportedHidServStats;

public class Main {
    public static void main(String[] args) {
        File[] inDirectories = new File[]{new File("../../shared/in/recent/relay-descriptors/consensuses"), new File("../../shared/in/recent/relay-descriptors/extra-infos")};
        File statusDirectory = new File("status");
        System.out.println("Initializing parser and reading parse history...");
        DocumentStore<ReportedHidServStats> reportedHidServStatsStore = new DocumentStore<ReportedHidServStats>(ReportedHidServStats.class);
        DocumentStore<ComputedNetworkFractions> computedNetworkFractionsStore = new DocumentStore<ComputedNetworkFractions>(ComputedNetworkFractions.class);
        Parser parser = new Parser(inDirectories, statusDirectory, reportedHidServStatsStore, computedNetworkFractionsStore);
        parser.readParseHistory();
        System.out.println("Parsing descriptors...");
        if (!parser.parseDescriptors()) {
            System.err.println("Could not store parsed descriptors.  Terminating.");
            return;
        }
        System.out.println("Writing parse history...");
        parser.writeParseHistory();
        System.out.println("Extrapolating statistics...");
        DocumentStore<ExtrapolatedHidServStats> extrapolatedHidServStatsStore = new DocumentStore<ExtrapolatedHidServStats>(ExtrapolatedHidServStats.class);
        Extrapolator extrapolator = new Extrapolator(statusDirectory, reportedHidServStatsStore, computedNetworkFractionsStore, extrapolatedHidServStatsStore);
        if (!extrapolator.extrapolateHidServStats()) {
            System.err.println("Could not extrapolate statistics.  Terminating.");
            return;
        }
        System.out.println("Aggregating statistics...");
        File hidservStatsExtrapolatedCsvFile = new File("stats/hidserv.csv");
        Aggregator aggregator = new Aggregator(statusDirectory, extrapolatedHidServStatsStore, hidservStatsExtrapolatedCsvFile);
        aggregator.aggregateHidServStats();
        System.out.println("Terminating.");
    }
}

