/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.hidserv;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.torproject.metrics.hidserv.ComputedNetworkFractions;
import org.torproject.metrics.hidserv.DateTimeHelper;
import org.torproject.metrics.hidserv.DocumentStore;
import org.torproject.metrics.hidserv.ExtrapolatedHidServStats;
import org.torproject.metrics.hidserv.ReportedHidServStats;

public class Extrapolator {
    private File reportedHidServStatsFile;
    private DocumentStore<ReportedHidServStats> reportedHidServStatsStore;
    private File computedNetworkFractionsDirectory;
    private DocumentStore<ComputedNetworkFractions> computedNetworkFractionsStore;
    private File extrapolatedHidServStatsFile;
    private DocumentStore<ExtrapolatedHidServStats> extrapolatedHidServStatsStore;

    public Extrapolator(File statusDirectory, DocumentStore<ReportedHidServStats> reportedHidServStatsStore, DocumentStore<ComputedNetworkFractions> computedNetworkFractionsStore, DocumentStore<ExtrapolatedHidServStats> extrapolatedHidServStatsStore) {
        this.reportedHidServStatsFile = new File(statusDirectory, "reported-hidserv-stats");
        this.computedNetworkFractionsDirectory = new File(statusDirectory, "computed-network-fractions");
        this.extrapolatedHidServStatsFile = new File(statusDirectory, "extrapolated-hidserv-stats");
        this.reportedHidServStatsStore = reportedHidServStatsStore;
        this.computedNetworkFractionsStore = computedNetworkFractionsStore;
        this.extrapolatedHidServStatsStore = extrapolatedHidServStatsStore;
    }

    public boolean extrapolateHidServStats() {
        String fingerprint;
        Set<ExtrapolatedHidServStats> extrapolatedStats = this.extrapolatedHidServStatsStore.retrieve(this.extrapolatedHidServStatsFile);
        Set<ReportedHidServStats> reportedStats = this.reportedHidServStatsStore.retrieve(this.reportedHidServStatsFile);
        if (extrapolatedStats == null || reportedStats == null) {
            System.err.printf("Could not read previously parsed or extrapolated hidserv-stats.  Skipping.", new Object[0]);
            return false;
        }
        TreeMap parsedStatsByFingerprint = new TreeMap();
        for (ReportedHidServStats reportedHidServStats : reportedStats) {
            fingerprint = reportedHidServStats.getFingerprint();
            if (!parsedStatsByFingerprint.containsKey(fingerprint)) {
                parsedStatsByFingerprint.put(fingerprint, new HashSet());
            }
            ((Set)parsedStatsByFingerprint.get(fingerprint)).add(reportedHidServStats);
        }
        for (Map.Entry entry : parsedStatsByFingerprint.entrySet()) {
            fingerprint = (String)entry.getKey();
            HashSet<ReportedHidServStats> newReportedStats = new HashSet<ReportedHidServStats>();
            TreeSet<String> retrieveFractionDates = new TreeSet<String>();
            for (ReportedHidServStats stats : (Set)entry.getValue()) {
                long statsStartMillis;
                long statsDateMillis = stats.getStatsEndMillis() / 86400000L * 86400000L;
                if (extrapolatedStats.contains(new ExtrapolatedHidServStats(statsDateMillis, fingerprint))) continue;
                newReportedStats.add(stats);
                long statsEndMillis = stats.getStatsEndMillis();
                for (long millis = statsStartMillis = statsEndMillis - stats.getStatsIntervalSeconds() * 1000L; millis <= statsEndMillis; millis += 86400000L) {
                    String date = DateTimeHelper.format(millis, "yyyy-MM-dd");
                    retrieveFractionDates.add(date);
                }
            }
            TreeSet<Long> knownConsensuses = new TreeSet<Long>();
            TreeMap<Long, ComputedNetworkFractions> computedNetworkFractions = new TreeMap<Long, ComputedNetworkFractions>();
            for (String date : retrieveFractionDates) {
                File documentFile = new File(this.computedNetworkFractionsDirectory, date);
                Set<ComputedNetworkFractions> fractions = this.computedNetworkFractionsStore.retrieve(documentFile, fingerprint);
                for (ComputedNetworkFractions fraction : fractions) {
                    knownConsensuses.add(fraction.getValidAfterMillis());
                    if (!fraction.getFingerprint().equals(fingerprint)) continue;
                    computedNetworkFractions.put(fraction.getValidAfterMillis(), fraction);
                }
            }
            for (ReportedHidServStats stats : newReportedStats) {
                long statsEndMillis = stats.getStatsEndMillis();
                long statsDateMillis = statsEndMillis / 86400000L * 86400000L;
                long statsStartMillis = statsEndMillis - stats.getStatsIntervalSeconds() * 1000L;
                double sumFractionRendRelayedCells = 0.0;
                double sumFractionDirOnionsSeen = 0.0;
                int consensuses = 0;
                Iterator iterator = knownConsensuses.iterator();
                while (iterator.hasNext()) {
                    long validAfterMillis = (Long)iterator.next();
                    if (statsStartMillis > validAfterMillis || validAfterMillis >= statsEndMillis) continue;
                    if (computedNetworkFractions.containsKey(validAfterMillis)) {
                        ComputedNetworkFractions frac = (ComputedNetworkFractions)computedNetworkFractions.get(validAfterMillis);
                        sumFractionRendRelayedCells += frac.getFractionRendRelayedCells();
                        sumFractionDirOnionsSeen += frac.getFractionDirOnionsSeen();
                    }
                    ++consensuses;
                }
                if (consensuses == 0) continue;
                double fractionRendRelayedCells = sumFractionRendRelayedCells / (double)consensuses;
                double fractionDirOnionsSeen = sumFractionDirOnionsSeen / (double)consensuses;
                if (!(fractionRendRelayedCells > 0.0) && !(fractionDirOnionsSeen > 0.0)) continue;
                ExtrapolatedHidServStats extrapolated = new ExtrapolatedHidServStats(statsDateMillis, fingerprint);
                if (fractionRendRelayedCells > 0.0) {
                    extrapolated.setFractionRendRelayedCells(fractionRendRelayedCells);
                    double extrapolatedRendRelayedCells = (double)stats.getRendRelayedCells() / fractionRendRelayedCells;
                    extrapolated.setExtrapolatedRendRelayedCells(extrapolatedRendRelayedCells);
                }
                if (fractionDirOnionsSeen > 0.0) {
                    extrapolated.setFractionDirOnionsSeen(fractionDirOnionsSeen);
                    double extrapolatedDirOnionsSeen = (double)stats.getDirOnionsSeen() / (12.0 * fractionDirOnionsSeen);
                    extrapolated.setExtrapolatedDirOnionsSeen(extrapolatedDirOnionsSeen);
                }
                extrapolatedStats.add(extrapolated);
            }
        }
        return this.extrapolatedHidServStatsStore.store(this.extrapolatedHidServStatsFile, extrapolatedStats);
    }
}

