/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.hidserv;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.torproject.metrics.hidserv.DateTimeHelper;
import org.torproject.metrics.hidserv.DocumentStore;
import org.torproject.metrics.hidserv.ExtrapolatedHidServStats;

public class Aggregator {
    private File extrapolatedHidServStatsFile;
    private DocumentStore<ExtrapolatedHidServStats> extrapolatedHidServStatsStore;
    private File hidservStatsCsvFile;

    public Aggregator(File statusDirectory, DocumentStore<ExtrapolatedHidServStats> extrapolatedHidServStatsStore, File hidservStatsCsvFile) {
        this.extrapolatedHidServStatsFile = new File(statusDirectory, "extrapolated-hidserv-stats");
        this.extrapolatedHidServStatsStore = extrapolatedHidServStatsStore;
        this.hidservStatsCsvFile = hidservStatsCsvFile;
    }

    public void aggregateHidServStats() {
        Set<ExtrapolatedHidServStats> extrapolatedStats = this.extrapolatedHidServStatsStore.retrieve(this.extrapolatedHidServStatsFile);
        if (extrapolatedStats == null) {
            System.err.printf("Unable to retrieve extrapolated hidden-service statistics from file %s.  Skipping aggregation step.%n", this.extrapolatedHidServStatsFile.getAbsolutePath());
            return;
        }
        TreeMap extrapolatedCells = new TreeMap();
        TreeMap extrapolatedOnions = new TreeMap();
        for (ExtrapolatedHidServStats extrapolated : extrapolatedStats) {
            String date = DateTimeHelper.format(extrapolated.getStatsDateMillis(), "yyyy-MM-dd");
            if (extrapolated.getFractionRendRelayedCells() > 0.0) {
                if (!extrapolatedCells.containsKey(date)) {
                    extrapolatedCells.put(date, new ArrayList());
                }
                ((List)extrapolatedCells.get(date)).add(new double[]{extrapolated.getExtrapolatedRendRelayedCells(), extrapolated.getFractionRendRelayedCells()});
            }
            if (!(extrapolated.getFractionDirOnionsSeen() > 0.0)) continue;
            if (!extrapolatedOnions.containsKey(date)) {
                extrapolatedOnions.put(date, new ArrayList());
            }
            ((List)extrapolatedOnions.get(date)).add(new double[]{extrapolated.getExtrapolatedDirOnionsSeen(), extrapolated.getFractionDirOnionsSeen()});
        }
        StringBuilder sb = new StringBuilder();
        sb.append("date,type,wmean,wmedian,wiqm,frac,stats\n");
        for (int i = 0; i < 2; ++i) {
            String type = i == 0 ? "rend-relayed-cells" : "dir-onions-seen";
            TreeMap extrapolated = i == 0 ? extrapolatedCells : extrapolatedOnions;
            for (Map.Entry e : extrapolated.entrySet()) {
                List weightedValues = (List)e.getValue();
                Collections.sort(weightedValues, new Comparator<double[]>(){

                    @Override
                    public int compare(double[] first, double[] second) {
                        return Double.compare(first[0], second[0]);
                    }
                });
                double sumReported = 0.0;
                double sumFraction = 0.0;
                for (double[] d : weightedValues) {
                    sumReported += d[0] * d[1];
                    sumFraction += d[1];
                }
                double weightedMean = sumReported / sumFraction;
                double weightIntervalEnd = 0.0;
                Double weightedMedian = null;
                double sumFractionInterquartile = 0.0;
                double sumReportedInterquartile = 0.0;
                for (double[] d : weightedValues) {
                    double extrapolatedValue = d[0];
                    double computedFraction = d[1];
                    double weightIntervalStart = weightIntervalEnd;
                    weightIntervalEnd += computedFraction;
                    if (weightedMedian == null && weightIntervalEnd > sumFraction * 0.5) {
                        weightedMedian = extrapolatedValue;
                    }
                    if (!(weightIntervalEnd >= sumFraction * 0.25) || !(weightIntervalStart <= sumFraction * 0.75)) continue;
                    double fractionBetweenQuartiles = Math.min(weightIntervalEnd, sumFraction * 0.75) - Math.max(weightIntervalStart, sumFraction * 0.25);
                    sumReportedInterquartile += extrapolatedValue * fractionBetweenQuartiles;
                    sumFractionInterquartile += fractionBetweenQuartiles;
                }
                double weightedInterquartileMean = sumReportedInterquartile / sumFractionInterquartile;
                String date = (String)e.getKey();
                int numStats = weightedValues.size();
                sb.append(String.format("%s,%s,%.0f,%.0f,%.0f,%.8f,%d%n", date, type, weightedMean, weightedMedian, weightedInterquartileMean, sumFraction, numStats));
            }
        }
        this.hidservStatsCsvFile.getParentFile().mkdirs();
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.hidservStatsCsvFile));){
            bw.write(sb.toString());
        }
        catch (IOException e) {
            System.err.printf("Unable to write results to %s.  Ignoring.", this.extrapolatedHidServStatsFile.getAbsolutePath());
        }
    }
}

