/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.advbwdist;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.TimeZone;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorReader;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.NetworkStatusEntry;
import org.torproject.descriptor.RelayNetworkStatusConsensus;
import org.torproject.descriptor.ServerDescriptor;

public class Main {
    public static void main(String[] args) throws IOException {
        HashMap<String, Long> serverDescriptors = new HashMap<String, Long>();
        DescriptorReader descriptorReader = DescriptorSourceFactory.createDescriptorReader();
        for (Descriptor descriptor : descriptorReader.readDescriptors(new File("../../shared/in/recent/relay-descriptors/server-descriptors"))) {
            if (!(descriptor instanceof ServerDescriptor)) continue;
            ServerDescriptor serverDescriptor = (ServerDescriptor)descriptor;
            String digest = serverDescriptor.getDigestSha1Hex();
            long advertisedBandwidth = Math.min(Math.min(serverDescriptor.getBandwidthRate(), serverDescriptor.getBandwidthBurst()), serverDescriptor.getBandwidthObserved());
            serverDescriptors.put(digest.toUpperCase(), advertisedBandwidth);
        }
        descriptorReader = DescriptorSourceFactory.createDescriptorReader();
        File historyFile = new File("status/parsed-consensuses");
        descriptorReader.setHistoryFile(historyFile);
        File resultsFile = new File("stats/advbwdist-validafter.csv");
        resultsFile.getParentFile().mkdirs();
        boolean writeHeader = !resultsFile.exists();
        BufferedWriter bw = new BufferedWriter(new FileWriter(resultsFile, true));
        if (writeHeader) {
            bw.write("valid_after,isexit,relay,percentile,advbw\n");
        }
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        for (Descriptor descriptor : descriptorReader.readDescriptors(new File("../../shared/in/recent/relay-descriptors/consensuses"))) {
            int[] fastestRelays;
            if (!(descriptor instanceof RelayNetworkStatusConsensus)) continue;
            RelayNetworkStatusConsensus consensus = (RelayNetworkStatusConsensus)descriptor;
            String validAfter = dateTimeFormat.format(consensus.getValidAfterMillis());
            ArrayList<Long> advertisedBandwidthsAllRelays = new ArrayList<Long>();
            ArrayList<Long> advertisedBandwidthsExitsOnly = new ArrayList<Long>();
            for (NetworkStatusEntry networkStatusEntry : consensus.getStatusEntries().values()) {
                String serverDescriptorDigest;
                if (!networkStatusEntry.getFlags().contains("Running") || !serverDescriptors.containsKey(serverDescriptorDigest = networkStatusEntry.getDescriptor().toUpperCase())) continue;
                long advertisedBandwidth = (Long)serverDescriptors.get(serverDescriptorDigest);
                advertisedBandwidthsAllRelays.add(advertisedBandwidth);
                if (!networkStatusEntry.getFlags().contains("Exit") || networkStatusEntry.getFlags().contains("BadExit")) continue;
                advertisedBandwidthsExitsOnly.add(advertisedBandwidth);
            }
            Collections.sort(advertisedBandwidthsAllRelays, Collections.reverseOrder());
            Collections.sort(advertisedBandwidthsExitsOnly, Collections.reverseOrder());
            for (int fastestRelay : fastestRelays = new int[]{1, 2, 3, 5, 10, 20, 30, 50, 100, 200, 300, 500, 1000, 2000, 3000, 5000}) {
                if (advertisedBandwidthsAllRelays.size() < fastestRelay) continue;
                bw.write(String.format("%s,,%d,,%d%n", validAfter, fastestRelay, advertisedBandwidthsAllRelays.get(fastestRelay - 1)));
            }
            for (int fastestRelay : fastestRelays) {
                if (advertisedBandwidthsExitsOnly.size() < fastestRelay) continue;
                bw.write(String.format("%s,TRUE,%d,,%d%n", validAfter, fastestRelay, advertisedBandwidthsExitsOnly.get(fastestRelay - 1)));
            }
            Collections.sort(advertisedBandwidthsAllRelays);
            Collections.sort(advertisedBandwidthsExitsOnly);
            int[] nArray = new int[]{0, 1, 2, 3, 5, 9, 10, 20, 25, 30, 40, 50, 60, 70, 75, 80, 90, 91, 95, 97, 98, 99, 100};
            if (!advertisedBandwidthsAllRelays.isEmpty()) {
                for (int percentile : nArray) {
                    bw.write(String.format("%s,,,%d,%d%n", validAfter, percentile, advertisedBandwidthsAllRelays.get((advertisedBandwidthsAllRelays.size() - 1) * percentile / 100)));
                }
            }
            if (advertisedBandwidthsExitsOnly.isEmpty()) continue;
            for (int percentile : nArray) {
                bw.write(String.format("%s,TRUE,,%d,%d%n", validAfter, percentile, advertisedBandwidthsExitsOnly.get((advertisedBandwidthsExitsOnly.size() - 1) * percentile / 100)));
            }
        }
        descriptorReader.saveHistoryFile(historyFile);
        bw.close();
    }
}

