/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.ernie.cron;

import java.io.File;
import java.util.logging.Logger;
import org.torproject.ernie.cron.Configuration;
import org.torproject.ernie.cron.LockFile;
import org.torproject.ernie.cron.LoggingConfiguration;
import org.torproject.ernie.cron.RelayDescriptorDatabaseImporter;
import org.torproject.ernie.cron.network.ConsensusStatsFileHandler;

public class Main {
    public static void main(String[] args) {
        ConsensusStatsFileHandler csfh;
        new LoggingConfiguration();
        Logger logger = Logger.getLogger(Main.class.getName());
        logger.info("Starting ERNIE.");
        Configuration config = new Configuration();
        LockFile lf = new LockFile();
        if (!lf.acquireLock()) {
            logger.severe("Warning: ERNIE is already running or has not exited cleanly! Exiting!");
            System.exit(1);
        }
        File statsDirectory = new File("stats");
        if (config.getImportDirectoryArchives()) {
            RelayDescriptorDatabaseImporter rddi;
            RelayDescriptorDatabaseImporter relayDescriptorDatabaseImporter = config.getWriteRelayDescriptorDatabase() || config.getWriteRelayDescriptorsRawFiles() ? new RelayDescriptorDatabaseImporter(config.getWriteRelayDescriptorDatabase() ? config.getRelayDescriptorDatabaseJdbc() : null, config.getWriteRelayDescriptorsRawFiles() ? config.getRelayDescriptorRawFilesDirectory() : null, config.getDirectoryArchivesDirectories(), statsDirectory, config.getKeepDirectoryArchiveImportHistory()) : (rddi = null);
            if (null != rddi) {
                rddi.importRelayDescriptors();
                rddi.closeConnection();
            }
        }
        ConsensusStatsFileHandler consensusStatsFileHandler = csfh = config.getWriteBridgeStats() ? new ConsensusStatsFileHandler(config.getRelayDescriptorDatabaseJdbc(), new File(config.getSanitizedBridgesDirectory()), statsDirectory, config.getKeepSanitizedBridgesImportHistory()) : null;
        if (csfh != null) {
            if (config.getImportSanitizedBridges()) {
                csfh.importSanitizedBridges();
            }
            csfh.writeFiles();
        }
        lf.releaseLock();
        logger.info("Terminating ERNIE.");
    }
}

