/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.ernie.cron;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LoggingConfiguration {
    public LoggingConfiguration() {
        for (Handler h : Logger.getLogger("").getHandlers()) {
            Logger.getLogger("").removeHandler(h);
        }
        Logger.getLogger("sun").setLevel(Level.OFF);
        Logger.getLogger("").setLevel(Level.FINER);
        final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Formatter cf = new Formatter(){

            @Override
            public String format(LogRecord record) {
                return dateTimeFormat.format(new Date(record.getMillis())) + " " + record.getMessage() + "\n";
            }
        };
        ConsoleHandler ch = new ConsoleHandler();
        ch.setFormatter(cf);
        ch.setLevel(Level.WARNING);
        Logger.getLogger("").addHandler(ch);
        Logger logger = Logger.getLogger(LoggingConfiguration.class.getName());
        Formatter ff = new Formatter(){

            @Override
            public String format(LogRecord record) {
                return dateTimeFormat.format(new Date(record.getMillis())) + " " + record.getLevel() + " " + record.getSourceClassName() + " " + record.getSourceMethodName() + " " + record.getMessage() + (record.getThrown() != null ? " " + record.getThrown() : "") + "\n";
            }
        };
        try {
            FileHandler fh = new FileHandler("log", 5000000, 5, true);
            fh.setFormatter(ff);
            fh.setLevel(Level.FINE);
            Logger.getLogger("").addHandler(fh);
        }
        catch (SecurityException e) {
            logger.log(Level.WARNING, "No permission to create log file. Logging to file is disabled.", e);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not write to log file. Logging to file is disabled.", e);
        }
    }
}

