/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.descriptorparser.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.descriptorparser.utils.TorVersionStatus;

public class TorVersion
implements Comparable<TorVersion> {
    private static final Logger logger = LoggerFactory.getLogger(TorVersion.class);
    private List<Integer> versionNumbers = new ArrayList<Integer>();
    private String releaseSeries;
    private String statusTag = null;
    private static Map<String, TorVersion> knownVersions = new HashMap<String, TorVersion>();

    private TorVersion() {
    }

    public static TorVersion of(String versionString) {
        if (null == versionString) {
            return null;
        }
        if (!knownVersions.containsKey(versionString)) {
            TorVersion result = new TorVersion();
            boolean isValid = true;
            try {
                String[] components = versionString.split("-")[0].split("\\.", -1);
                for (int position = 0; position < 4 && position < components.length; ++position) {
                    if (!components[position].isEmpty()) {
                        result.versionNumbers.add(Integer.parseInt(components[position]));
                        continue;
                    }
                    if (0 != position && position >= components.length - 1) continue;
                    isValid = false;
                }
                if (result.versionNumbers.size() >= 3) {
                    result.releaseSeries = String.format("%d.%d.%d", result.versionNumbers.get(0), result.versionNumbers.get(1), result.versionNumbers.get(2));
                }
                if (versionString.contains("-")) {
                    result.statusTag = versionString.split("-", 2)[1].split(" ")[0];
                }
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException exception) {
                isValid = false;
                logger.warn(String.format(exception.getMessage(), new Object[0]));
            }
            if (!isValid) {
                result = null;
            }
            knownVersions.put(versionString, result);
        }
        return knownVersions.get(versionString);
    }

    @Override
    public int compareTo(TorVersion other) {
        if (null == other) {
            throw new NullPointerException();
        }
        for (int position = 0; position < this.versionNumbers.size() && position < other.versionNumbers.size(); ++position) {
            int result = Integer.compare(this.versionNumbers.get(position), other.versionNumbers.get(position));
            if (result == 0) continue;
            return result;
        }
        if (this.versionNumbers.size() != other.versionNumbers.size()) {
            return this.versionNumbers.size() < other.versionNumbers.size() ? -1 : 1;
        }
        if (null == this.statusTag && null == other.statusTag) {
            return 0;
        }
        if (null == this.statusTag) {
            return -1;
        }
        if (null == other.statusTag) {
            return 1;
        }
        return this.statusTag.compareTo(other.statusTag);
    }

    public boolean equals(Object other) {
        return other instanceof TorVersion && this.compareTo((TorVersion)other) == 0;
    }

    public boolean matchingPrefix(TorVersion other) {
        if (null == other) {
            throw new NullPointerException();
        }
        for (int position = 0; position < this.versionNumbers.size() && position < other.versionNumbers.size(); ++position) {
            if (this.versionNumbers.get(position).equals(other.versionNumbers.get(position))) continue;
            return false;
        }
        if (null != this.statusTag && null != other.statusTag) {
            return this.statusTag.equals(other.statusTag);
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (int position = 0; position < this.versionNumbers.size(); ++position) {
            result += (2 * position + 1) * Integer.hashCode(this.versionNumbers.get(position));
        }
        if (null != this.statusTag) {
            result += 11 * this.statusTag.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int position = 0; position < this.versionNumbers.size(); ++position) {
            if (position > 0) {
                sb.append('.');
            }
            sb.append(this.versionNumbers.get(position));
        }
        if (null != this.statusTag) {
            sb.append('-').append(this.statusTag);
        }
        return sb.toString();
    }

    public TorVersionStatus determineVersionStatus(SortedSet<TorVersion> recommendedVersions) {
        if (null == this.releaseSeries) {
            return TorVersionStatus.UNRECOMMENDED;
        }
        if (recommendedVersions.contains(this)) {
            return TorVersionStatus.RECOMMENDED;
        }
        if (this.compareTo(recommendedVersions.last()) > 0) {
            return TorVersionStatus.EXPERIMENTAL;
        }
        if (this.compareTo(recommendedVersions.first()) < 0) {
            return TorVersionStatus.OBSOLETE;
        }
        boolean seriesHasRecommendedVersions = false;
        boolean notNewInSeries = false;
        for (TorVersion recommendedVersion : recommendedVersions) {
            if (!this.releaseSeries.equals(recommendedVersion.releaseSeries)) continue;
            seriesHasRecommendedVersions = true;
            if (this.compareTo(recommendedVersion) >= 0) continue;
            notNewInSeries = true;
        }
        if (seriesHasRecommendedVersions && !notNewInSeries) {
            return TorVersionStatus.NEW_IN_SERIES;
        }
        return TorVersionStatus.UNRECOMMENDED;
    }
}

