/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.descriptorparser.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.metrics.descriptorparser.utils.DateTimeHelper;

public class DescriptorUtils {
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(DateTimeHelper.class);

    public String fieldAsString(Object field) {
        String out = "";
        try {
            out = objectMapper.writeValueAsString(field);
        }
        catch (JsonProcessingException e) {
            logger.warn(String.format(e.getMessage(), new Object[0]));
        }
        return out;
    }

    public Object[] listToArray(List listArray) {
        if (listArray == null) {
            listArray = new ArrayList();
        }
        return listArray.toArray();
    }

    public String calculateDigestSha256Base64(byte[] rawDescriptorBytes) throws DescriptorParseException {
        String digestSha256Base64 = null;
        digestSha256Base64 = Base64.encodeBase64String(this.messageDigest("SHA-256", rawDescriptorBytes)).replaceAll("=", "");
        if (null == digestSha256Base64) {
            throw new DescriptorParseException("Could not calculate descriptor digest.");
        }
        return digestSha256Base64;
    }

    private byte[] messageDigest(String alg, byte[] rawDescriptorBytes) {
        try {
            MessageDigest md = MessageDigest.getInstance(alg);
            md.update(rawDescriptorBytes);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

