/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.descriptorparser.parsers;

import io.prometheus.client.CollectorRegistry;
import java.io.File;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.DescriptorReader;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.NetworkStatusEntry;
import org.torproject.descriptor.RelayNetworkStatusConsensus;
import org.torproject.metrics.descriptorparser.utils.DescriptorUtils;
import org.torproject.metrics.descriptorparser.utils.Gauge;
import org.torproject.metrics.descriptorparser.utils.OpenMetricsWriter;

public class ConsensusParser {
    private static final Logger logger = LoggerFactory.getLogger(ConsensusParser.class);
    private static final String INSERT_NETWORK_STATUS_SQL = "INSERT INTO network_status (header, network_status_version, vote_status, consensus_method, consensus_flavor, valid_after, fresh_until, valid_until, vote_seconds, dist_seconds, known_flags, recommended_client_version, recommended_server_version, recommended_client_protocols, recommended_relay_protocols, required_client_protocols, required_relay_protocols, params, package_lines, shared_rand_previous_value, shared_rand_current_value, shared_rand_previous_num, shared_rand_current_num, dir_sources, digest, bandwidth_weights, directory_signatures) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String INSERT_NETWORK_STATUS_TOTALS_SQL = "INSERT INTO network_status_totals (total_consensus_weight, total_guard_weight, total_middle_weight, total_exit_weight, time, network_status) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String INSERT_NETWORK_STATUS_ENTRY_SQL = "INSERT INTO network_status_entry (nickname, fingerprint, digest, time, ip, or_port, dir_port, or_addresses, flags, version, bandwidth_unmeasured, bandwidth_weight, proto, policy, port_list, flavor, microdedescriptor_digest, stats, master_key_ed25519, network_status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String INSERT_NETWORK_STATUS_ENTRY_WEIGHTS_SQL = "INSERT INTO network_status_entry_weights (guard_weight, middle_weight, exit_weight, guard_weight_fraction, middle_weight_fraction, exit_weight_fraction, network_weight_fraction, time, network_status_entry) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static CollectorRegistry registry = new CollectorRegistry();
    private static OpenMetricsWriter opWriter = new OpenMetricsWriter();
    private static final long ONE_HOUR_MILLIS = 3600000L;
    private static final long ONE_DAY_MILLIS = 86400000L;
    private static final long ONE_WEEK_MILLIS = 604800000L;
    private static Gauge bwGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("relay_bandwidth")).help("The measured bandwidth in bytes per second.")).labelNames("fingerprint", "nickname")).register(registry);
    private static Gauge descStatusGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("desc_status")).help("Estimated number of intervals when the node was listed as running in the network status published by either the directory authorities or bridge authority")).labelNames("fingerprint", "nickname", "node", "country", "transport", "version")).register(registry);
    private static Gauge networkWeightGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("network_weight")).help("Metric of a relay that is based on bandwidth observed by the relay and bandwidth measured by the directory authorities.")).labelNames("fingerprint", "nickname")).register(registry);
    private static Gauge networkFractionGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("network_fraction")).help("Metric of a relay that is based on bandwidth observed by the relay and bandwidth measured by the directory authorities as a fraction of the total network weight.")).labelNames("fingerprint", "nickname")).register(registry);
    private static Gauge totalNetworkWeightGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("total_network_weight")).help("Metric based on bandwidth observed by relays and bandwidth measured by the directory authorities.")).register(registry);
    private static Gauge networkGuardWeightGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("network_guard_weight")).help("Metric of a guard relay that is based on bandwidth observed by the relay and bandwidth measured by the directory authorities.")).labelNames("fingerprint", "nickname")).register(registry);
    private static Gauge networkGuardFractionGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("network_guard_fraction")).help("Metric of a guard relay that is based on bandwidth observed by the relay and bandwidth measured by the directory authorities as a fraction of the total network weight.")).labelNames("fingerprint", "nickname")).register(registry);
    private static Gauge totalNetworkGuardWeightGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("total_network_guard_weight")).help("Metric based on bandwidth observed by guard relays and bandwidth measured by the directory authorities.")).register(registry);
    private static Gauge networkMiddleWeightGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("network_middle_weight")).help("Metric of a middle relay that is based on bandwidth observed by the relay and bandwidth measured by the directory authorities.")).labelNames("fingerprint", "nickname")).register(registry);
    private static Gauge networkMiddleFractionGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("network_middle_fraction")).help("Metric of a middle relay that is based on bandwidth observed by the relay and bandwidth measured by the directory authorities as a fraction of the total network weight.")).labelNames("fingerprint", "nickname")).register(registry);
    private static Gauge totalNetworkMiddleWeightGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("total_network_middle_weight")).help("Metric based on bandwidth observed by middle relays and bandwidth measured by the directory authorities.")).register(registry);
    private static Gauge networkExitWeightGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("network_exit_weight")).help("Metric of a exit relay that is based on bandwidth observed by the relay and bandwidth measured by the directory authorities.")).labelNames("fingerprint", "nickname")).register(registry);
    private static Gauge networkExitFractionGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("network_exit_fraction")).help("Metric of a exit relay that is based on bandwidth observed by the relay and bandwidth measured by the directory authorities as a fraction of the total network weight.")).labelNames("fingerprint", "nickname")).register(registry);
    private static Gauge totalNetworkExitWeightGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("total_network_exit_weight")).help("Metric based on bandwidth observed by exit relays and bandwidth measured by the directory authorities.")).register(registry);
    private static final Set<String> WEIGHT_KEYS = new HashSet<String>(Arrays.asList("Wgg", "Wgd", "Wmg", "Wmm", "Wme", "Wmd", "Wee", "Wed"));
    private static Map<String, ArrayList> relayWeights = new HashMap<String, ArrayList>();
    private static Map<String, ArrayList> relayWeightsFractions = new HashMap<String, ArrayList>();
    private double totalConsensusWeight = 0.0;
    private double totalGuardWeight = 0.0;
    private double totalMiddleWeight = 0.0;
    private double totalExitWeight = 0.0;

    public void run(String path, Connection conn) throws Exception {
        DescriptorUtils descUtils = new DescriptorUtils();
        DescriptorReader descriptorReader = DescriptorSourceFactory.createDescriptorReader();
        for (Descriptor descriptor : descriptorReader.readDescriptors(new File(path))) {
            Serializable entry;
            String fingerprint;
            if (!(descriptor instanceof RelayNetworkStatusConsensus)) continue;
            RelayNetworkStatusConsensus desc = (RelayNetworkStatusConsensus)descriptor;
            double wgg = 0.0;
            double wgd = 0.0;
            double wmg = 0.0;
            double wme = 0.0;
            double wmm = 0.0;
            double wee = 0.0;
            double wmd = 0.0;
            double wed = 0.0;
            boolean consensusContainsBandwidthWeights = false;
            if (desc.getBandwidthWeights() == null || !desc.getBandwidthWeights().keySet().containsAll(WEIGHT_KEYS)) {
                logger.debug("Not calculating new path selection probabilities, because we could not determine most recent Wxx parameter values, probably because we didn't parse a consensus in this execution.");
                continue;
            }
            consensusContainsBandwidthWeights = true;
            wgg = (double)((Integer)desc.getBandwidthWeights().get("Wgg")).intValue() / 10000.0;
            wgd = (double)((Integer)desc.getBandwidthWeights().get("Wgd")).intValue() / 10000.0;
            wmg = (double)((Integer)desc.getBandwidthWeights().get("Wmg")).intValue() / 10000.0;
            wme = (double)((Integer)desc.getBandwidthWeights().get("Wme")).intValue() / 10000.0;
            wmm = (double)((Integer)desc.getBandwidthWeights().get("Wmm")).intValue() / 10000.0;
            wee = (double)((Integer)desc.getBandwidthWeights().get("Wee")).intValue() / 10000.0;
            wmd = (double)((Integer)desc.getBandwidthWeights().get("Wmd")).intValue() / 10000.0;
            wed = (double)((Integer)desc.getBandwidthWeights().get("Wed")).intValue() / 10000.0;
            for (Map.Entry<String, NetworkStatusEntry> entry2 : desc.getStatusEntries().entrySet()) {
                fingerprint = entry2.getKey();
                entry = entry2.getValue();
                boolean isRunning = entry.getFlags().contains("Running");
                double guardWeight = 0.0;
                double middleWeight = 0.0;
                double exitWeight = 0.0;
                double consensusWeight = entry.getBandwidth();
                if (!isRunning) continue;
                boolean isExit = entry.getFlags().contains("Exit") && !entry.getFlags().contains("BadExit");
                boolean isGuard = entry.getFlags().contains("Guard");
                this.totalConsensusWeight += consensusWeight;
                if (consensusContainsBandwidthWeights) {
                    if (isGuard && isExit) {
                        guardWeight = consensusWeight * wgd;
                        middleWeight = consensusWeight * wmd;
                        exitWeight = consensusWeight * wed;
                    } else if (isGuard) {
                        guardWeight = consensusWeight * wgg;
                        middleWeight = consensusWeight * wmg;
                    } else if (isExit) {
                        middleWeight = consensusWeight * wme;
                        exitWeight = consensusWeight * wee;
                    } else {
                        middleWeight = consensusWeight * wmm;
                    }
                }
                this.totalGuardWeight += guardWeight;
                this.totalMiddleWeight += middleWeight;
                this.totalExitWeight += exitWeight;
                ArrayList<Double> tuple = new ArrayList<Double>();
                tuple.add(consensusWeight);
                tuple.add(guardWeight);
                tuple.add(middleWeight);
                tuple.add(exitWeight);
                relayWeights.put(fingerprint, tuple);
            }
            for (Map.Entry<String, Serializable> entry3 : relayWeights.entrySet()) {
                fingerprint = entry3.getKey();
                entry = (ArrayList)entry3.getValue();
                ArrayList<Number> tuple = new ArrayList<Number>();
                double consensusWeight = (Double)((ArrayList)entry).get(0);
                double guardWeight = (Double)((ArrayList)entry).get(1);
                double middleWeight = (Double)((ArrayList)entry).get(2);
                double exitWeight = (Double)((ArrayList)entry).get(3);
                if (consensusContainsBandwidthWeights) {
                    tuple.add(Float.valueOf((float)(consensusWeight / this.totalConsensusWeight)));
                    tuple.add(Float.valueOf((float)(guardWeight / this.totalGuardWeight)));
                    tuple.add(Float.valueOf((float)(middleWeight / this.totalMiddleWeight)));
                    tuple.add(Float.valueOf((float)(exitWeight / this.totalExitWeight)));
                } else {
                    tuple.add((double)((float)consensusWeight) / this.totalConsensusWeight);
                    tuple.add(Float.valueOf(0.0f));
                    tuple.add(Float.valueOf(0.0f));
                    tuple.add(Float.valueOf(0.0f));
                }
                relayWeightsFractions.put(fingerprint, tuple);
            }
            String digest = descUtils.calculateDigestSha256Base64(desc.getRawDescriptorBytes());
            this.addNetworkStatus(desc, digest, conn, this.totalConsensusWeight, this.totalGuardWeight, this.totalMiddleWeight, this.totalExitWeight);
            for (Map.Entry<String, NetworkStatusEntry> e : desc.getStatusEntries().entrySet()) {
                String fingerprint2 = e.getKey();
                NetworkStatusEntry entry2 = e.getValue();
                String flavor = "unflavored";
                if (desc.getConsensusFlavor() == "microdesc") {
                    flavor = "microdesc";
                }
                ArrayList weightsFractions = relayWeightsFractions.get(fingerprint2);
                ArrayList weights = relayWeights.get(fingerprint2);
                this.addRelayStatus(entry2, digest, conn, flavor, weights, weightsFractions);
            }
        }
        opWriter.pushToGateway(registry);
    }

    private void addRelayStatus(NetworkStatusEntry entry, String digest, Connection conn, String flavor, ArrayList weights, ArrayList weightsFractions) {
        String entryDigest;
        PreparedStatement preparedStatement;
        DescriptorUtils descUtils = new DescriptorUtils();
        double guardWeight = (Double)weights.get(1);
        double middleWeight = (Double)weights.get(2);
        double exitWeight = (Double)weights.get(3);
        float networkFraction = ((Float)weightsFractions.get(0)).floatValue();
        float guardFraction = ((Float)weightsFractions.get(1)).floatValue();
        float middleFraction = ((Float)weightsFractions.get(2)).floatValue();
        float exitFraction = ((Float)weightsFractions.get(3)).floatValue();
        try {
            preparedStatement = conn.prepareStatement(INSERT_NETWORK_STATUS_ENTRY_SQL);
            try {
                preparedStatement.setString(1, entry.getNickname());
                preparedStatement.setString(2, entry.getFingerprint());
                entryDigest = descUtils.calculateDigestSha256Base64(entry.getStatusEntryBytes());
                preparedStatement.setString(3, entryDigest);
                preparedStatement.setTimestamp(4, new Timestamp(entry.getPublishedMillis()));
                preparedStatement.setString(5, entry.getAddress());
                preparedStatement.setInt(6, entry.getOrPort());
                preparedStatement.setInt(7, entry.getDirPort());
                preparedStatement.setString(8, entry.getOrAddresses().toString());
                preparedStatement.setString(9, descUtils.fieldAsString(entry.getFlags()));
                preparedStatement.setString(10, entry.getVersion());
                preparedStatement.setBoolean(11, entry.getUnmeasured());
                preparedStatement.setLong(12, entry.getBandwidth());
                preparedStatement.setString(13, descUtils.fieldAsString(entry.getProtocols()));
                preparedStatement.setString(14, entry.getDefaultPolicy());
                preparedStatement.setString(15, entry.getPortList());
                preparedStatement.setString(16, flavor);
                preparedStatement.setString(17, descUtils.fieldAsString(entry.getMicrodescriptorDigestsSha256Base64()));
                preparedStatement.setString(18, descUtils.fieldAsString(entry.getStats()));
                preparedStatement.setString(19, entry.getMasterKeyEd25519());
                preparedStatement.setString(20, digest);
                preparedStatement.executeUpdate();
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        catch (SQLException ex) {
            logger.warn(String.format(ex.getMessage(), new Object[0]));
        }
        catch (DescriptorParseException ex) {
            logger.warn(String.format(ex.getMessage(), new Object[0]));
        }
        try {
            preparedStatement = conn.prepareStatement(INSERT_NETWORK_STATUS_ENTRY_WEIGHTS_SQL);
            try {
                preparedStatement.setDouble(1, guardWeight);
                preparedStatement.setDouble(2, middleWeight);
                preparedStatement.setDouble(3, exitWeight);
                preparedStatement.setFloat(4, guardFraction);
                preparedStatement.setFloat(5, middleFraction);
                preparedStatement.setFloat(6, exitFraction);
                preparedStatement.setFloat(7, networkFraction);
                preparedStatement.setTimestamp(8, new Timestamp(entry.getPublishedMillis()));
                entryDigest = descUtils.calculateDigestSha256Base64(entry.getStatusEntryBytes());
                preparedStatement.setString(9, entryDigest);
                preparedStatement.executeUpdate();
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        catch (SQLException ex) {
            logger.warn(String.format(ex.getMessage(), new Object[0]));
        }
        catch (DescriptorParseException ex) {
            logger.warn(String.format(ex.getMessage(), new Object[0]));
        }
        try {
            opWriter.processRequest(bwGauge, entry.getFingerprint(), entry.getNickname(), null, entry.getPublishedMillis(), entry.getBandwidth());
            if (entry.getFlags().contains("Running")) {
                opWriter.processRouterLabelmetrics(descStatusGauge, entry.getFingerprint(), entry.getNickname(), "relay", "", "", "", entry.getPublishedMillis(), 0.0);
                opWriter.processRequest(networkWeightGauge, entry.getFingerprint(), entry.getNickname(), null, entry.getPublishedMillis(), entry.getBandwidth());
                opWriter.processRequest(networkGuardWeightGauge, entry.getFingerprint(), entry.getNickname(), null, entry.getPublishedMillis(), guardWeight);
                opWriter.processRequest(networkMiddleWeightGauge, entry.getFingerprint(), entry.getNickname(), null, entry.getPublishedMillis(), middleWeight);
                opWriter.processRequest(networkExitWeightGauge, entry.getFingerprint(), entry.getNickname(), null, entry.getPublishedMillis(), exitWeight);
                opWriter.processRequest(networkFractionGauge, entry.getFingerprint(), entry.getNickname(), null, entry.getPublishedMillis(), networkFraction);
                opWriter.processRequest(networkGuardFractionGauge, entry.getFingerprint(), entry.getNickname(), null, entry.getPublishedMillis(), guardFraction);
                opWriter.processRequest(networkMiddleFractionGauge, entry.getFingerprint(), entry.getNickname(), null, entry.getPublishedMillis(), middleFraction);
                opWriter.processRequest(networkExitFractionGauge, entry.getFingerprint(), entry.getNickname(), null, entry.getPublishedMillis(), exitFraction);
            }
        }
        catch (Exception ex) {
            logger.warn(String.format(ex.getMessage(), new Object[0]));
        }
    }

    private void addNetworkStatus(RelayNetworkStatusConsensus desc, String digest, Connection conn, double totalConsensusWeight, double totalGuardWeight, double totalMiddleWeight, double totalExitWeight) {
        PreparedStatement preparedStatement;
        DescriptorUtils descUtils = new DescriptorUtils();
        try {
            preparedStatement = conn.prepareStatement(INSERT_NETWORK_STATUS_SQL);
            try {
                String consensusType = "";
                consensusType = desc.getConsensusFlavor() != null ? consensusType + "@type network-status-" + desc.getConsensusFlavor() + "-consensus-" : consensusType + "@type network-status-consensus-";
                consensusType = consensusType + String.valueOf(desc.getNetworkStatusVersion());
                consensusType = consensusType + " 1.0";
                preparedStatement.setString(1, consensusType);
                preparedStatement.setInt(2, desc.getNetworkStatusVersion());
                preparedStatement.setString(3, "consensus");
                preparedStatement.setInt(4, desc.getConsensusMethod());
                if (desc.getConsensusFlavor() != null) {
                    preparedStatement.setString(5, desc.getConsensusFlavor());
                } else {
                    preparedStatement.setString(5, "unflavored");
                }
                preparedStatement.setTimestamp(6, new Timestamp(desc.getValidAfterMillis()));
                preparedStatement.setTimestamp(7, new Timestamp(desc.getFreshUntilMillis()));
                preparedStatement.setTimestamp(8, new Timestamp(desc.getValidUntilMillis()));
                preparedStatement.setLong(9, desc.getVoteSeconds());
                preparedStatement.setLong(10, desc.getDistSeconds());
                preparedStatement.setString(11, descUtils.fieldAsString(desc.getKnownFlags()));
                preparedStatement.setString(12, String.join((CharSequence)", ", desc.getRecommendedClientVersions()));
                preparedStatement.setString(13, String.join((CharSequence)", ", desc.getRecommendedServerVersions()));
                preparedStatement.setString(14, descUtils.fieldAsString(desc.getRecommendedClientProtocols()));
                preparedStatement.setString(15, descUtils.fieldAsString(desc.getRecommendedRelayProtocols()));
                preparedStatement.setString(16, descUtils.fieldAsString(desc.getRequiredClientProtocols()));
                preparedStatement.setString(17, descUtils.fieldAsString(desc.getRequiredRelayProtocols()));
                preparedStatement.setString(18, descUtils.fieldAsString(desc.getConsensusParams()));
                preparedStatement.setString(19, descUtils.fieldAsString(desc.getPackageLines()));
                preparedStatement.setString(20, desc.getSharedRandPreviousValue());
                preparedStatement.setString(21, desc.getSharedRandCurrentValue());
                preparedStatement.setInt(22, desc.getSharedRandPreviousNumReveals());
                preparedStatement.setInt(23, desc.getSharedRandCurrentNumReveals());
                preparedStatement.setString(24, descUtils.fieldAsString(desc.getDirSourceEntries()));
                preparedStatement.setString(25, digest);
                preparedStatement.setString(26, descUtils.fieldAsString(desc.getBandwidthWeights()));
                preparedStatement.setString(27, descUtils.fieldAsString(desc.getSignatures()));
                preparedStatement.executeUpdate();
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        catch (SQLException ex) {
            logger.warn(String.format(ex.getMessage(), new Object[0]));
        }
        try {
            preparedStatement = conn.prepareStatement(INSERT_NETWORK_STATUS_TOTALS_SQL);
            try {
                preparedStatement.setDouble(1, totalConsensusWeight);
                preparedStatement.setDouble(2, totalGuardWeight);
                preparedStatement.setDouble(3, totalMiddleWeight);
                preparedStatement.setDouble(4, totalExitWeight);
                preparedStatement.setTimestamp(5, new Timestamp(desc.getValidAfterMillis()));
                preparedStatement.setString(6, digest);
                preparedStatement.executeUpdate();
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        catch (SQLException ex) {
            logger.warn(String.format(ex.getMessage(), new Object[0]));
        }
        try {
            opWriter.processNetworkTotal(totalNetworkWeightGauge, desc.getValidAfterMillis(), totalConsensusWeight);
            opWriter.processNetworkTotal(totalNetworkGuardWeightGauge, desc.getValidAfterMillis(), totalGuardWeight);
            opWriter.processNetworkTotal(totalNetworkMiddleWeightGauge, desc.getValidAfterMillis(), totalMiddleWeight);
            opWriter.processNetworkTotal(totalNetworkExitWeightGauge, desc.getValidAfterMillis(), totalExitWeight);
        }
        catch (Exception ex) {
            logger.warn(String.format(ex.getMessage(), new Object[0]));
        }
    }
}

