/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.NetworkStatusEntry;
import org.torproject.descriptor.impl.DescriptorImpl;
import org.torproject.descriptor.impl.Key;
import org.torproject.descriptor.impl.ParseHelper;

public class NetworkStatusEntryImpl
implements NetworkStatusEntry {
    private DescriptorImpl parent;
    private int offset;
    private int length;
    private boolean microdescConsensus;
    private List<String> unrecognizedLines;
    private Map<String, Integer> flagIndexes;
    private Map<Integer, String> flagStrings;
    private Set<Key> atMostOnceKeys = EnumSet.of(Key.S, Key.V, Key.PR, Key.W, Key.P);
    private String nickname;
    private String fingerprint;
    private String descriptor;
    private long publishedMillis;
    private String address;
    private int orPort;
    private int dirPort;
    private Set<String> microdescriptorDigests;
    private List<String> orAddresses = new ArrayList<String>();
    private BitSet flags;
    private String version;
    private SortedMap<String, SortedSet<Long>> protocols;
    private long bandwidth = -1L;
    private long measured = -1L;
    private boolean unmeasured = false;
    private String defaultPolicy;
    private String portList;
    private String masterKeyEd25519;

    @Override
    public byte[] getStatusEntryBytes() {
        return this.parent.getRawDescriptorBytes(this.offset, this.length);
    }

    protected List<String> getAndClearUnrecognizedLines() {
        List<String> lines = this.unrecognizedLines;
        this.unrecognizedLines = null;
        return lines;
    }

    protected NetworkStatusEntryImpl(DescriptorImpl parent, int offset, int length, boolean microdescConsensus, Map<String, Integer> flagIndexes, Map<Integer, String> flagStrings) throws DescriptorParseException {
        this.parent = parent;
        this.offset = offset;
        this.length = length;
        this.microdescConsensus = microdescConsensus;
        this.flagIndexes = flagIndexes;
        this.flagStrings = flagStrings;
        this.parseStatusEntryBytes();
        this.clearAtMostOnceKeys();
    }

    private void parsedAtMostOnceKey(Key key) throws DescriptorParseException {
        if (!this.atMostOnceKeys.contains((Object)key)) {
            throw new DescriptorParseException("Duplicate '" + key.keyword + "' line in status entry.");
        }
        this.atMostOnceKeys.remove((Object)key);
    }

    private void parseStatusEntryBytes() throws DescriptorParseException {
        String line;
        Scanner scanner = this.parent.newScanner(this.offset, this.length).useDelimiter("\n");
        if (!scanner.hasNext() || !(line = scanner.next()).startsWith("r ")) {
            throw new DescriptorParseException("Status entry must start with an r line.");
        }
        String[] rlineParts = line.split("[ \t]+");
        this.parseRLine(line, rlineParts);
        block10: while (scanner.hasNext()) {
            line = scanner.next();
            String[] parts = !line.startsWith(Key.OPT.keyword + " ") ? line.split("[ \t]+") : line.substring(Key.OPT.keyword.length() + 1).split("[ \t]+");
            Key key = Key.get(parts[0]);
            switch (key) {
                case A: {
                    this.parseALine(line, parts);
                    continue block10;
                }
                case S: {
                    this.parseSLine(parts);
                    continue block10;
                }
                case V: {
                    this.parseVLine(line);
                    continue block10;
                }
                case PR: {
                    this.parsePrLine(line, parts);
                    continue block10;
                }
                case W: {
                    this.parseWLine(line, parts);
                    continue block10;
                }
                case P: {
                    this.parsePLine(line, parts);
                    continue block10;
                }
                case M: {
                    this.parseMLine(line, parts);
                    continue block10;
                }
                case ID: {
                    this.parseIdLine(line, parts);
                    continue block10;
                }
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList<String>();
            }
            this.unrecognizedLines.add(line);
        }
    }

    private void parseRLine(String line, String[] parts) throws DescriptorParseException {
        if (!this.microdescConsensus && parts.length != 9 || this.microdescConsensus && parts.length != 8) {
            throw new DescriptorParseException("r line '" + line + "' has fewer space-separated elements than expected.");
        }
        this.nickname = ParseHelper.parseNickname(line, parts[1]);
        this.fingerprint = ParseHelper.convertTwentyByteBase64StringToHex(line, parts[2]);
        int descriptorOffset = 0;
        if (!this.microdescConsensus) {
            this.descriptor = ParseHelper.convertTwentyByteBase64StringToHex(line, parts[3]);
            descriptorOffset = 1;
        }
        this.publishedMillis = ParseHelper.parseTimestampAtIndex(line, parts, 3 + descriptorOffset, 4 + descriptorOffset);
        this.address = ParseHelper.parseIpv4Address(line, parts[5 + descriptorOffset]);
        this.orPort = ParseHelper.parsePort(line, parts[6 + descriptorOffset]);
        this.dirPort = ParseHelper.parsePort(line, parts[7 + descriptorOffset]);
    }

    private void parseALine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 2) {
            throw new DescriptorParseException("Invalid line '" + line + "' in status entry.");
        }
        this.orAddresses.add(parts[1]);
    }

    private void parseSLine(String[] parts) throws DescriptorParseException {
        this.parsedAtMostOnceKey(Key.S);
        BitSet flags = new BitSet(this.flagIndexes.size());
        for (int i = 1; i < parts.length; ++i) {
            String flag = parts[i];
            if (!this.flagIndexes.containsKey(flag)) {
                this.flagStrings.put(this.flagIndexes.size(), flag);
                this.flagIndexes.put(flag, this.flagIndexes.size());
            }
            flags.set(this.flagIndexes.get(flag));
        }
        this.flags = flags;
    }

    private void parseVLine(String line) throws DescriptorParseException {
        this.parsedAtMostOnceKey(Key.V);
        String noOptLine = line;
        if (noOptLine.startsWith(Key.OPT.keyword + " ")) {
            noOptLine = noOptLine.substring(4);
        }
        if (noOptLine.length() < 3) {
            throw new DescriptorParseException("Invalid line '" + line + "' in status entry.");
        }
        this.version = noOptLine.substring(2);
    }

    private void parsePrLine(String line, String[] parts) throws DescriptorParseException {
        this.parsedAtMostOnceKey(Key.PR);
        this.protocols = ParseHelper.parseProtocolVersions(line, line, parts);
    }

    private void parseWLine(String line, String[] parts) throws DescriptorParseException {
        this.parsedAtMostOnceKey(Key.W);
        SortedMap<String, Integer> pairs = ParseHelper.parseKeyValueIntegerPairs(line, parts, 1);
        if (pairs.isEmpty()) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        if (pairs.containsKey("Bandwidth")) {
            this.bandwidth = ((Integer)pairs.remove("Bandwidth")).intValue();
        }
        if (pairs.containsKey("Measured")) {
            this.measured = ((Integer)pairs.remove("Measured")).intValue();
        }
        if (pairs.containsKey("Unmeasured")) {
            this.unmeasured = (long)((Integer)pairs.remove("Unmeasured")).intValue() == 1L;
        }
    }

    private void parsePLine(String line, String[] parts) throws DescriptorParseException {
        this.parsedAtMostOnceKey(Key.P);
        boolean isValid = true;
        if (parts.length != 3) {
            isValid = false;
        } else {
            block4 : switch (parts[1]) {
                case "accept": 
                case "reject": {
                    String[] ports;
                    this.defaultPolicy = parts[1];
                    this.portList = parts[2];
                    for (String port : ports = parts[2].split(",", -1)) {
                        if (port.length() >= 1) continue;
                        isValid = false;
                        break block4;
                    }
                    break;
                }
                default: {
                    isValid = false;
                }
            }
        }
        if (!isValid) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    private void parseMLine(String line, String[] parts) throws DescriptorParseException {
        if (this.microdescriptorDigests == null) {
            this.microdescriptorDigests = new HashSet<String>();
        }
        if (parts.length == 2) {
            ParseHelper.verifyThirtyTwoByteBase64String(line, parts[1]);
            this.microdescriptorDigests.add(parts[1]);
        } else if (parts.length == 3 && parts[2].length() > 7) {
            ParseHelper.verifyThirtyTwoByteBase64String(line, parts[2].substring(7));
            this.microdescriptorDigests.add(parts[2].substring(7));
        }
    }

    private void parseIdLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 3 || !"ed25519".equals(parts[1])) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        if ("none".equals(parts[2])) {
            this.masterKeyEd25519 = "none";
        } else {
            ParseHelper.verifyThirtyTwoByteBase64String(line, parts[2]);
            this.masterKeyEd25519 = parts[2];
        }
    }

    private void clearAtMostOnceKeys() {
        this.atMostOnceKeys = null;
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public String getDescriptor() {
        return this.descriptor;
    }

    @Override
    public long getPublishedMillis() {
        return this.publishedMillis;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public int getOrPort() {
        return this.orPort;
    }

    @Override
    public int getDirPort() {
        return this.dirPort;
    }

    @Override
    public Set<String> getMicrodescriptorDigestsSha256Base64() {
        return this.microdescriptorDigests == null ? null : new HashSet<String>(this.microdescriptorDigests);
    }

    @Override
    public List<String> getOrAddresses() {
        return new ArrayList<String>(this.orAddresses);
    }

    @Override
    public SortedSet<String> getFlags() {
        TreeSet<String> result = new TreeSet<String>();
        if (this.flags != null) {
            int i = this.flags.nextSetBit(0);
            while (i >= 0) {
                result.add(this.flagStrings.get(i));
                i = this.flags.nextSetBit(i + 1);
            }
        }
        return result;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public SortedMap<String, SortedSet<Long>> getProtocols() {
        return this.protocols;
    }

    @Override
    public long getBandwidth() {
        return this.bandwidth;
    }

    @Override
    public long getMeasured() {
        return this.measured;
    }

    @Override
    public boolean getUnmeasured() {
        return this.unmeasured;
    }

    @Override
    public String getDefaultPolicy() {
        return this.defaultPolicy;
    }

    @Override
    public String getPortList() {
        return this.portList;
    }

    @Override
    public String getMasterKeyEd25519() {
        return this.masterKeyEd25519;
    }
}

