/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.io.File;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import org.torproject.descriptor.BridgedbMetrics;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.impl.DescriptorImpl;
import org.torproject.descriptor.impl.Key;
import org.torproject.descriptor.impl.ParseHelper;

public class BridgedbMetricsImpl
extends DescriptorImpl
implements BridgedbMetrics {
    private static final Set<Key> exactlyOnce = EnumSet.of(Key.BRIDGEDB_METRICS_END, Key.BRIDGEDB_METRICS_VERSION);
    private LocalDateTime bridgedbMetricsEnd;
    private Duration bridgedbMetricsIntervalLength;
    private String bridgedbMetricsVersion;
    private Map<String, Long> bridgedbMetricCounts;

    BridgedbMetricsImpl(byte[] rawDescriptorBytes, int[] offsetAndLength, File descriptorFile) throws DescriptorParseException {
        super(rawDescriptorBytes, offsetAndLength, descriptorFile, false);
        this.parseDescriptorBytes();
        this.checkExactlyOnceKeys(exactlyOnce);
        this.checkFirstKey(Key.BRIDGEDB_METRICS_END);
        this.clearParsedKeys();
    }

    BridgedbMetricsImpl(byte[] rawDescriptorBytes, File descriptorFile) throws DescriptorParseException {
        this(rawDescriptorBytes, new int[]{0, rawDescriptorBytes.length}, descriptorFile);
    }

    private void parseDescriptorBytes() throws DescriptorParseException {
        Scanner scanner = this.newScanner().useDelimiter("\n");
        block5: while (scanner.hasNext()) {
            String line = scanner.next();
            if (line.startsWith("@")) continue;
            String[] parts = line.split("[ \t]+");
            Key key = Key.get(parts[0]);
            switch (key) {
                case BRIDGEDB_METRICS_END: {
                    this.parseBridgedbMetricsEnd(line, parts);
                    continue block5;
                }
                case BRIDGEDB_METRICS_VERSION: {
                    this.parseBridgedbMetricsVersion(line, parts);
                    continue block5;
                }
                case BRIDGEDB_METRIC_COUNT: {
                    this.parseBridgedbMetricCount(line, parts);
                    continue block5;
                }
            }
            ParseHelper.parseKeyword(line, parts[0]);
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.add(line);
        }
    }

    private void parseBridgedbMetricsEnd(String line, String[] parts) throws DescriptorParseException {
        if (parts.length < 5 || parts[3].length() < 2 || !parts[3].startsWith("(") || !parts[4].equals("s)")) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        this.bridgedbMetricsEnd = ParseHelper.parseLocalDateTime(line, parts, 1, 2);
        this.bridgedbMetricsIntervalLength = ParseHelper.parseDuration(line, parts[3].substring(1));
    }

    private void parseBridgedbMetricsVersion(String line, String[] parts) throws DescriptorParseException {
        if (parts.length < 2) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        this.bridgedbMetricsVersion = parts[1];
    }

    private void parseBridgedbMetricCount(String line, String[] parts) throws DescriptorParseException {
        String key;
        if (parts.length < 3) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        if (null == this.bridgedbMetricCounts) {
            this.bridgedbMetricCounts = new LinkedHashMap<String, Long>();
        }
        if (this.bridgedbMetricCounts.containsKey(key = parts[1])) {
            throw new DescriptorParseException("Duplicate key '" + key + "' in line '" + line + "'.");
        }
        long value = ParseHelper.parseLong(line, parts, 2);
        this.bridgedbMetricCounts.put(key, value);
    }

    @Override
    public LocalDateTime bridgedbMetricsEnd() {
        return this.bridgedbMetricsEnd;
    }

    @Override
    public Duration bridgedbMetricsIntervalLength() {
        return this.bridgedbMetricsIntervalLength;
    }

    @Override
    public String bridgedbMetricsVersion() {
        return this.bridgedbMetricsVersion;
    }

    @Override
    public Optional<Map<String, Long>> bridgedbMetricCounts() {
        return Optional.ofNullable(this.bridgedbMetricCounts);
    }
}

