/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.DescriptorCollector;
import org.torproject.descriptor.DescriptorParser;
import org.torproject.descriptor.DescriptorReader;

public final class DescriptorSourceFactory {
    private static Logger log = LoggerFactory.getLogger(DescriptorSourceFactory.class);
    public static final String PARSER_DEFAULT = "org.torproject.descriptor.impl.DescriptorParserImpl";
    public static final String READER_DEFAULT = "org.torproject.descriptor.impl.DescriptorReaderImpl";
    public static final String COLLECTOR_DEFAULT = "org.torproject.descriptor.index.DescriptorIndexCollector";
    public static final String PARSER_PROPERTY = "descriptor.parser";
    public static final String READER_PROPERTY = "descriptor.reader";
    public static final String COLLECTOR_PROPERTY = "descriptor.collector";

    public static final DescriptorParser createDescriptorParser() {
        return (DescriptorParser)DescriptorSourceFactory.retrieve(PARSER_PROPERTY);
    }

    public static final DescriptorReader createDescriptorReader() {
        return (DescriptorReader)DescriptorSourceFactory.retrieve(READER_PROPERTY);
    }

    public static final DescriptorCollector createDescriptorCollector() {
        return (DescriptorCollector)DescriptorSourceFactory.retrieve(COLLECTOR_PROPERTY);
    }

    private static final <T> Object retrieve(String type) {
        Object object;
        String clazzName = null;
        try {
            switch (type) {
                case "descriptor.parser": {
                    clazzName = System.getProperty(type, PARSER_DEFAULT);
                    break;
                }
                case "descriptor.reader": {
                    clazzName = System.getProperty(type, READER_DEFAULT);
                    break;
                }
                case "descriptor.collector": {
                    clazzName = System.getProperty(type, COLLECTOR_DEFAULT);
                    break;
                }
                default: {
                    throw new RuntimeException("Cannot retrieve class for type " + type + ".");
                }
            }
            object = ClassLoader.getSystemClassLoader().loadClass(clazzName).newInstance();
            log.info("Serving implementation {} for {}.", (Object)clazzName, (Object)type);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException("Cannot load class " + clazzName + "for type " + type, ex);
        }
        return object;
    }
}

