/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.qdox.directorywalker;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.hamcrest.generator.qdox.directorywalker.FileVisitor;
import org.hamcrest.generator.qdox.directorywalker.Filter;

public class DirectoryScanner {
    private File file;
    private Collection filters = new HashSet();

    public DirectoryScanner(File file) {
        this.file = file;
    }

    public File[] scan() {
        final ArrayList results = new ArrayList();
        this.walk(new FileVisitor(){

            public void visitFile(File file) {
                results.add(file);
            }
        }, this.file);
        File[] resultsArray = new File[results.size()];
        results.toArray(resultsArray);
        return resultsArray;
    }

    private void walk(FileVisitor visitor, File current) {
        if (current.isDirectory()) {
            File[] currentFiles = current.listFiles();
            for (int i = 0; i < currentFiles.length; ++i) {
                this.walk(visitor, currentFiles[i]);
            }
        } else {
            for (Filter filter : this.filters) {
                if (filter.filter(current)) continue;
                return;
            }
            visitor.visitFile(current);
        }
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public void scan(FileVisitor fileVisitor) {
        this.walk(fileVisitor, this.file);
    }
}

