/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.index;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.index.DirectoryNode;
import org.torproject.descriptor.index.FileNode;
import org.torproject.descriptor.internal.FileType;

public class IndexNode {
    private static Logger log = LoggerFactory.getLogger(IndexNode.class);
    private static final int READ_TIMEOUT = Integer.parseInt(System.getProperty("sun.net.client.defaultReadTimeout", "60000"));
    private static final int CONNECT_TIMEOUT = Integer.parseInt(System.getProperty("sun.net.client.defaultConnectTimeout", "60000"));
    public static final IndexNode emptyNode = new IndexNode("", "", new TreeSet<FileNode>(), new TreeSet<DirectoryNode>());
    @Expose
    @SerializedName(value="index_created")
    public final String created;
    @Expose
    @SerializedName(value="build_revision")
    public final String revision;
    @Expose
    public final String path;
    @Expose
    public final SortedSet<DirectoryNode> directories;
    @Expose
    public final SortedSet<FileNode> files;

    private IndexNode() {
        this.created = null;
        this.revision = null;
        this.path = null;
        this.files = null;
        this.directories = null;
    }

    public IndexNode(String created, String path, SortedSet<FileNode> files, SortedSet<DirectoryNode> directories) {
        this(created, null, path, files, directories);
    }

    public IndexNode(String created, String revision, String path, SortedSet<FileNode> files, SortedSet<DirectoryNode> directories) {
        this.created = created;
        this.revision = revision;
        this.path = path;
        this.files = files;
        this.directories = directories;
    }

    public static IndexNode fetchIndex(String urlString) throws Exception {
        String ending = urlString.substring(urlString.lastIndexOf(".") + 1).toUpperCase();
        URLConnection connection = new URL(urlString).openConnection();
        connection.setReadTimeout(READ_TIMEOUT);
        connection.setConnectTimeout(CONNECT_TIMEOUT);
        connection.connect();
        try (InputStream is = FileType.valueOf(ending).inputStream(connection.getInputStream());){
            IndexNode indexNode = IndexNode.fetchIndex(is);
            return indexNode;
        }
    }

    public static IndexNode fetchIndex(InputStream is) throws IOException {
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        try (InputStreamReader reader = new InputStreamReader(is);){
            IndexNode indexNode = (IndexNode)gson.fromJson((Reader)reader, IndexNode.class);
            return indexNode;
        }
    }

    public SortedMap<String, FileNode> retrieveFilesIn(String ... remoteDirs) {
        TreeMap<String, FileNode> map = new TreeMap<String, FileNode>();
        for (String remote : remoteDirs) {
            DirectoryNode dn;
            String[] dirs;
            DirectoryNode currentDir;
            if (null == remote || remote.isEmpty() || null == (currentDir = IndexNode.findPathIn((dirs = remote.replaceAll("/", " ").trim().split(" "))[0], this.directories))) continue;
            String currentPath = dirs[0] + "/";
            for (int k = 1; k < dirs.length && null != (dn = IndexNode.findPathIn(dirs[k], currentDir.directories)); ++k) {
                currentPath = currentPath + dirs[k] + "/";
                currentDir = dn;
            }
            if (null == currentDir.files) continue;
            for (FileNode file : currentDir.files) {
                if (file.lastModifiedMillis() <= 0L) continue;
                map.put(currentPath + file.path, file);
            }
        }
        return map;
    }

    public static DirectoryNode findPathIn(String path, SortedSet<DirectoryNode> dirs) {
        if (null != dirs) {
            for (DirectoryNode dn : dirs) {
                if (!dn.path.equals(path)) continue;
                return dn;
            }
        }
        return null;
    }

    public static void writeIndex(Path outPath, IndexNode indexNode) throws Exception {
        String ending = outPath.toString().substring(outPath.toString().lastIndexOf(".") + 1).toUpperCase();
        try (OutputStream os = FileType.valueOf(ending).outputStream(Files.newOutputStream(outPath, new OpenOption[0]));){
            os.write(IndexNode.makeJsonString(indexNode).getBytes());
        }
    }

    public static String makeJsonString(IndexNode indexNode) {
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        return gson.toJson((Object)indexNode);
    }

    public String toString() {
        return "index: " + this.path + ", created " + this.created + ",\nfns: " + this.files + ",\ndirs: " + this.directories;
    }
}

