/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.user;

import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserException;
import com.icegreen.greenmail.user.UserImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UserManager {
    Map _users = Collections.synchronizedMap(new HashMap());
    private ImapHostManager imapHostManager;

    public UserManager(ImapHostManager imapHostManager) {
        this.imapHostManager = imapHostManager;
    }

    public GreenMailUser getUser(String login) {
        return (GreenMailUser)this._users.get(login);
    }

    public GreenMailUser getUserByEmail(String email) {
        GreenMailUser ret = this.getUser(email);
        if (null == ret) {
            Iterator it = this._users.values().iterator();
            while (it.hasNext()) {
                GreenMailUser u = (GreenMailUser)it.next();
                if (!u.getEmail().trim().equalsIgnoreCase(email.trim())) continue;
                return u;
            }
        }
        return ret;
    }

    public GreenMailUser createUser(String name, String login, String password) throws UserException {
        UserImpl user = new UserImpl(name, login, password, this.imapHostManager);
        user.create();
        this.addUser(user);
        return user;
    }

    private void addUser(GreenMailUser user) {
        this._users.put(user.getLogin(), user);
    }

    public void deleteUser(GreenMailUser user) throws UserException {
        if ((user = (GreenMailUser)this._users.remove(user.getLogin())) != null) {
            user.delete();
        }
    }

    public boolean test(String userid, String password) {
        GreenMailUser u = this.getUser(userid);
        if (null == u) {
            return false;
        }
        return u.getPassword().equals(password);
    }

    public ImapHostManager getImapHostManager() {
        return this.imapHostManager;
    }
}

