/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.invocation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.mockito.Mockito;
import org.mockito.exceptions.base.MockitoAssertionError;
import org.mockito.exceptions.misusing.NotAMockException;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.creation.DelegatingMethod;
import org.mockito.internal.debugging.Localized;
import org.mockito.internal.exceptions.stacktrace.StackTraceFilter;
import org.mockito.internal.invocation.InvocationImpl;
import org.mockito.internal.invocation.MatchersBinder;
import org.mockito.internal.invocation.MockitoMethod;
import org.mockito.internal.invocation.realmethod.CleanTraceRealMethod;
import org.mockito.internal.invocation.realmethod.RealMethod;
import org.mockito.internal.progress.MockingProgress;
import org.mockito.internal.progress.SequenceNumber;
import org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.mockito.internal.stubbing.InvocationContainer;
import org.mockito.internal.verification.VerificationDataImpl;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.MockHandler;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.internal.invocation.InvocationControlAssertionError;
import org.powermock.api.mockito.internal.invocation.PowerMockMatchersBinder;
import org.powermock.api.mockito.internal.invocation.ToStringGenerator;
import org.powermock.api.mockito.internal.verification.StaticMockAwareVerificationMode;
import org.powermock.api.mockito.repackaged.MethodInterceptorFilter;
import org.powermock.api.support.SafeExceptionRethrower;
import org.powermock.core.MockGateway;
import org.powermock.core.MockRepository;
import org.powermock.core.spi.MethodInvocationControl;
import org.powermock.reflect.Whitebox;
import org.powermock.reflect.internal.WhiteboxImpl;

public class MockitoMethodInvocationControl
implements MethodInvocationControl {
    private final MethodInterceptorFilter methodInterceptorFilter;
    private final Set<Method> mockedMethods;
    private final Object delegator;
    private final Object mockInstance;

    public MockitoMethodInvocationControl(MethodInterceptorFilter methodInterceptionFilter, Object mockInstance, Method ... methodsToMock) {
        this(methodInterceptionFilter, null, mockInstance, methodsToMock);
    }

    public MockitoMethodInvocationControl(MethodInterceptorFilter methodInterceptionFilter, Object delegator, Object mockInstance, Method ... methodsToMock) {
        if (methodInterceptionFilter == null) {
            throw new IllegalArgumentException("Invocation Handler cannot be null.");
        }
        this.mockedMethods = this.toSet(methodsToMock);
        this.mockInstance = mockInstance;
        this.delegator = delegator;
        this.methodInterceptorFilter = methodInterceptionFilter;
    }

    public boolean isMocked(Method method) {
        return this.mockedMethods == null || this.mockedMethods != null && this.mockedMethods.contains(method);
    }

    private boolean isInVerificationMode() {
        return this.getVerificationMode() != null;
    }

    private VerificationMode getVerificationMode() {
        try {
            MockingProgress progress = (MockingProgress)Whitebox.invokeMethod(ThreadSafeMockingProgress.class, (String)"threadSafely", (Object[])new Object[0]);
            return this.getVerificationModeFromMockProgress(progress);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private VerificationMode getVerificationModeFromMockProgress(MockingProgress mockingProgress) {
        if (mockingProgress == null) {
            return null;
        }
        if (mockingProgress instanceof ThreadSafeMockingProgress) {
            ThreadLocal threadLocal = (ThreadLocal)Whitebox.getInternalState((Object)mockingProgress, ThreadLocal.class);
            return this.getVerificationModeFromMockProgress((MockingProgress)threadLocal.get());
        }
        Localized verificationMode = (Localized)Whitebox.getInternalState((Object)mockingProgress, Localized.class);
        return verificationMode == null ? null : (VerificationMode)verificationMode.getObject();
    }

    public Object invoke(Object obj, Method method, Object[] arguments) throws Throwable {
        Object returnValue;
        int methodModifiers = method.getModifiers();
        if (this.hasDelegator() && !Modifier.isPrivate(methodModifiers) && !Modifier.isFinal(methodModifiers) && !Modifier.isStatic(methodModifiers) && this.hasBeenCaughtByMockitoProxy()) {
            returnValue = MockGateway.PROCEED;
        } else {
            boolean inVerificationMode = this.isInVerificationMode();
            if (WhiteboxImpl.isClass((Object)obj) && inVerificationMode) {
                this.handleStaticVerification((Class)obj);
            }
            if ((returnValue = this.performIntercept(this.methodInterceptorFilter, obj, method, arguments)) == null) {
                return MockGateway.SUPPRESS;
            }
        }
        return returnValue;
    }

    private void handleStaticVerification(Class<?> cls) {
        VerificationMode verificationMode = this.getVerificationMode();
        if (verificationMode instanceof StaticMockAwareVerificationMode) {
            ((StaticMockAwareVerificationMode)verificationMode).setClassMock(cls);
        }
    }

    private boolean hasBeenCaughtByMockitoProxy() {
        StackTraceFilter filter = new StackTraceFilter();
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement[] filteredStackTrace = filter.filter(stackTrace, true);
        return filteredStackTrace.length != stackTrace.length;
    }

    private Object performIntercept(MethodInterceptorFilter invocationHandler, final Object interceptionObject, final Method method, Object[] arguments) throws Throwable {
        MockHandler mockHandler = invocationHandler.getHandler();
        CleanTraceRealMethod cglibProxyRealMethod = new CleanTraceRealMethod(new RealMethod(){
            private static final long serialVersionUID = 4564320968038564170L;

            public Object invoke(Object target, Object[] arguments) throws Throwable {
                boolean isFinalSystemClass;
                Class type = Whitebox.getType((Object)interceptionObject);
                boolean bl = isFinalSystemClass = type.getName().startsWith("java.") && Modifier.isFinal(type.getModifiers());
                if (!isFinalSystemClass) {
                    MockRepository.putAdditionalState((String)"DontMockNextCall", (Object)true);
                }
                try {
                    return method.invoke(target, arguments);
                }
                catch (InvocationTargetException e) {
                    SafeExceptionRethrower.safeRethrow((Throwable)e.getCause());
                    return null;
                }
            }
        });
        InvocationImpl invocation = new InvocationImpl(interceptionObject, (MockitoMethod)new DelegatingMethod(method), arguments, SequenceNumber.next(), (RealMethod)cglibProxyRealMethod){
            private static final long serialVersionUID = -3679957412502758558L;

            public String toString() {
                return new ToStringGenerator().generate(this.getMock(), this.getMethod(), this.getArguments());
            }
        };
        try {
            return this.replaceMatchersBinderIfNeeded(mockHandler).handle((Invocation)invocation);
        }
        catch (NotAMockException e) {
            if (invocation.getMock().getClass().getName().startsWith("java.") && MockRepository.getInstanceMethodInvocationControl((Object)invocation.getMock()) != null) {
                return invocation.callRealMethod();
            }
            throw e;
        }
        catch (MockitoAssertionError e) {
            InvocationControlAssertionError.updateErrorMessageForMethodInvocation((AssertionError)((Object)e));
            throw e;
        }
    }

    private MockHandler replaceMatchersBinderIfNeeded(MockHandler mockHandler) {
        if (!Whitebox.getFieldsOfType((Object)mockHandler, MatchersBinder.class).isEmpty()) {
            Whitebox.setInternalState((Object)mockHandler, (Object)((Object)new PowerMockMatchersBinder()), (Object[])new Object[0]);
        } else if (!Whitebox.getFieldsOfType((Object)mockHandler, InternalMockHandler.class).isEmpty()) {
            MockHandler internalMockHandler = (MockHandler)Whitebox.getInternalState((Object)mockHandler, MockHandler.class);
            return this.replaceMatchersBinderIfNeeded(internalMockHandler);
        }
        return mockHandler;
    }

    public Object replay(Object ... mocks) {
        throw new IllegalStateException("Internal error: No such thing as replay exists in Mockito.");
    }

    public Object reset(Object ... mocks) {
        throw new IllegalStateException("Internal error: No such thing as reset exists in Mockito.");
    }

    public Object verify(Object ... mocks) {
        if (mocks == null || mocks.length != 1) {
            throw new IllegalArgumentException("Must supply one mock to the verify method.");
        }
        return Mockito.verify((Object)mocks[0]);
    }

    public void verifyNoMoreInteractions() {
        try {
            MockHandler mockHandler = this.methodInterceptorFilter.getHandler();
            if (!(mockHandler instanceof MockHandler)) {
                throw new RuntimeException("Cannot perform verifyNoMoreInteractions because of unknown mockhandler type " + mockHandler.getClass());
            }
            InvocationContainer invocationContainer = (InvocationContainer)Whitebox.invokeMethod((Object)mockHandler, (String)"getInvocationContainer", (Object[])new Object[0]);
            VerificationDataImpl data = new VerificationDataImpl(invocationContainer, null);
            VerificationModeFactory.noMoreInteractions().verify((VerificationData)data);
        }
        catch (MockitoAssertionError e) {
            InvocationControlAssertionError.updateErrorMessageForVerifyNoMoreInteractions((AssertionError)((Object)e));
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("PowerMock internal error", e);
        }
    }

    private Set<Method> toSet(Method ... methods) {
        return methods == null ? null : new HashSet<Method>(Arrays.asList(methods));
    }

    private boolean hasDelegator() {
        return this.delegator != null;
    }

    public MethodInterceptorFilter getInvocationHandler() {
        return this.methodInterceptorFilter;
    }
}

