/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal;

import java.lang.reflect.Modifier;
import nl.jqno.equalsverifier.internal.Util;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.ByteBuddy;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.TypeValidation;
import nl.jqno.equalsverifier.internal.lib.objenesis.Objenesis;
import nl.jqno.equalsverifier.internal.lib.objenesis.ObjenesisStd;

public final class Instantiator<T> {
    private final Class<T> type;
    private Objenesis objenesis;

    private Instantiator(Class<T> type) {
        this.type = type;
        this.objenesis = new ObjenesisStd();
    }

    public static <T> Instantiator<T> of(Class<T> type) {
        if (Modifier.isAbstract(type.getModifiers())) {
            return new Instantiator<T>(Instantiator.giveDynamicSubclass(type));
        }
        return new Instantiator<T>(type);
    }

    public T instantiate() {
        return this.objenesis.newInstance(this.type);
    }

    public T instantiateAnonymousSubclass() {
        Class<T> proxyClass = Instantiator.giveDynamicSubclass(this.type);
        return this.objenesis.newInstance(proxyClass);
    }

    private static <S> Class<S> giveDynamicSubclass(Class<S> superclass) {
        boolean isSystemClass = superclass.getName().startsWith("java");
        String namePrefix = isSystemClass ? "$" : "";
        String name = namePrefix + superclass.getName() + "$$DynamicSubclass";
        Class<?> existsAlready = Util.classForName(name);
        if (existsAlready != null) {
            return existsAlready;
        }
        ClassLoader classLoader = isSystemClass ? Instantiator.class.getClassLoader() : superclass.getClassLoader();
        return new ByteBuddy().with(TypeValidation.DISABLED).subclass(superclass).name(name).make().load(classLoader, ClassLoadingStrategy.Default.INJECTION).getLoaded();
    }
}

