/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.LogEventRequestAndResponse;
import org.mockserver.model.ObjectWithJsonToString;
import org.mockserver.model.OpenAPIDefinition;
import org.mockserver.model.RequestDefinition;
import org.mockserver.serialization.model.DTO;
import org.mockserver.serialization.model.HttpRequestDTO;
import org.mockserver.serialization.model.HttpResponseDTO;
import org.mockserver.serialization.model.OpenAPIDefinitionDTO;
import org.mockserver.serialization.model.RequestDefinitionDTO;

public class LogEventRequestAndResponseDTO
extends ObjectWithJsonToString
implements DTO<LogEventRequestAndResponse> {
    private String timestamp;
    private RequestDefinitionDTO httpRequest;
    private HttpResponseDTO httpResponse;

    public LogEventRequestAndResponseDTO() {
    }

    public LogEventRequestAndResponseDTO(LogEventRequestAndResponse httpRequestAndHttpResponse) {
        if (httpRequestAndHttpResponse != null) {
            RequestDefinition httpRequest = httpRequestAndHttpResponse.getHttpRequest();
            if (httpRequest instanceof HttpRequest) {
                this.httpRequest = new HttpRequestDTO((HttpRequest)httpRequest);
            } else if (httpRequest instanceof OpenAPIDefinition) {
                this.httpRequest = new OpenAPIDefinitionDTO((OpenAPIDefinition)httpRequest);
            }
            HttpResponse httpResponse = httpRequestAndHttpResponse.getHttpResponse();
            if (httpResponse != null) {
                this.httpResponse = new HttpResponseDTO(httpResponse);
            }
            this.timestamp = httpRequestAndHttpResponse.getTimestamp();
        }
    }

    @Override
    public LogEventRequestAndResponse buildObject() {
        RequestDefinition httpRequest = null;
        HttpResponse httpResponse = null;
        if (this.httpRequest != null) {
            httpRequest = this.httpRequest.buildObject();
        }
        if (this.httpResponse != null) {
            httpResponse = this.httpResponse.buildObject();
        }
        return new LogEventRequestAndResponse().withHttpRequest(httpRequest).withHttpResponse(httpResponse).withTimestamp(this.timestamp);
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public RequestDefinitionDTO getHttpRequest() {
        return this.httpRequest;
    }

    public void setHttpRequest(HttpRequestDTO httpRequest) {
        this.httpRequest = httpRequest;
    }

    public HttpResponseDTO getHttpResponse() {
        return this.httpResponse;
    }

    public void setHttpResponse(HttpResponseDTO httpResponse) {
        this.httpResponse = httpResponse;
    }
}

