/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.echo.http;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.mockserver.configuration.Configuration;
import org.mockserver.echo.http.EchoServerInitializer;
import org.mockserver.log.MockServerEventLog;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.stop.Stoppable;
import org.slf4j.event.Level;

public class EchoServer
implements Stoppable {
    static final AttributeKey<MockServerEventLog> LOG_FILTER = AttributeKey.valueOf((String)"SERVER_LOG_FILTER");
    static final AttributeKey<NextResponse> NEXT_RESPONSE = AttributeKey.valueOf((String)"NEXT_RESPONSE");
    static final AttributeKey<LastRequest> LAST_REQUEST = AttributeKey.valueOf((String)"LAST_REQUEST");
    private static final MockServerLogger mockServerLogger = new MockServerLogger(EchoServer.class);
    private final Configuration configuration = Configuration.configuration();
    private final Scheduler scheduler = new Scheduler(this.configuration, mockServerLogger);
    private final MockServerEventLog mockServerEventLog = new MockServerEventLog(this.configuration, mockServerLogger, this.scheduler, true);
    private final NextResponse nextResponse = new NextResponse();
    private final LastRequest lastRequest = new LastRequest();
    private final CompletableFuture<Integer> boundPort = new CompletableFuture();
    private final List<String> registeredClients = new ArrayList<String>();
    private final List<Channel> websocketChannels = new ArrayList<Channel>();
    private final List<TextWebSocketFrame> textWebSocketFrames = new ArrayList<TextWebSocketFrame>();
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    public EchoServer(boolean secure) {
        this(secure, null, null);
    }

    public EchoServer(SslContext sslContext) {
        this(true, sslContext, null);
    }

    public EchoServer(boolean secure, Error error) {
        this(secure, null, error);
    }

    public EchoServer(boolean secure, SslContext sslContext, Error error) {
        new Scheduler.SchedulerThreadFactory("MockServer EchoServer Thread").newThread(() -> {
            this.bossGroup = new NioEventLoopGroup(3, (ThreadFactory)new Scheduler.SchedulerThreadFactory(this.getClass().getSimpleName() + "-bossEventLoop"));
            this.workerGroup = new NioEventLoopGroup(5, (ThreadFactory)new Scheduler.SchedulerThreadFactory(this.getClass().getSimpleName() + "-workerEventLoop"));
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).handler((ChannelHandler)new LoggingHandler(EchoServer.class))).childHandler((ChannelHandler)new EchoServerInitializer(this.configuration, mockServerLogger, secure, sslContext, error, this.registeredClients, this.websocketChannels, this.textWebSocketFrames)).childAttr(LOG_FILTER, (Object)this.mockServerEventLog).childAttr(NEXT_RESPONSE, (Object)this.nextResponse).childAttr(LAST_REQUEST, (Object)this.lastRequest).bind(0).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    this.boundPort.complete(((InetSocketAddress)future.channel().localAddress()).getPort());
                } else {
                    this.boundPort.completeExceptionally(future.cause());
                }
            }));
        }).start();
        try {
            this.boundPort.get(this.configuration.maxFutureTimeoutInMillis(), TimeUnit.MILLISECONDS);
            TimeUnit.MILLISECONDS.sleep(5L);
        }
        catch (Exception e) {
            mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while waiting for proxy to complete starting up").setThrowable(e));
        }
    }

    @Override
    public void stop() {
        this.scheduler.shutdown();
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }

    @Override
    public void close() {
        this.stop();
    }

    public Integer getPort() {
        try {
            return this.boundPort.get(this.configuration.maxFutureTimeoutInMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public MockServerEventLog mockServerEventLog() {
        return this.mockServerEventLog;
    }

    public void withNextResponse(HttpResponse ... httpResponses) {
        this.nextResponse.httpResponse.addAll(Arrays.asList(httpResponses));
    }

    public void clear() {
        this.nextResponse.httpResponse.clear();
        this.lastRequest.httpRequest.set(new CompletableFuture());
    }

    public HttpRequest getLastRequest() {
        try {
            HttpRequest httpRequest = this.lastRequest.httpRequest.get().get();
            this.lastRequest.httpRequest.set(new CompletableFuture());
            return httpRequest;
        }
        catch (InterruptedException | ExecutionException e) {
            mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while waiting to receive request - " + e.getMessage()).setThrowable(e));
            return null;
        }
    }

    public List<String> getRegisteredClients() {
        return this.registeredClients;
    }

    public List<Channel> getWebsocketChannels() {
        return this.websocketChannels;
    }

    public List<TextWebSocketFrame> getTextWebSocketFrames() {
        return this.textWebSocketFrames;
    }

    public static class LastRequest {
        public final AtomicReference<CompletableFuture<HttpRequest>> httpRequest = new AtomicReference(new CompletableFuture());
    }

    public static class NextResponse {
        public final Queue<HttpResponse> httpResponse = new LinkedList<HttpResponse>();
    }

    public static enum Error {
        CLOSE_CONNECTION,
        LARGER_CONTENT_LENGTH,
        SMALLER_CONTENT_LENGTH,
        RANDOM_BYTES_RESPONSE;

    }
}

