/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import java.util.ArrayList;
import java.util.stream.Stream;
import org.eclipse.jetty.http.pathmap.PathMappings;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ServletPathSpecOrderTest {
    private static PathMappings<String> mappings = new PathMappings();

    public static Stream<Arguments> data() {
        ArrayList<Arguments> data = new ArrayList<Arguments>();
        data.add(Arguments.of((Object[])new Object[]{"/abs/path", "abspath"}));
        data.add(Arguments.of((Object[])new Object[]{"/abs/path/xxx", "default"}));
        data.add(Arguments.of((Object[])new Object[]{"/abs/pith", "default"}));
        data.add(Arguments.of((Object[])new Object[]{"/abs/path/longer", "longpath"}));
        data.add(Arguments.of((Object[])new Object[]{"/abs/path/", "default"}));
        data.add(Arguments.of((Object[])new Object[]{"/abs/path/foo", "default"}));
        data.add(Arguments.of((Object[])new Object[]{"/animal/bird/eagle/bald", "birds"}));
        data.add(Arguments.of((Object[])new Object[]{"/animal/fish/shark/hammerhead", "fishes"}));
        data.add(Arguments.of((Object[])new Object[]{"/animal/insect/ladybug", "animals"}));
        data.add(Arguments.of((Object[])new Object[]{"/animal", "animals"}));
        data.add(Arguments.of((Object[])new Object[]{"/animal/", "animals"}));
        data.add(Arguments.of((Object[])new Object[]{"/animal/other", "animals"}));
        data.add(Arguments.of((Object[])new Object[]{"/animal/*", "animals"}));
        data.add(Arguments.of((Object[])new Object[]{"/downloads/distribution.tar.gz", "tarball"}));
        data.add(Arguments.of((Object[])new Object[]{"/downloads/script.gz", "gzipped"}));
        data.add(Arguments.of((Object[])new Object[]{"/animal/arhive.gz", "animals"}));
        data.add(Arguments.of((Object[])new Object[]{"/Other/path", "default"}));
        data.add(Arguments.of((Object[])new Object[]{"/\u20acuro/path", "money"}));
        data.add(Arguments.of((Object[])new Object[]{"/", "root"}));
        data.add(Arguments.of((Object[])new Object[]{"/downloads/readme.txt", "default"}));
        data.add(Arguments.of((Object[])new Object[]{"/downloads/logs.tgz", "default"}));
        data.add(Arguments.of((Object[])new Object[]{"/main.css", "default"}));
        return data.stream();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testMatch(String inputPath, String expectedResource) {
        MatcherAssert.assertThat((String)("Match on [" + inputPath + "]"), (Object)((String)mappings.getMatched(inputPath).getResource()), (Matcher)Matchers.is((Object)expectedResource));
    }

    static {
        mappings.put((PathSpec)new ServletPathSpec("/abs/path"), (Object)"abspath");
        mappings.put((PathSpec)new ServletPathSpec("/abs/path/longer"), (Object)"longpath");
        mappings.put((PathSpec)new ServletPathSpec("/animal/bird/*"), (Object)"birds");
        mappings.put((PathSpec)new ServletPathSpec("/animal/fish/*"), (Object)"fishes");
        mappings.put((PathSpec)new ServletPathSpec("/animal/*"), (Object)"animals");
        mappings.put((PathSpec)new ServletPathSpec("*.tar.gz"), (Object)"tarball");
        mappings.put((PathSpec)new ServletPathSpec("*.gz"), (Object)"gzipped");
        mappings.put((PathSpec)new ServletPathSpec("/"), (Object)"default");
        mappings.put((PathSpec)new ServletPathSpec(""), (Object)"root");
        mappings.put((PathSpec)new ServletPathSpec("/\u20acuro/*"), (Object)"money");
    }
}

