/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant;

import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.Implementation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackManipulation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackSize;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.MethodVisitor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.Type;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.utility.JavaInstance;

public class MethodTypeConstant
implements StackManipulation {
    private static final StackManipulation.Size SIZE = StackSize.SINGLE.toIncreasingSize();
    private final Type methodType;

    protected MethodTypeConstant(Type methodType) {
        this.methodType = methodType;
    }

    public static StackManipulation of(MethodDescription.InDefinedShape methodDescription) {
        return new MethodTypeConstant(Type.getMethodType(methodDescription.getDescriptor()));
    }

    public static StackManipulation of(JavaInstance.MethodType methodType) {
        Type[] parameterType = new Type[methodType.getParameterTypes().size()];
        int index = 0;
        for (TypeDescription typeDescription : methodType.getParameterTypes()) {
            parameterType[index++] = Type.getType(typeDescription.getDescriptor());
        }
        return new MethodTypeConstant(Type.getMethodType(Type.getType(methodType.getReturnType().getDescriptor()), parameterType));
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitLdcInsn(this.methodType);
        return SIZE;
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.methodType.equals(((MethodTypeConstant)other).methodType);
    }

    public int hashCode() {
        return this.methodType.hashCode();
    }

    public String toString() {
        return "MethodTypeConstant{methodType=" + this.methodType + '}';
    }
}

