/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.server;

import ch.qos.logback.core.net.server.Client;
import ch.qos.logback.core.net.server.ServerSocketListener;
import ch.qos.logback.core.net.server.ServerSocketUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServerSocketListenerTest {
    private ServerSocket serverSocket;
    private ServerSocketListener listener;

    @Before
    public void setUp() throws Exception {
        this.serverSocket = ServerSocketUtil.createServerSocket();
        Assert.assertNotNull((Object)this.serverSocket);
        this.listener = new InstrumentedServerSocketListener(this.serverSocket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAcceptClient() throws Exception {
        RunnableClient localClient = new RunnableClient(InetAddress.getLocalHost(), this.serverSocket.getLocalPort());
        Thread thread = new Thread((Runnable)((Object)localClient));
        thread.start();
        RunnableClient runnableClient = localClient;
        synchronized (runnableClient) {
            int retries = 200;
            while (retries-- > 0 && !localClient.isConnected()) {
                localClient.wait(10L);
            }
        }
        Assert.assertTrue((boolean)localClient.isConnected());
        localClient.close();
        this.serverSocket.setSoTimeout(5000);
        Client client = this.listener.acceptClient();
        Assert.assertNotNull((Object)client);
        client.close();
    }

    private static class RunnableClient
    implements Client {
        private final InetAddress inetAddress;
        private final int port;
        private boolean connected;
        private boolean closed;

        public RunnableClient(InetAddress inetAddress, int port) {
            this.inetAddress = inetAddress;
            this.port = port;
        }

        public synchronized boolean isConnected() {
            return this.connected;
        }

        public synchronized void setConnected(boolean connected) {
            this.connected = connected;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Socket socket = new Socket(this.inetAddress, this.port);
                RunnableClient runnableClient = this;
                synchronized (runnableClient) {
                    this.setConnected(true);
                    this.notifyAll();
                    while (!this.closed && !Thread.currentThread().isInterrupted()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    socket.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }

        public synchronized void close() {
            this.closed = true;
            this.notifyAll();
        }
    }

    private static class RemoteClient
    implements Client {
        private final Socket socket;

        public RemoteClient(Socket socket) {
            this.socket = socket;
        }

        public void run() {
        }

        public void close() {
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    private static class InstrumentedServerSocketListener
    extends ServerSocketListener<RemoteClient> {
        public InstrumentedServerSocketListener(ServerSocket serverSocket) {
            super(serverSocket);
        }

        protected RemoteClient createClient(String id, Socket socket) throws IOException {
            return new RemoteClient(socket);
        }
    }
}

