/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.serializers.schema;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.swagger.v3.oas.models.media.Schema;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.mockserver.serialization.ObjectMapperFactory;

public class AbstractSchemaSerializer<T extends Schema>
extends StdSerializer<T> {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.buildObjectMapperWithOnlyConfigurationDefaults();
    private static final List<String> fieldsToRemove = Collections.singletonList("exampleSetFlag");

    public AbstractSchemaSerializer(Class<T> type) {
        super(type);
    }

    public void serialize(T schema, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        ObjectNode jsonNodes = (ObjectNode)OBJECT_MAPPER.convertValue(schema, ObjectNode.class);
        this.recurse((JsonNode)jsonNodes, node -> {
            if (node instanceof ObjectNode) {
                ((ObjectNode)node).remove(fieldsToRemove);
            }
        });
        jgen.writeObject((Object)jsonNodes);
    }

    private void recurse(JsonNode node, Consumer<JsonNode> jsonNodeCallable) {
        jsonNodeCallable.accept(node);
        for (JsonNode jsonNode : node) {
            this.recurse(jsonNode, jsonNodeCallable);
        }
    }
}

