/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.command;

import java.io.IOException;
import java.util.List;
import org.subethamail.smtp.MessageHandler;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.server.BaseCommand;
import org.subethamail.smtp.server.ConnectionContext;

public class AuthCommand
extends BaseCommand {
    public static final String VERB = "AUTH";
    public static final String AUTH_CANCEL_COMMAND = "*";

    static String getEhloString(MessageHandler handler) {
        List<String> supportedMechanisms = handler.getAuthenticationMechanisms();
        if (supportedMechanisms.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(30);
        sb.append("\r\n");
        sb.append("250-");
        sb.append(VERB);
        sb.append(' ');
        AuthCommand.getTokenizedString(sb, supportedMechanisms, " ");
        return sb.toString();
    }

    public AuthCommand() {
        super(VERB, "Authentication service", "AUTH <mechanism> [initial-response] \n\t mechanism = a string identifying a SASL authentication mechanism,\n\t an optional base64-encoded response");
    }

    public void execute(String commandString, ConnectionContext context) throws IOException {
        if (context.getSession().isAuthenticated()) {
            context.sendResponse("503 Refusing any other AUTH command.");
            return;
        }
        MessageHandler msgHandler = this.getMessageHandler(context);
        boolean authenticating = context.getSession().isAuthenticating();
        if (!authenticating) {
            String[] args = this.getArgs(commandString);
            if (args.length < 2) {
                context.sendResponse("501 Syntax: AUTH mechanism [initial-response]");
                return;
            }
            String mechanism = args[1];
            if (!msgHandler.getAuthenticationMechanisms().contains(mechanism.toUpperCase())) {
                context.sendResponse("504 The requested authentication mechanism is not supported");
                return;
            }
        }
        try {
            if (authenticating && commandString.trim().equals(AUTH_CANCEL_COMMAND)) {
                context.sendResponse("501 Authentication canceled by client.");
                return;
            }
            StringBuilder response = new StringBuilder();
            boolean finished = msgHandler.auth(commandString, response, context);
            context.getSession().setAuthenticating(!finished);
            if (!finished) {
                context.sendResponse(response.toString());
                return;
            }
            context.sendResponse("235 Authentication successful.");
            context.getSession().setAuthenticated(true);
        }
        catch (RejectException authFailed) {
            context.sendResponse("535 Authentication failure.");
            context.getSession().setAuthenticated(false);
            context.getSession().setAuthenticating(false);
        }
    }

    public MessageHandler getMessageHandler(ConnectionContext context) {
        return context.getSession().getMessageHandler();
    }
}

