/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.ExpectationId;
import org.mockserver.serialization.JsonArraySerializer;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.Serializer;
import org.mockserver.validator.jsonschema.JsonSchemaExpectationIdValidator;
import org.mockserver.validator.jsonschema.JsonSchemaValidator;
import org.slf4j.event.Level;

public class ExpectationIdSerializer
implements Serializer<ExpectationId> {
    private final MockServerLogger mockServerLogger;
    private ObjectWriter objectWriter = ObjectMapperFactory.createObjectMapper(true, false, new JsonSerializer[0]);
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private JsonArraySerializer jsonArraySerializer = new JsonArraySerializer();
    private JsonSchemaExpectationIdValidator expectationIdValidator;

    public ExpectationIdSerializer(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
    }

    private JsonSchemaExpectationIdValidator getValidator() {
        if (this.expectationIdValidator == null) {
            this.expectationIdValidator = JsonSchemaExpectationIdValidator.jsonSchemaExpectationIdValidator(this.mockServerLogger);
        }
        return this.expectationIdValidator;
    }

    @Override
    public String serialize(ExpectationId expectationId) {
        try {
            return this.objectWriter.writeValueAsString((Object)expectationId);
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while serializing ExpectationId to JSON with value " + expectationId).setThrowable(e));
            throw new RuntimeException("Exception while serializing ExpectationId to JSON with value " + expectationId, e);
        }
    }

    @Override
    public String serialize(List<? extends ExpectationId> expectationIds) {
        return this.serialize(false, expectationIds);
    }

    public String serialize(boolean prettyPrint, List<? extends ExpectationId> expectationIds) {
        return this.serialize(prettyPrint, expectationIds.toArray(new ExpectationId[0]));
    }

    @Override
    public String serialize(ExpectationId ... expectationIds) {
        return this.serialize(false, expectationIds);
    }

    public String serialize(boolean prettyPrint, ExpectationId ... expectationIds) {
        try {
            if (expectationIds != null && expectationIds.length > 0) {
                return this.objectWriter.writeValueAsString((Object)expectationIds);
            }
            return "[]";
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while serializing ExpectationId to JSON with value " + Arrays.asList(expectationIds)).setThrowable(e));
            throw new RuntimeException("Exception while serializing ExpectationId to JSON with value " + Arrays.asList(expectationIds), e);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ExpectationId deserialize(String jsonExpectationId) {
        if (StringUtils.isBlank((CharSequence)jsonExpectationId)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a request is required but value was \"" + jsonExpectationId + "\"" + Character.NEW_LINE + Character.NEW_LINE + JsonSchemaValidator.OPEN_API_SPECIFICATION_URL);
        }
        if (jsonExpectationId.contains("\"httpRequest\"")) {
            try {
                jsonNode = this.objectMapper.readTree(jsonExpectationId);
                if (!jsonNode.has("httpRequest")) ** GOTO lbl21
                jsonExpectationId = jsonNode.get("httpRequest").toString();
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while parsing{}for ExpectationId " + throwable.getMessage()).setArguments(new Object[]{jsonExpectationId}).setThrowable(throwable));
                throw new IllegalArgumentException("exception while parsing [" + jsonExpectationId + "] for ExpectationId", throwable);
            }
        } else if (jsonExpectationId.contains("\"openAPIDefinition\"")) {
            try {
                jsonNode = this.objectMapper.readTree(jsonExpectationId);
                if (jsonNode.has("openAPIDefinition")) {
                    jsonExpectationId = jsonNode.get("openAPIDefinition").toString();
                }
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while parsing{}for ExpectationId " + throwable.getMessage()).setArguments(new Object[]{jsonExpectationId}).setThrowable(throwable));
                throw new IllegalArgumentException("exception while parsing [" + jsonExpectationId + "] for ExpectationId", throwable);
            }
        }
lbl21:
        // 5 sources

        validationErrors = this.getValidator().isValid(jsonExpectationId);
        if (validationErrors.isEmpty()) {
            try {
                expectationId = (ExpectationId)this.objectMapper.readValue(jsonExpectationId, ExpectationId.class);
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while parsing{}for ExpectationId " + throwable.getMessage()).setArguments(new Object[]{jsonExpectationId}).setThrowable(throwable));
                throw new IllegalArgumentException("exception while parsing [" + jsonExpectationId + "] for ExpectationId", throwable);
            }
            return expectationId;
        }
        throw new IllegalArgumentException(StringUtils.removeEndIgnoreCase((String)StringFormatter.formatLogMessage("incorrect request matcher json format for:{}schema validation errors:{}", new Object[]{jsonExpectationId, validationErrors}), (String)"\n"));
    }

    @Override
    public Class<ExpectationId> supportsType() {
        return ExpectationId.class;
    }

    public ExpectationId[] deserializeArray(String jsonExpectationIds) {
        ArrayList<ExpectationId> expectationIds = new ArrayList<ExpectationId>();
        if (StringUtils.isBlank((CharSequence)jsonExpectationIds)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a request or request array is required but value was \"" + jsonExpectationIds + "\"");
        }
        List<String> jsonRequestList = this.jsonArraySerializer.splitJSONArray(jsonExpectationIds);
        if (jsonRequestList.isEmpty()) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a request or array of request is required");
        }
        ArrayList<String> validationErrorsList = new ArrayList<String>();
        for (String jsonRequest : jsonRequestList) {
            try {
                expectationIds.add(this.deserialize(jsonRequest));
            }
            catch (IllegalArgumentException iae) {
                validationErrorsList.add(iae.getMessage());
            }
        }
        if (!validationErrorsList.isEmpty()) {
            throw new IllegalArgumentException((validationErrorsList.size() > 1 ? "[" : "") + Joiner.on((String)("," + Character.NEW_LINE)).join(validationErrorsList) + (validationErrorsList.size() > 1 ? "]" : ""));
        }
        return expectationIds.toArray(new ExpectationId[0]);
    }
}

