/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.zip.DataFormatException;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.WriterReaderPhaser;

public class ConcurrentHistogram
extends Histogram {
    static final AtomicLongFieldUpdater<ConcurrentHistogram> totalCountUpdater = AtomicLongFieldUpdater.newUpdater(ConcurrentHistogram.class, "totalCount");
    volatile long totalCount;
    volatile AtomicLongArrayWithNormalizingOffset activeCounts;
    volatile AtomicLongArrayWithNormalizingOffset inactiveCounts;
    WriterReaderPhaser wrp = new WriterReaderPhaser();
    private LongBuffer cachedDstLongBuffer = null;
    private ByteBuffer cachedDstByteBuffer = null;
    private int cachedDstByteBufferPosition = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    long getCountAtIndex(int index) {
        try {
            this.wrp.readerLock();
            long activeCount = this.activeCounts.get(this.normalizeIndex(index, this.activeCounts.getNormalizingIndexOffset()));
            long inactiveCount = this.inactiveCounts.get(this.normalizeIndex(index, this.inactiveCounts.getNormalizingIndexOffset()));
            long l = activeCount + inactiveCount;
            return l;
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    long getCountAtNormalizedIndex(int index) {
        try {
            this.wrp.readerLock();
            long activeCount = this.activeCounts.get(index);
            long inactiveCount = this.inactiveCounts.get(index);
            long l = activeCount + inactiveCount;
            return l;
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void incrementCountAtIndex(int index) {
        long criticalValue = this.wrp.writerCriticalSectionEnter();
        try {
            this.activeCounts.incrementAndGet(this.normalizeIndex(index, this.activeCounts.getNormalizingIndexOffset()));
        }
        finally {
            this.wrp.writerCriticalSectionExit(criticalValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void addToCountAtIndex(int index, long value) {
        long criticalValue = this.wrp.writerCriticalSectionEnter();
        try {
            this.activeCounts.addAndGet(this.normalizeIndex(index, this.activeCounts.getNormalizingIndexOffset()), value);
        }
        finally {
            this.wrp.writerCriticalSectionExit(criticalValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setCountAtIndex(int index, long value) {
        try {
            this.wrp.readerLock();
            this.activeCounts.lazySet(this.normalizeIndex(index, this.activeCounts.getNormalizingIndexOffset()), value);
            this.inactiveCounts.lazySet(this.normalizeIndex(index, this.inactiveCounts.getNormalizingIndexOffset()), 0L);
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setCountAtNormalizedIndex(int index, long value) {
        try {
            this.wrp.readerLock();
            this.inactiveCounts.lazySet(index, value);
            this.activeCounts.lazySet(index, 0L);
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    @Override
    int getNormalizingIndexOffset() {
        return this.activeCounts.getNormalizingIndexOffset();
    }

    @Override
    void setNormalizingIndexOffset(int normalizingIndexOffset) {
        this.setNormalizingIndexOffset(normalizingIndexOffset, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNormalizingIndexOffset(int normalizingIndexOffset, int shiftedAmount, boolean lowestHalfBucketPopulated) {
        try {
            this.wrp.readerLock();
            if (normalizingIndexOffset == this.activeCounts.getNormalizingIndexOffset()) {
                return;
            }
            long inactiveZeroValueCount = this.inactiveCounts.get(this.normalizeIndex(0, this.inactiveCounts.getNormalizingIndexOffset()));
            this.inactiveCounts.lazySet(this.normalizeIndex(0, this.inactiveCounts.getNormalizingIndexOffset()), 0L);
            this.inactiveCounts.setNormalizingIndexOffset(normalizingIndexOffset);
            if (shiftedAmount > 0 && lowestHalfBucketPopulated) {
                this.shiftLowestInactiveHalfBucketContentsLeft(shiftedAmount);
            }
            this.inactiveCounts.lazySet(this.normalizeIndex(0, this.inactiveCounts.getNormalizingIndexOffset()), inactiveZeroValueCount);
            AtomicLongArrayWithNormalizingOffset tmp = this.activeCounts;
            this.activeCounts = this.inactiveCounts;
            this.inactiveCounts = tmp;
            this.wrp.flipPhase();
            inactiveZeroValueCount = this.inactiveCounts.get(this.normalizeIndex(0, this.inactiveCounts.getNormalizingIndexOffset()));
            this.inactiveCounts.lazySet(this.normalizeIndex(0, this.inactiveCounts.getNormalizingIndexOffset()), 0L);
            this.inactiveCounts.setNormalizingIndexOffset(normalizingIndexOffset);
            if (shiftedAmount > 0 && lowestHalfBucketPopulated) {
                this.shiftLowestInactiveHalfBucketContentsLeft(shiftedAmount);
            }
            this.inactiveCounts.lazySet(this.normalizeIndex(0, this.inactiveCounts.getNormalizingIndexOffset()), inactiveZeroValueCount);
            tmp = this.activeCounts;
            this.activeCounts = this.inactiveCounts;
            this.inactiveCounts = tmp;
            this.wrp.flipPhase();
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    private void shiftLowestInactiveHalfBucketContentsLeft(int shiftAmount) {
        int numberOfBinaryOrdersOfMagnitude = shiftAmount >> this.subBucketHalfCountMagnitude;
        for (int fromIndex = 1; fromIndex < this.subBucketHalfCount; ++fromIndex) {
            long toValue = this.valueFromIndex(fromIndex) << numberOfBinaryOrdersOfMagnitude;
            int toIndex = this.countsArrayIndex(toValue);
            int normalizedToIndex = this.normalizeIndex(toIndex, this.inactiveCounts.getNormalizingIndexOffset());
            long countAtFromIndex = this.inactiveCounts.get(fromIndex);
            this.inactiveCounts.lazySet(normalizedToIndex, countAtFromIndex);
            this.inactiveCounts.lazySet(fromIndex, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void shiftNormalizingIndexByOffset(int offsetToAdd, boolean lowestHalfBucketPopulated) {
        try {
            this.wrp.readerLock();
            int newNormalizingIndexOffset = this.inactiveCounts.getNormalizingIndexOffset() + offsetToAdd;
            this.setNormalizingIndexOffset(newNormalizingIndexOffset, offsetToAdd, lowestHalfBucketPopulated);
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void resize(long newHighestTrackableValue) {
        try {
            this.wrp.readerLock();
            int oldNormalizedZeroIndex = this.normalizeIndex(0, this.inactiveCounts.getNormalizingIndexOffset());
            this.establishSize(newHighestTrackableValue);
            int countsDelta = this.countsArrayLength - this.inactiveCounts.length();
            AtomicLongArrayWithNormalizingOffset oldInactiveCounts = this.inactiveCounts;
            this.inactiveCounts = new AtomicLongArrayWithNormalizingOffset(this.countsArrayLength, this.inactiveCounts.getNormalizingIndexOffset());
            for (int i = 0; i < oldInactiveCounts.length(); ++i) {
                this.inactiveCounts.lazySet(i, oldInactiveCounts.get(i));
            }
            if (oldNormalizedZeroIndex != 0) {
                int newNormalizedZeroIndex = oldNormalizedZeroIndex + countsDelta;
                int lengthToCopy = this.countsArrayLength - countsDelta - oldNormalizedZeroIndex;
                int src = oldNormalizedZeroIndex;
                int dst = newNormalizedZeroIndex;
                while (src < oldNormalizedZeroIndex + lengthToCopy) {
                    this.inactiveCounts.lazySet(dst, oldInactiveCounts.get(src));
                    ++src;
                    ++dst;
                }
            }
            AtomicLongArrayWithNormalizingOffset tmp = this.activeCounts;
            this.activeCounts = this.inactiveCounts;
            this.inactiveCounts = tmp;
            this.wrp.flipPhase();
            oldInactiveCounts = this.inactiveCounts;
            this.inactiveCounts = new AtomicLongArrayWithNormalizingOffset(this.countsArrayLength, this.inactiveCounts.getNormalizingIndexOffset());
            for (int i = 0; i < oldInactiveCounts.length(); ++i) {
                this.inactiveCounts.lazySet(i, oldInactiveCounts.get(i));
            }
            if (oldNormalizedZeroIndex != 0) {
                int newNormalizedZeroIndex = oldNormalizedZeroIndex + countsDelta;
                int lengthToCopy = this.countsArrayLength - countsDelta - oldNormalizedZeroIndex;
                int src = oldNormalizedZeroIndex;
                int dst = newNormalizedZeroIndex;
                while (src < oldNormalizedZeroIndex + lengthToCopy) {
                    this.inactiveCounts.lazySet(dst, oldInactiveCounts.get(src));
                    ++src;
                    ++dst;
                }
            }
            tmp = this.activeCounts;
            this.activeCounts = this.inactiveCounts;
            this.inactiveCounts = tmp;
            this.wrp.flipPhase();
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    @Override
    public void setAutoResize(boolean autoResize) {
        this.autoResize = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void clearCounts() {
        try {
            this.wrp.readerLock();
            for (int i = 0; i < this.activeCounts.length(); ++i) {
                this.activeCounts.lazySet(i, 0L);
                this.inactiveCounts.lazySet(i, 0L);
            }
            totalCountUpdater.set(this, 0L);
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    @Override
    public ConcurrentHistogram copy() {
        ConcurrentHistogram copy = new ConcurrentHistogram(this);
        copy.add(this);
        return copy;
    }

    @Override
    public ConcurrentHistogram copyCorrectedForCoordinatedOmission(long expectedIntervalBetweenValueSamples) {
        ConcurrentHistogram toHistogram = new ConcurrentHistogram(this);
        toHistogram.addWhileCorrectingForCoordinatedOmission(this, expectedIntervalBetweenValueSamples);
        return toHistogram;
    }

    @Override
    public long getTotalCount() {
        return totalCountUpdater.get(this);
    }

    @Override
    void setTotalCount(long totalCount) {
        totalCountUpdater.set(this, totalCount);
    }

    @Override
    void incrementTotalCount() {
        totalCountUpdater.incrementAndGet(this);
    }

    @Override
    void addToTotalCount(long value) {
        totalCountUpdater.addAndGet(this, value);
    }

    @Override
    int _getEstimatedFootprintInBytes() {
        return 512 + 16 * this.activeCounts.length();
    }

    public ConcurrentHistogram(int numberOfSignificantValueDigits) {
        this(1L, 2L, numberOfSignificantValueDigits);
        this.setAutoResize(true);
    }

    public ConcurrentHistogram(long highestTrackableValue, int numberOfSignificantValueDigits) {
        this(1L, highestTrackableValue, numberOfSignificantValueDigits);
    }

    public ConcurrentHistogram(long lowestDiscernibleValue, long highestTrackableValue, int numberOfSignificantValueDigits) {
        super(lowestDiscernibleValue, highestTrackableValue, numberOfSignificantValueDigits, false);
        this.activeCounts = new AtomicLongArrayWithNormalizingOffset(this.countsArrayLength, 0);
        this.inactiveCounts = new AtomicLongArrayWithNormalizingOffset(this.countsArrayLength, 0);
        this.wordSizeInBytes = 8;
    }

    public ConcurrentHistogram(AbstractHistogram source) {
        super(source, false);
        this.activeCounts = new AtomicLongArrayWithNormalizingOffset(this.countsArrayLength, 0);
        this.inactiveCounts = new AtomicLongArrayWithNormalizingOffset(this.countsArrayLength, 0);
        this.wordSizeInBytes = 8;
    }

    public static ConcurrentHistogram decodeFromByteBuffer(ByteBuffer buffer, long minBarForHighestTrackableValue) {
        return (ConcurrentHistogram)ConcurrentHistogram.decodeFromByteBuffer(buffer, ConcurrentHistogram.class, minBarForHighestTrackableValue);
    }

    public static ConcurrentHistogram decodeFromCompressedByteBuffer(ByteBuffer buffer, long minBarForHighestTrackableValue) throws DataFormatException {
        return (ConcurrentHistogram)ConcurrentHistogram.decodeFromCompressedByteBuffer(buffer, ConcurrentHistogram.class, minBarForHighestTrackableValue);
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        o.defaultReadObject();
    }

    @Override
    synchronized void fillCountsArrayFromBuffer(ByteBuffer buffer, int length) {
        LongBuffer logbuffer = buffer.asLongBuffer();
        for (int i = 0; i < length; ++i) {
            this.inactiveCounts.lazySet(i, logbuffer.get());
            this.activeCounts.lazySet(i, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void fillBufferFromCountsArray(ByteBuffer buffer, int length) {
        if (this.cachedDstLongBuffer == null || buffer != this.cachedDstByteBuffer || buffer.position() != this.cachedDstByteBufferPosition) {
            this.cachedDstByteBuffer = buffer;
            this.cachedDstByteBufferPosition = buffer.position();
            this.cachedDstLongBuffer = buffer.asLongBuffer();
        }
        this.cachedDstLongBuffer.rewind();
        try {
            int i;
            this.wrp.readerLock();
            int zeroIndex = this.normalizeIndex(0, this.getNormalizingIndexOffset());
            int lengthFromZeroIndexToEnd = Math.min(length, this.countsArrayLength - zeroIndex);
            int remainingLengthFromNormalizedZeroIndex = length - lengthFromZeroIndexToEnd;
            for (i = 0; i < lengthFromZeroIndexToEnd; ++i) {
                this.cachedDstLongBuffer.put(this.activeCounts.get(zeroIndex + i) + this.inactiveCounts.get(zeroIndex + i));
            }
            for (i = 0; i < remainingLengthFromNormalizedZeroIndex; ++i) {
                this.cachedDstLongBuffer.put(this.activeCounts.get(i) + this.inactiveCounts.get(i));
            }
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    static class AtomicLongArrayWithNormalizingOffset
    extends AtomicLongArray {
        private int normalizingIndexOffset;

        AtomicLongArrayWithNormalizingOffset(int length, int normalizingIndexOffset) {
            super(length);
            this.normalizingIndexOffset = normalizingIndexOffset;
        }

        public int getNormalizingIndexOffset() {
            return this.normalizingIndexOffset;
        }

        public void setNormalizingIndexOffset(int normalizingIndexOffset) {
            this.normalizingIndexOffset = normalizingIndexOffset;
        }
    }
}

