/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import javax.mail.util.SharedByteArrayInputStream;
import org.subethamail.smtp.AuthenticationHandler;
import org.subethamail.smtp.MessageContext;
import org.subethamail.smtp.MessageHandler;
import org.subethamail.smtp.MessageListener;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.server.ConnectionContext;
import org.subethamail.smtp.server.io.CharTerminatedInputStream;
import org.subethamail.smtp.server.io.DotUnstuffingInputStream;
import org.subethamail.smtp.server.io.SharedTmpFileInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageHandler
implements MessageHandler {
    public static final char[] SMTP_TERMINATOR = new char[]{'\r', '\n', '.', '\r', '\n'};
    private AuthenticationHandler authHandler;
    private Collection<MessageListener> listeners;

    protected AbstractMessageHandler(MessageContext ctx, AuthenticationHandler authHandler) {
        this.authHandler = authHandler;
    }

    protected void setListeners(Collection<MessageListener> listeners) {
        this.listeners = listeners;
    }

    public Collection<MessageListener> getListeners() {
        return this.listeners;
    }

    public InputStream getPrivateInputStream(boolean useCopy, InputStream data) {
        InputStream in = data;
        if (useCopy) {
            if (data instanceof SharedByteArrayInputStream) {
                in = ((SharedByteArrayInputStream)data).newStream(0L, -1L);
            } else if (data instanceof SharedTmpFileInputStream) {
                in = ((SharedTmpFileInputStream)((Object)data)).newStream(0L, -1L);
            } else {
                throw new IllegalArgumentException("Unexpected data stream type : " + data.getClass().getName());
            }
        }
        in = new CharTerminatedInputStream(in, SMTP_TERMINATOR);
        in = new DotUnstuffingInputStream(in);
        return in;
    }

    @Override
    public boolean auth(String clientInput, StringBuilder response, ConnectionContext ctx) throws RejectException {
        return this.authHandler.auth(clientInput, response, ctx);
    }

    @Override
    public void resetState() {
        this.authHandler.resetState();
    }

    @Override
    public List<String> getAuthenticationMechanisms() {
        return this.authHandler.getAuthenticationMechanisms();
    }
}

