/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode;

import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackManipulation;

public enum StackSize {
    ZERO(0),
    SINGLE(1),
    DOUBLE(2);

    private final int size;

    private StackSize(int size) {
        this.size = size;
    }

    public static StackSize of(Class<?> type) {
        if (type == Void.TYPE) {
            return ZERO;
        }
        if (type == Double.TYPE || type == Long.TYPE) {
            return DOUBLE;
        }
        return SINGLE;
    }

    public static int sizeOf(Iterable<? extends Class<?>> types) {
        int size = 0;
        for (Class<?> type : types) {
            size += StackSize.of(type).getSize();
        }
        return size;
    }

    public int getSize() {
        return this.size;
    }

    public StackManipulation.Size toIncreasingSize() {
        return new StackManipulation.Size(this.getSize(), this.getSize());
    }

    public StackManipulation.Size toDecreasingSize() {
        return new StackManipulation.Size(-1 * this.getSize(), 0);
    }

    public StackSize maximum(StackSize stackSize) {
        switch (this) {
            case ZERO: {
                return stackSize;
            }
            case SINGLE: {
                switch (stackSize) {
                    case DOUBLE: {
                        return stackSize;
                    }
                    case SINGLE: 
                    case ZERO: {
                        return this;
                    }
                }
                throw new AssertionError();
            }
            case DOUBLE: {
                return this;
            }
        }
        throw new AssertionError();
    }

    public String toString() {
        return "StackSize." + this.name();
    }
}

