/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.parser.util.SchemaTypeUtil;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.model.NottableString;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.validator.jsonschema.JsonSchemaValidator;
import org.slf4j.event.Level;

public class NottableSchemaString
extends NottableString {
    private static final MockServerLogger MOCK_SERVER_LOGGER = new MockServerLogger(NottableSchemaString.class);
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.createObjectMapper();
    private static final DateTimeFormatter RFC3339 = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd").appendLiteral('T').appendPattern("HH:mm:ss").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).parseDefaulting(ChronoField.NANO_OF_SECOND, 0L).optionalEnd().appendOffset("+HH:mm", "Z").toFormatter();
    private static final String TRUE = "true";
    private final ObjectNode schemaJsonNode;
    private final String type;
    private final String format;
    private final String json;
    private final JsonSchemaValidator jsonSchemaValidator;

    private static JsonNode convertToJsonNode(@Nonnull String value, String type, String format) throws IOException {
        if ("null".equalsIgnoreCase(value)) {
            return OBJECT_MAPPER.readTree("null");
        }
        if ("date-time".equalsIgnoreCase(format)) {
            String result;
            try {
                result = LocalDateTime.parse(value, RFC3339).format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            }
            catch (DateTimeParseException e) {
                result = value;
            }
            return new TextNode(result);
        }
        if ("string".equalsIgnoreCase(type)) {
            return new TextNode(value);
        }
        if ("number".equalsIgnoreCase(type) || "integer".equalsIgnoreCase(type)) {
            try {
                Double.parseDouble(value);
                return OBJECT_MAPPER.readTree(value);
            }
            catch (NumberFormatException nfe) {
                return new TextNode(value);
            }
        }
        return OBJECT_MAPPER.readTree(value);
    }

    private ObjectNode getSchemaJsonNode(String schema) {
        try {
            ObjectNode jsonNodes = (ObjectNode)OBJECT_MAPPER.readTree(schema);
            jsonNodes.remove("not");
            return jsonNodes;
        }
        catch (Throwable throwable) {
            MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception loading JSON Schema " + throwable.getMessage()).setThrowable(throwable));
            return null;
        }
    }

    public static NottableSchemaString schemaString(String value, Boolean not) {
        return new NottableSchemaString(value, not);
    }

    public static NottableSchemaString schemaString(String value) {
        return new NottableSchemaString(value);
    }

    public static NottableSchemaString notSchema(String value) {
        return new NottableSchemaString(value, Boolean.TRUE);
    }

    private NottableSchemaString(String schema, Boolean not) {
        super(schema, not);
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            this.schemaJsonNode = this.getSchemaJsonNode(this.getValue());
            Schema schemaByType = SchemaTypeUtil.createSchemaByType((ObjectNode)this.schemaJsonNode);
            this.type = schemaByType.getType();
            this.format = schemaByType.getFormat();
        } else {
            this.schemaJsonNode = null;
            this.type = null;
            this.format = null;
        }
        this.json = (Boolean.TRUE.equals(this.isNot()) ? Character.valueOf('!') : "") + schema;
        this.jsonSchemaValidator = new JsonSchemaValidator(MOCK_SERVER_LOGGER, this.json, (JsonNode)this.schemaJsonNode);
    }

    private NottableSchemaString(String schema) {
        super(schema);
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            this.schemaJsonNode = this.getSchemaJsonNode(this.getValue());
            Schema schemaByType = SchemaTypeUtil.createSchemaByType((ObjectNode)this.schemaJsonNode);
            this.type = schemaByType.getType();
            this.format = schemaByType.getFormat();
        } else {
            this.schemaJsonNode = null;
            this.type = null;
            this.format = null;
        }
        this.json = (Boolean.TRUE.equals(this.isNot()) ? Character.valueOf('!') : "") + schema;
        this.jsonSchemaValidator = this.schemaJsonNode != null ? new JsonSchemaValidator(MOCK_SERVER_LOGGER, this.json, (JsonNode)this.schemaJsonNode) : null;
    }

    @Override
    public boolean matches(String json) {
        return this.matches(null, null, json);
    }

    public boolean matches(MockServerLogger mockServerLogger, MatchDifference context, String json) {
        if (this.schemaJsonNode != null) {
            try {
                boolean result;
                if (this.type.equals("string") && StringUtils.isNotBlank((CharSequence)json) && !json.startsWith("\"") && !json.endsWith("\"")) {
                    json = "\"" + json + "\"";
                }
                String validationErrors = this.validate(json);
                boolean bl = result = this.isNot() != validationErrors.isEmpty();
                if (!result && context != null) {
                    context.addDifference(mockServerLogger, "schema match failed expect:{}found:{}errors:{}", this.json, json, validationErrors);
                }
                return result;
            }
            catch (Throwable throwable) {
                MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception validating JSON").setThrowable(throwable));
                if (!this.isNot() && context != null) {
                    context.addDifference(mockServerLogger, "schema match failed expect:{}:found error:{}for:{}", this.json, throwable.getMessage(), json);
                }
                return this.isNot();
            }
        }
        return !this.isNot();
    }

    private String validate(String json) {
        if (this.schemaJsonNode.get("nullable") != null && TRUE.equals(this.schemaJsonNode.get("nullable").asText()) && StringUtils.isBlank((CharSequence)json)) {
            return "";
        }
        if (StringUtils.isBlank((CharSequence)json)) {
            return "found blank value and value was not nullable";
        }
        return this.jsonSchemaValidator.isValid(json, false);
    }

    @Override
    public String toString() {
        return this.json;
    }
}

