/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.codec;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.NottableString;
import org.mockserver.model.Parameter;
import org.mockserver.model.Parameters;

public class PathParametersDecoder {
    private static final Pattern PATH_VARIABLE_NAME_PATTERN = Pattern.compile("\\{[.;]?([^*]+)\\*?}");

    public String validatePath(HttpRequest matcher) {
        String error = "";
        if (matcher.getPath() != null && matcher.getPathParameters() != null && !matcher.getPathParameters().isEmpty()) {
            ArrayList<String> actualParameterNames = new ArrayList<String>();
            for (String matcherPathPart : matcher.getPath().getValue().split("/")) {
                Matcher pathParameterName = PATH_VARIABLE_NAME_PATTERN.matcher(matcherPathPart);
                if (!pathParameterName.matches()) continue;
                actualParameterNames.add(pathParameterName.group(1));
            }
            List expectedParameterNames = matcher.getPathParameters().keySet().stream().map(NottableString::getValue).collect(Collectors.toList());
            if (!expectedParameterNames.equals(actualParameterNames)) {
                error = "path parameters specified " + expectedParameterNames + " but found " + actualParameterNames + " in path matcher";
            }
        }
        return error;
    }

    public NottableString normalisePathWithParametersForMatching(HttpRequest matcher) {
        NottableString result = null;
        if (matcher.getPath() != null) {
            if (matcher.getPathParameters() != null && !matcher.getPathParameters().isEmpty()) {
                String value = matcher.getPath().getValue();
                if (value.contains("{")) {
                    ArrayList<String> pathParts = new ArrayList<String>();
                    for (String pathPart : matcher.getPath().getValue().split("/")) {
                        Matcher pathParameterName = PATH_VARIABLE_NAME_PATTERN.matcher(pathPart);
                        if (pathParameterName.matches()) {
                            pathParts.add(".*");
                            continue;
                        }
                        pathParts.add(pathPart);
                    }
                    result = NottableString.string(Joiner.on((String)"/").join(pathParts) + (value.endsWith("/") ? "/" : ""));
                } else {
                    result = matcher.getPath();
                }
            } else {
                result = matcher.getPath();
            }
        }
        return result;
    }

    public Parameters extractPathParameters(HttpRequest matcher, HttpRequest matched) {
        Parameters parsedParameters;
        Parameters parameters = parsedParameters = matched.getPathParameters() != null ? matched.getPathParameters() : new Parameters(new Parameter[0]);
        if (matcher.getPathParameters() != null && !matcher.getPathParameters().isEmpty()) {
            String[] matchedPathParts;
            String[] matcherPathParts = this.getPathParts(matcher.getPath());
            if (matcherPathParts.length != (matchedPathParts = this.getPathParts(matched.getPath())).length) {
                throw new IllegalArgumentException("expected path " + matcher.getPath().getValue() + " has " + matcherPathParts.length + " parts but path " + matched.getPath().getValue() + " has " + matchedPathParts.length + " part" + (matchedPathParts.length > 1 ? "s " : " "));
            }
            for (int i = 0; i < matcherPathParts.length; ++i) {
                Matcher pathParameterName = PATH_VARIABLE_NAME_PATTERN.matcher(matcherPathParts[i]);
                if (!pathParameterName.matches()) continue;
                String parameterName = pathParameterName.group(1);
                ArrayList<String> parameterValues = new ArrayList<String>();
                Matcher pathParameterValue = Pattern.compile("[.;]?(?:" + parameterName + "=)?([^,]++)[.,;]?").matcher(matchedPathParts[i]);
                while (pathParameterValue.find()) {
                    parameterValues.add(pathParameterValue.group(1));
                }
                parsedParameters.withEntry(parameterName, parameterValues);
            }
        }
        matched.withPathParameters(parsedParameters);
        return parsedParameters;
    }

    private String[] getPathParts(NottableString path) {
        return path != null ? (String[])Arrays.stream(StringUtils.removeStart((String)path.getValue(), (String)"/").split("/")).filter(StringUtils::isNotBlank).toArray(String[]::new) : new String[]{};
    }
}

