/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.authentication;

import org.mockserver.authentication.AuthenticationHandler;
import org.mockserver.model.HttpRequest;

public class ChainedAuthenticationHandler
implements AuthenticationHandler {
    private final AuthenticationHandler[] authenticationHandlers;

    public ChainedAuthenticationHandler(AuthenticationHandler ... authenticationHandlers) {
        this.authenticationHandlers = authenticationHandlers;
    }

    @Override
    public boolean controlPlaneRequestAuthenticated(HttpRequest request) {
        for (AuthenticationHandler authenticationHandler : this.authenticationHandlers) {
            if (authenticationHandler.controlPlaneRequestAuthenticated(request)) continue;
            return false;
        }
        return true;
    }
}

