/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorParser;
import org.torproject.descriptor.DescriptorReader;
import org.torproject.descriptor.impl.BlockingIteratorImpl;
import org.torproject.descriptor.impl.DescriptorParserImpl;

public class DescriptorReaderImpl
implements DescriptorReader {
    private static final Logger logger = LoggerFactory.getLogger(DescriptorReaderImpl.class);
    private boolean hasStartedReading = false;
    private File manualSaveHistoryFile;
    private SortedMap<String, Long> excludedFiles;
    private int maxDescriptorsInQueue = 100;
    private DescriptorReaderRunnable reader;

    @Override
    public void setHistoryFile(File historyFile) {
        if (this.hasStartedReading) {
            throw new IllegalStateException("Reconfiguration is not permitted after starting to read.");
        }
        this.manualSaveHistoryFile = historyFile;
    }

    @Override
    public void setExcludedFiles(SortedMap<String, Long> excludedFiles) {
        if (this.hasStartedReading) {
            throw new IllegalStateException("Reconfiguration is not permitted after starting to read.");
        }
        this.excludedFiles = excludedFiles;
    }

    @Override
    public SortedMap<String, Long> getExcludedFiles() {
        if (this.reader == null || !this.reader.hasFinishedReading) {
            throw new IllegalStateException("Operation is not permitted before finishing to read.");
        }
        return new TreeMap<String, Long>(this.reader.excludedFilesAfter);
    }

    @Override
    public SortedMap<String, Long> getParsedFiles() {
        if (this.reader == null || !this.reader.hasFinishedReading) {
            throw new IllegalStateException("Operation is not permitted before finishing to read.");
        }
        return new TreeMap<String, Long>(this.reader.parsedFilesAfter);
    }

    @Override
    public void setMaxDescriptorsInQueue(int maxDescriptorsInQueue) {
        if (this.hasStartedReading) {
            throw new IllegalStateException("Reconfiguration is not permitted after starting to read.");
        }
        this.maxDescriptorsInQueue = maxDescriptorsInQueue;
    }

    @Override
    public Iterable<Descriptor> readDescriptors(File ... descriptorFiles) {
        if (this.hasStartedReading) {
            throw new IllegalStateException("Initiating reading is only permitted once.");
        }
        this.hasStartedReading = true;
        BlockingIteratorImpl<Descriptor> descriptorQueue = new BlockingIteratorImpl<Descriptor>(this.maxDescriptorsInQueue);
        this.reader = new DescriptorReaderRunnable(descriptorFiles, descriptorQueue, this.manualSaveHistoryFile, this.excludedFiles);
        Thread readerThread = new Thread(this.reader);
        readerThread.setDaemon(true);
        readerThread.start();
        return descriptorQueue;
    }

    @Override
    public void saveHistoryFile(File historyFile) {
        if (!this.reader.hasFinishedReading) {
            throw new IllegalStateException("Saving history is only permitted after reading descriptors.");
        }
        this.reader.writeNewHistory(historyFile);
    }

    private static class DescriptorReaderRunnable
    implements Runnable {
        private File[] descriptorFiles;
        private BlockingIteratorImpl<Descriptor> descriptorQueue;
        private File manualSaveHistoryFile;
        private List<File> tarballs = new ArrayList<File>();
        private SortedMap<String, Long> excludedFilesBefore = new TreeMap<String, Long>();
        private SortedMap<String, Long> excludedFilesAfter = new TreeMap<String, Long>();
        private SortedMap<String, Long> parsedFilesAfter = new TreeMap<String, Long>();
        private DescriptorParser descriptorParser;
        private boolean hasFinishedReading = false;

        private DescriptorReaderRunnable(File[] descriptorFiles, BlockingIteratorImpl<Descriptor> descriptorQueue, File manualSaveHistoryFile, SortedMap<String, Long> excludedFiles) {
            this.descriptorFiles = descriptorFiles;
            this.descriptorQueue = descriptorQueue;
            this.manualSaveHistoryFile = manualSaveHistoryFile;
            if (excludedFiles != null) {
                this.excludedFilesBefore = excludedFiles;
            }
            this.descriptorParser = new DescriptorParserImpl();
        }

        @Override
        public void run() {
            try {
                this.readOldHistory(this.manualSaveHistoryFile);
                this.readDescriptorFiles();
                this.readTarballs();
                this.hasFinishedReading = true;
            }
            catch (Throwable t) {
                logger.error("Bug: uncaught exception or error while reading descriptors.", t);
            }
            finally {
                if (null != this.descriptorQueue) {
                    this.descriptorQueue.setOutOfDescriptors();
                }
            }
        }

        private void readOldHistory(File historyFile) {
            if (historyFile == null || !historyFile.exists()) {
                return;
            }
            try {
                List<String> lines = Files.readAllLines(historyFile.toPath(), StandardCharsets.UTF_8);
                for (String line : lines) {
                    if (!line.contains(" ")) {
                        logger.warn("Unexpected line structure in old history: {}", (Object)line);
                        continue;
                    }
                    long lastModifiedMillis = Long.parseLong(line.substring(0, line.indexOf(" ")));
                    String absolutePath = line.substring(line.indexOf(" ") + 1);
                    this.excludedFilesBefore.put(absolutePath, lastModifiedMillis);
                }
            }
            catch (IOException | NumberFormatException e) {
                logger.warn("Trouble reading given history file {}.", (Object)historyFile, (Object)e);
            }
        }

        private void writeNewHistory(File historyFile) {
            if (historyFile == null) {
                return;
            }
            if (historyFile.getParentFile() != null) {
                historyFile.getParentFile().mkdirs();
            }
            try (BufferedWriter bw = Files.newBufferedWriter(historyFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                TreeMap<String, Long> newHistory = new TreeMap<String, Long>();
                newHistory.putAll(this.excludedFilesAfter);
                newHistory.putAll(this.parsedFilesAfter);
                for (Map.Entry e : newHistory.entrySet()) {
                    String absolutePath = (String)e.getKey();
                    String lastModifiedMillis = String.valueOf(e.getValue());
                    bw.write(lastModifiedMillis + " " + absolutePath);
                    bw.newLine();
                }
            }
            catch (IOException e) {
                logger.warn("Trouble writing new history file '{}'.", (Object)historyFile, (Object)e);
            }
        }

        private void readDescriptorFiles() {
            if (null == this.descriptorFiles) {
                return;
            }
            Stack<File> files = new Stack<File>();
            for (File descriptorFile : this.descriptorFiles) {
                if (!descriptorFile.exists()) continue;
                files.add(descriptorFile);
                while (!files.isEmpty()) {
                    File file = (File)files.pop();
                    try {
                        String absolutePath = file.getAbsolutePath();
                        long lastModifiedMillis = file.lastModified();
                        if (this.excludedFilesBefore.getOrDefault(absolutePath, 0L) == lastModifiedMillis) {
                            this.excludedFilesAfter.put(absolutePath, lastModifiedMillis);
                            continue;
                        }
                        if (file.isDirectory()) {
                            files.addAll(Arrays.asList(file.listFiles()));
                            continue;
                        }
                        if (file.getName().endsWith(".tar") || file.getName().endsWith(".tar.bz2") || file.getName().endsWith(".tar.xz")) {
                            this.tarballs.add(file);
                            continue;
                        }
                        this.readDescriptorFile(file);
                        this.parsedFilesAfter.put(absolutePath, lastModifiedMillis);
                    }
                    catch (IOException e) {
                        logger.warn("Unable to read descriptor file {}.", (Object)file, (Object)e);
                    }
                }
            }
        }

        private void readTarballs() {
            if (this.tarballs.isEmpty()) {
                return;
            }
            long total = 0L;
            for (File tarball : this.tarballs) {
                total += tarball.length();
            }
            long progress = 0L;
            for (File tarball : this.tarballs) {
                try {
                    this.readTarball(tarball);
                    this.parsedFilesAfter.put(tarball.getAbsolutePath(), tarball.lastModified());
                }
                catch (IOException e) {
                    logger.warn("Unable to read tarball {}.", (Object)tarball, (Object)e);
                }
                long previousPercentDone = 100L * progress / total;
                long percentDone = 100L * (progress += tarball.length()) / total;
                if (percentDone <= previousPercentDone) continue;
                logger.info("Finished reading {}% of tarball bytes.", (Object)percentDone);
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void readTarball(File file) throws IOException {
            try (FileInputStream in = new FileInputStream(file);){
                TarArchiveInputStream tais;
                if (in.available() <= 0) {
                    return;
                }
                if (file.getName().endsWith(".tar.bz2")) {
                    tais = new TarArchiveInputStream(new BZip2CompressorInputStream(in));
                } else if (file.getName().endsWith(".tar.xz")) {
                    tais = new TarArchiveInputStream(new XZCompressorInputStream(in));
                } else {
                    if (!file.getName().endsWith(".tar")) return;
                    tais = new TarArchiveInputStream(in);
                }
                try (BufferedInputStream bis = new BufferedInputStream(tais);){
                    Throwable throwable;
                    ByteArrayOutputStream baos;
                    TarArchiveEntry tae;
                    while ((tae = tais.getNextTarEntry()) != null) {
                        block52: {
                            byte[] rawDescriptorBytes;
                            block50: {
                                block51: {
                                    int len;
                                    if (tae.isDirectory()) continue;
                                    baos = new ByteArrayOutputStream();
                                    throwable = null;
                                    byte[] data = new byte[1024];
                                    while ((len = bis.read(data, 0, 1024)) >= 0) {
                                        baos.write(data, 0, len);
                                    }
                                    rawDescriptorBytes = baos.toByteArray();
                                    if (rawDescriptorBytes.length >= 1) break block50;
                                    if (baos == null) continue;
                                    if (throwable == null) break block51;
                                    try {
                                        baos.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    continue;
                                }
                                baos.close();
                                continue;
                            }
                            String fileName = tae.getName().substring(tae.getName().lastIndexOf("/") + 1);
                            for (Descriptor descriptor : this.descriptorParser.parseDescriptors(rawDescriptorBytes, file, fileName)) {
                                this.descriptorQueue.add(descriptor);
                            }
                            if (baos == null) continue;
                            if (throwable == null) break block52;
                            try {
                                baos.close();
                                continue;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                                continue;
                            }
                        }
                        baos.close();
                    }
                    return;
                    catch (Throwable throwable4) {
                        try {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (baos == null) throw throwable5;
                            if (throwable != null) {
                                try {
                                    baos.close();
                                    throw throwable5;
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                    throw throwable5;
                                }
                            }
                            baos.close();
                            throw throwable5;
                        }
                    }
                }
            }
        }

        private void readDescriptorFile(File file) throws IOException {
            try (FileInputStream fis = new FileInputStream(file);){
                byte[] rawDescriptorBytes;
                InputStream is = fis;
                if (file.getName().endsWith(".gz")) {
                    is = new GzipCompressorInputStream(fis);
                }
                if ((rawDescriptorBytes = IOUtils.toByteArray(is)).length > 0) {
                    for (Descriptor descriptor : this.descriptorParser.parseDescriptors(rawDescriptorBytes, file, file.getName())) {
                        this.descriptorQueue.add(descriptor);
                    }
                }
            }
        }
    }
}

