/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import nl.jqno.equalsverifier.CachedHashCodeInitializer;
import nl.jqno.equalsverifier.Checker;
import nl.jqno.equalsverifier.Configuration;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.Assert;
import nl.jqno.equalsverifier.internal.ClassAccessor;
import nl.jqno.equalsverifier.internal.Formatter;
import nl.jqno.equalsverifier.internal.ObjectAccessor;
import nl.jqno.equalsverifier.internal.exceptions.ReflectionException;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;

class HierarchyChecker<T>
implements Checker {
    private final Configuration<T> config;
    private final Class<T> type;
    private final TypeTag typeTag;
    private final ClassAccessor<T> classAccessor;
    private final Class<? extends T> redefinedSubclass;
    private final boolean typeIsFinal;
    private final CachedHashCodeInitializer<T> cachedHashCodeInitializer;

    public HierarchyChecker(Configuration<T> config) {
        this.config = config;
        if (config.getWarningsToSuppress().contains((Object)Warning.STRICT_INHERITANCE) && config.getRedefinedSubclass() != null) {
            Assert.fail(Formatter.of("withRedefinedSubclass and weakInheritanceCheck are mutually exclusive.", new Object[0]));
        }
        this.type = config.getType();
        this.typeTag = config.getTypeTag();
        this.classAccessor = config.createClassAccessor();
        this.redefinedSubclass = config.getRedefinedSubclass();
        this.typeIsFinal = Modifier.isFinal(this.type.getModifiers());
        this.cachedHashCodeInitializer = config.getCachedHashCodeInitializer();
    }

    @Override
    public void check() {
        this.checkSuperclass();
        this.checkSubclass();
        this.checkRedefinedSubclass();
        if (!this.config.getWarningsToSuppress().contains((Object)Warning.STRICT_INHERITANCE)) {
            this.checkFinalEqualsMethod();
        }
    }

    private void checkSuperclass() {
        ClassAccessor<T> superAccessor = this.classAccessor.getSuperAccessor();
        if (superAccessor.isEqualsInheritedFromObject()) {
            return;
        }
        if (this.config.hasRedefinedSuperclass() || this.config.isUsingGetClass()) {
            T reference = this.classAccessor.getRedObject(this.typeTag);
            Object equalSuper = this.getEqualSuper(reference);
            Formatter formatter = Formatter.of("Redefined superclass:\n  %%\nshould not equal superclass instance\n  %%\nbut it does.", reference, equalSuper);
            Assert.assertFalse(formatter, reference.equals(equalSuper) || equalSuper.equals(reference));
        } else {
            this.checkSuperProperties(this.classAccessor.getRedAccessor(this.typeTag));
            this.checkSuperProperties(this.classAccessor.getDefaultValuesAccessor(this.typeTag));
        }
    }

    private void checkSuperProperties(ObjectAccessor<T> referenceAccessor) {
        T reference = referenceAccessor.get();
        Object equalSuper = this.getEqualSuper(reference);
        T shallow = referenceAccessor.copy();
        ObjectAccessor.of(shallow).shallowScramble(this.config.getPrefabValues(), this.typeTag);
        Formatter symmetryFormatter = Formatter.of("Symmetry:\n  %%\ndoes not equal superclass instance\n  %%", reference, equalSuper);
        Assert.assertTrue(symmetryFormatter, reference.equals(equalSuper) && equalSuper.equals(reference));
        Formatter transitivityFormatter = Formatter.of("Transitivity:\n  %%\nand\n  %%\nboth equal superclass instance\n  %%\nwhich implies they equal each other.", reference, shallow, equalSuper);
        Assert.assertTrue(transitivityFormatter, reference.equals(shallow) || reference.equals(equalSuper) != equalSuper.equals(shallow));
        int referenceHashCode = this.cachedHashCodeInitializer.getInitializedHashCode(reference);
        int equalSuperHashCode = this.cachedHashCodeInitializer.getInitializedHashCode(equalSuper);
        Formatter superclassFormatter = Formatter.of("Superclass: hashCode for\n  %% (%%)\nshould be equal to hashCode for superclass instance\n  %% (%%)", reference, referenceHashCode, equalSuper, equalSuperHashCode);
        Assert.assertTrue(superclassFormatter, referenceHashCode == equalSuperHashCode);
    }

    private Object getEqualSuper(T reference) {
        return ObjectAccessor.of(reference, this.type.getSuperclass()).copy();
    }

    private void checkSubclass() {
        if (this.typeIsFinal) {
            return;
        }
        ObjectAccessor<T> referenceAccessor = this.classAccessor.getRedAccessor(this.typeTag);
        T reference = referenceAccessor.get();
        T equalSub = referenceAccessor.copyIntoAnonymousSubclass();
        if (this.config.isUsingGetClass()) {
            Formatter formatter = Formatter.of("Subclass: object is equal to an instance of a trivial subclass with equal fields:\n  %%\nThis should not happen when using getClass().", reference);
            Assert.assertFalse(formatter, reference.equals(equalSub));
        } else {
            Formatter formatter = Formatter.of("Subclass: object is not equal to an instance of a trivial subclass with equal fields:\n  %%\nConsider making the class final.", reference);
            Assert.assertTrue(formatter, reference.equals(equalSub));
        }
    }

    private void checkRedefinedSubclass() {
        if (this.typeIsFinal || this.redefinedSubclass == null) {
            return;
        }
        if (this.methodIsFinal("equals", Object.class)) {
            Assert.fail(Formatter.of("Subclass: %% has a final equals method.\nNo need to supply a redefined subclass.", this.type.getSimpleName()));
        }
        ObjectAccessor<T> referenceAccessor = this.classAccessor.getRedAccessor(this.typeTag);
        T reference = referenceAccessor.get();
        T redefinedSub = referenceAccessor.copyIntoSubclass(this.redefinedSubclass);
        Assert.assertFalse(Formatter.of("Subclass:\n  %%\nequals subclass instance\n  %%", reference, redefinedSub), reference.equals(redefinedSub));
    }

    private void checkFinalEqualsMethod() {
        if (this.typeIsFinal || this.redefinedSubclass != null) {
            return;
        }
        boolean equalsIsFinal = this.methodIsFinal("equals", Object.class);
        boolean hashCodeIsFinal = this.methodIsFinal("hashCode", new Class[0]);
        if (this.config.isUsingGetClass()) {
            Assert.assertEquals(Formatter.of("Finality: equals and hashCode must both be final or both be non-final.", new Object[0]), equalsIsFinal, hashCodeIsFinal);
        } else {
            Formatter equalsFormatter = Formatter.of("Subclass: equals is not final.\nSupply an instance of a redefined subclass using withRedefinedSubclass if equals cannot be final.", new Object[0]);
            Assert.assertTrue(equalsFormatter, equalsIsFinal);
            Formatter hashCodeFormatter = Formatter.of("Subclass: hashCode is not final.\nSupply an instance of a redefined subclass using withRedefinedSubclass if hashCode cannot be final.", new Object[0]);
            Assert.assertTrue(hashCodeFormatter, hashCodeIsFinal);
        }
    }

    private boolean methodIsFinal(String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = this.type.getMethod(methodName, parameterTypes);
            return Modifier.isFinal(method.getModifiers());
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new ReflectionException("Should never occur: cannot find " + this.type.getName() + "." + methodName);
        }
    }
}

