/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.onionperf;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.io.IOException;
import java.util.Map;

public class ParsedOnionPerfAnalysis {
    private static final ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE).setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    Map<String, MeasurementData> data;
    String type;
    Object version;

    static ParsedOnionPerfAnalysis fromBytes(byte[] bytes) throws IOException {
        return objectMapper.readValue(bytes, ParsedOnionPerfAnalysis.class);
    }

    static class Stream {
        String circuitId;
        String failureReasonLocal;
        String failureReasonRemote;
        String source;
        Integer streamId;
        Double unixTsEnd;

        Stream() {
        }
    }

    static class Circuit {
        Double buildQuantile;
        Integer buildTimeout;
        Integer circuitId;
        Object[][] path;
        Double unixTsStart;

        Circuit() {
        }
    }

    static class TorData {
        Map<String, Circuit> circuits;
        Map<String, Stream> streams;

        TorData() {
        }
    }

    static class ElapsedSeconds {
        Double command;
        Double lastByte;
        Map<String, Double> payloadBytes;
        Map<String, Double> payloadProgress;
        Double proxyChoice;
        Double proxyRequest;
        Double proxyResponse;
        Double response;
        Double socketConnect;
        Double socketCreate;

        ElapsedSeconds() {
        }
    }

    static class Transfer {
        ElapsedSeconds elapsedSeconds;
        String endpointLocal;
        String endpointProxy;
        String endpointRemote;
        String errorCode;
        Integer filesizeBytes;
        String hostnameLocal;
        String hostnameRemote;
        Boolean isError;
        Integer totalBytesRead;
        Integer totalBytesWrite;
        Double unixTsStart;
        Double unixTsEnd;

        Transfer() {
        }
    }

    static class TgenData {
        Map<String, Transfer> transfers;

        TgenData() {
        }
    }

    static class MeasurementData {
        String measurementIp;
        TgenData tgen;
        TorData tor;

        MeasurementData() {
        }
    }
}

