/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.onionperf;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.impl.TorperfResultImpl;
import org.torproject.descriptor.onionperf.ParsedOnionPerfAnalysis;
import org.torproject.descriptor.onionperf.TorperfResultsBuilder;

public class OnionPerfAnalysisConverter {
    private final byte[] rawDescriptorBytes;
    private final File descriptorFile;
    private List<Descriptor> convertedTorperfResults;

    public OnionPerfAnalysisConverter(byte[] rawDescriptorBytes, File descriptorFile) {
        this.rawDescriptorBytes = rawDescriptorBytes;
        this.descriptorFile = descriptorFile;
    }

    public List<Descriptor> asTorperfResults() throws DescriptorParseException {
        ParsedOnionPerfAnalysis parsedOnionPerfAnalysis;
        try {
            ByteArrayInputStream compressedInputStream = new ByteArrayInputStream(this.rawDescriptorBytes);
            XZCompressorInputStream decompressedInputStream = new XZCompressorInputStream((InputStream)compressedInputStream);
            byte[] decompressedBytes = IOUtils.toByteArray((InputStream)decompressedInputStream);
            parsedOnionPerfAnalysis = ParsedOnionPerfAnalysis.fromBytes(decompressedBytes);
        }
        catch (IOException ioException) {
            throw new DescriptorParseException("Ran into an I/O error while attempting to parse an OnionPerf analysis document.", ioException);
        }
        this.verifyDocumentTypeAndVersion(parsedOnionPerfAnalysis);
        StringBuilder formattedTorperfResults = this.formatTorperfResults(parsedOnionPerfAnalysis);
        this.parseFormattedTorperfResults(formattedTorperfResults);
        return this.convertedTorperfResults;
    }

    private void verifyDocumentTypeAndVersion(ParsedOnionPerfAnalysis parsedOnionPerfAnalysis) throws DescriptorParseException {
        if (!"onionperf".equals(parsedOnionPerfAnalysis.type)) {
            throw new DescriptorParseException("Parsed OnionPerf analysis file does not contain type information.");
        }
        if (null == parsedOnionPerfAnalysis.version) {
            throw new DescriptorParseException("Parsed OnionPerf analysis file does not contain version information.");
        }
        if (parsedOnionPerfAnalysis.version instanceof Double && (Double)parsedOnionPerfAnalysis.version > 2.999 || parsedOnionPerfAnalysis.version instanceof String && ((String)parsedOnionPerfAnalysis.version).compareTo("3.") >= 0) {
            throw new DescriptorParseException("Parsed OnionPerf analysis file contains unsupported version " + parsedOnionPerfAnalysis.version + ".");
        }
    }

    private StringBuilder formatTorperfResults(ParsedOnionPerfAnalysis parsedOnionPerfAnalysis) {
        StringBuilder formattedTorperfResults = new StringBuilder();
        for (Map.Entry<String, ParsedOnionPerfAnalysis.MeasurementData> data : parsedOnionPerfAnalysis.data.entrySet()) {
            String nickname = data.getKey();
            ParsedOnionPerfAnalysis.MeasurementData measurements = data.getValue();
            if (null == measurements.measurementIp || null == measurements.tgen || null == measurements.tgen.transfers) continue;
            String measurementIp = measurements.measurementIp;
            HashMap streamsBySourcePort = new HashMap();
            Map<Object, Object> circuitsByCircuitId = new HashMap();
            if (null != measurements.tor) {
                circuitsByCircuitId = measurements.tor.circuits;
                if (null != measurements.tor.streams) {
                    for (ParsedOnionPerfAnalysis.Stream stream : measurements.tor.streams.values()) {
                        if (null == stream.source || !stream.source.contains(":")) continue;
                        String sourcePort = stream.source.split(":")[1];
                        streamsBySourcePort.putIfAbsent(sourcePort, new ArrayList());
                        ((List)streamsBySourcePort.get(sourcePort)).add(stream);
                    }
                }
            }
            for (ParsedOnionPerfAnalysis.Transfer transfer : measurements.tgen.transfers.values()) {
                String sourcePort;
                String[] endpointLocalParts;
                if (null == transfer.endpointLocal || (endpointLocalParts = transfer.endpointLocal.split(":")).length < 3) continue;
                TorperfResultsBuilder torperfResultsBuilder = new TorperfResultsBuilder();
                torperfResultsBuilder.addString("SOURCE", nickname);
                torperfResultsBuilder.addString("SOURCEADDRESS", measurementIp);
                this.formatTransferParts(torperfResultsBuilder, transfer);
                ArrayList<String> errorCodeParts = null;
                if (transfer.isError.booleanValue()) {
                    errorCodeParts = new ArrayList<String>();
                    if ("PROXY".equals(transfer.errorCode)) {
                        errorCodeParts.add("TOR");
                    } else {
                        errorCodeParts.add("TGEN");
                        errorCodeParts.add(transfer.errorCode);
                    }
                }
                if (streamsBySourcePort.containsKey(sourcePort = endpointLocalParts[2])) {
                    for (ParsedOnionPerfAnalysis.Stream stream : (List)streamsBySourcePort.get(sourcePort)) {
                        if (!(Math.abs(transfer.unixTsEnd - stream.unixTsEnd) < 150.0)) continue;
                        if (null != errorCodeParts && null != stream.failureReasonLocal) {
                            errorCodeParts.add(stream.failureReasonLocal);
                            if (null != stream.failureReasonRemote) {
                                errorCodeParts.add(stream.failureReasonRemote);
                            }
                        }
                        if (null == stream.circuitId || !circuitsByCircuitId.containsKey(stream.circuitId)) continue;
                        ParsedOnionPerfAnalysis.Circuit circuit = (ParsedOnionPerfAnalysis.Circuit)circuitsByCircuitId.get(stream.circuitId);
                        this.formatStreamParts(torperfResultsBuilder, stream);
                        this.formatCircuitParts(torperfResultsBuilder, circuit);
                    }
                }
                if (null != errorCodeParts) {
                    String errorCode = String.join((CharSequence)"/", errorCodeParts);
                    torperfResultsBuilder.addString("ERRORCODE", errorCode);
                }
                formattedTorperfResults.append(torperfResultsBuilder.build());
            }
        }
        return formattedTorperfResults;
    }

    private void parseFormattedTorperfResults(StringBuilder formattedTorperfResults) throws DescriptorParseException {
        this.convertedTorperfResults = TorperfResultImpl.parseTorperfResults(formattedTorperfResults.toString().getBytes(), this.descriptorFile);
    }

    private void formatTransferParts(TorperfResultsBuilder torperfResultsBuilder, ParsedOnionPerfAnalysis.Transfer transfer) {
        torperfResultsBuilder.addString("ENDPOINTLOCAL", transfer.endpointLocal);
        torperfResultsBuilder.addString("ENDPOINTPROXY", transfer.endpointProxy);
        torperfResultsBuilder.addString("ENDPOINTREMOTE", transfer.endpointRemote);
        torperfResultsBuilder.addString("HOSTNAMELOCAL", transfer.hostnameLocal);
        torperfResultsBuilder.addString("HOSTNAMEREMOTE", transfer.hostnameRemote);
        torperfResultsBuilder.addInteger("FILESIZE", transfer.filesizeBytes);
        torperfResultsBuilder.addInteger("READBYTES", transfer.totalBytesRead);
        torperfResultsBuilder.addInteger("WRITEBYTES", transfer.totalBytesWrite);
        torperfResultsBuilder.addInteger("DIDTIMEOUT", 0);
        for (String key : new String[]{"START", "SOCKET", "CONNECT", "NEGOTIATE", "REQUEST", "RESPONSE", "DATAREQUEST", "DATARESPONSE", "DATACOMPLETE", "LAUNCH", "DATAPERC10", "DATAPERC20", "DATAPERC30", "DATAPERC40", "DATAPERC50", "DATAPERC60", "DATAPERC70", "DATAPERC80", "DATAPERC90", "DATAPERC100"}) {
            torperfResultsBuilder.addString(key, "0.0");
        }
        torperfResultsBuilder.addTimestamp("START", transfer.unixTsStart, 0.0);
        if (null != transfer.unixTsStart && null != transfer.elapsedSeconds) {
            Double elapsedSeconds;
            torperfResultsBuilder.addTimestamp("SOCKET", transfer.unixTsStart, transfer.elapsedSeconds.socketCreate);
            torperfResultsBuilder.addTimestamp("CONNECT", transfer.unixTsStart, transfer.elapsedSeconds.socketConnect);
            torperfResultsBuilder.addTimestamp("NEGOTIATE", transfer.unixTsStart, transfer.elapsedSeconds.proxyChoice);
            torperfResultsBuilder.addTimestamp("REQUEST", transfer.unixTsStart, transfer.elapsedSeconds.proxyRequest);
            torperfResultsBuilder.addTimestamp("RESPONSE", transfer.unixTsStart, transfer.elapsedSeconds.proxyResponse);
            torperfResultsBuilder.addTimestamp("DATAREQUEST", transfer.unixTsStart, transfer.elapsedSeconds.command);
            torperfResultsBuilder.addTimestamp("DATARESPONSE", transfer.unixTsStart, transfer.elapsedSeconds.response);
            if (null != transfer.elapsedSeconds.payloadBytes) {
                for (Map.Entry entry : transfer.elapsedSeconds.payloadBytes.entrySet()) {
                    String key = String.format("PARTIAL%s", entry.getKey());
                    elapsedSeconds = (Double)entry.getValue();
                    torperfResultsBuilder.addTimestamp(key, transfer.unixTsStart, elapsedSeconds);
                }
            }
            if (null != transfer.elapsedSeconds.payloadProgress) {
                for (Map.Entry entry : transfer.elapsedSeconds.payloadProgress.entrySet()) {
                    String key = String.format("DATAPERC%.0f", Double.parseDouble((String)entry.getKey()) * 100.0);
                    elapsedSeconds = (Double)entry.getValue();
                    torperfResultsBuilder.addTimestamp(key, transfer.unixTsStart, elapsedSeconds);
                }
            }
            torperfResultsBuilder.addTimestamp("DATACOMPLETE", transfer.unixTsStart, transfer.elapsedSeconds.lastByte);
            if (transfer.isError.booleanValue()) {
                torperfResultsBuilder.addInteger("DIDTIMEOUT", 1);
            }
        }
    }

    private void formatStreamParts(TorperfResultsBuilder torperfResultsBuilder, ParsedOnionPerfAnalysis.Stream stream) {
        torperfResultsBuilder.addTimestamp("USED_AT", stream.unixTsEnd, 0.0);
        torperfResultsBuilder.addInteger("USED_BY", stream.streamId);
    }

    private void formatCircuitParts(TorperfResultsBuilder torperfResultsBuilder, ParsedOnionPerfAnalysis.Circuit circuit) {
        torperfResultsBuilder.addTimestamp("LAUNCH", circuit.unixTsStart, 0.0);
        if (null != circuit.path) {
            ArrayList<String> path = new ArrayList<String>();
            ArrayList<String> buildTimes = new ArrayList<String>();
            for (Object[] pathElement : circuit.path) {
                String fingerprintAndNickname = (String)pathElement[0];
                String fingerprint = fingerprintAndNickname.split("~")[0];
                path.add(fingerprint);
                buildTimes.add(String.format("%.2f", (Double)pathElement[1]));
            }
            torperfResultsBuilder.addString("PATH", String.join((CharSequence)",", path));
            torperfResultsBuilder.addString("BUILDTIMES", String.join((CharSequence)",", buildTimes));
            torperfResultsBuilder.addInteger("TIMEOUT", circuit.buildTimeout);
            torperfResultsBuilder.addDouble("QUANTILE", circuit.buildQuantile);
            torperfResultsBuilder.addInteger("CIRC_ID", circuit.circuitId);
        }
    }
}

