/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Scanner;
import java.util.SortedSet;
import java.util.TreeSet;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.RelayNetworkStatus;
import org.torproject.descriptor.impl.Key;
import org.torproject.descriptor.impl.NetworkStatusImpl;
import org.torproject.descriptor.impl.ParseHelper;

public class RelayNetworkStatusImpl
extends NetworkStatusImpl
implements RelayNetworkStatus {
    private int networkStatusVersion;
    private String hostname;
    private String address;
    private int dirPort;
    private String fingerprint;
    private String contactLine;
    private String dirSigningKey;
    private String[] recommendedClientVersions;
    private String[] recommendedServerVersions;
    private long publishedMillis;
    private String[] dirOptions;
    private String nickname;
    private String directorySignature;

    protected RelayNetworkStatusImpl(byte[] statusBytes, int[] offsetAndLength, File descriptorFile, boolean failUnrecognizedDescriptorLines) throws DescriptorParseException {
        super(statusBytes, offsetAndLength, descriptorFile, failUnrecognizedDescriptorLines, false, true);
        EnumSet<Key[]> exactlyOnceKeys = EnumSet.of(Key.NETWORK_STATUS_VERSION, new Key[]{Key.DIR_SOURCE, Key.FINGERPRINT, Key.CONTACT, Key.DIR_SIGNING_KEY, Key.PUBLISHED});
        this.checkExactlyOnceKeys(exactlyOnceKeys);
        EnumSet<Key> atMostOnceKeys = EnumSet.of(Key.DIR_OPTIONS, Key.CLIENT_VERSIONS, Key.SERVER_VERSIONS);
        this.checkAtMostOnceKeys(atMostOnceKeys);
        this.checkFirstKey(Key.NETWORK_STATUS_VERSION);
        this.clearParsedKeys();
        this.calculateDigestSha1Hex(Key.NETWORK_STATUS_VERSION.keyword + " ", "\n" + Key.DIRECTORY_SIGNATURE.keyword + " ");
    }

    @Override
    protected void parseHeader(int offset, int length) throws DescriptorParseException {
        Scanner scanner = this.newScanner(offset, length).useDelimiter("\n");
        Key nextCrypto = Key.EMPTY;
        StringBuilder crypto = null;
        block13: while (scanner.hasNext()) {
            String line = scanner.next();
            if (line.isEmpty()) continue;
            String[] parts = line.split("[ \t]+");
            Key key = Key.get(parts[0]);
            switch (key) {
                case NETWORK_STATUS_VERSION: {
                    this.parseNetworkStatusVersionLine(line, parts);
                    continue block13;
                }
                case DIR_SOURCE: {
                    this.parseDirSourceLine(line, parts);
                    continue block13;
                }
                case FINGERPRINT: {
                    this.parseFingerprintLine(line, parts);
                    continue block13;
                }
                case CONTACT: {
                    this.parseContactLine(line, parts);
                    continue block13;
                }
                case DIR_SIGNING_KEY: {
                    this.parseDirSigningKeyLine(line, parts);
                    nextCrypto = key;
                    continue block13;
                }
                case CLIENT_VERSIONS: {
                    this.parseClientVersionsLine(line, parts);
                    continue block13;
                }
                case SERVER_VERSIONS: {
                    this.parseServerVersionsLine(line, parts);
                    continue block13;
                }
                case PUBLISHED: {
                    this.parsePublishedLine(line, parts);
                    continue block13;
                }
                case DIR_OPTIONS: {
                    this.parseDirOptionsLine(line, parts);
                    continue block13;
                }
                case CRYPTO_BEGIN: {
                    crypto = new StringBuilder();
                    crypto.append(line).append("\n");
                    continue block13;
                }
                case CRYPTO_END: {
                    crypto.append(line).append("\n");
                    String cryptoString = crypto.toString();
                    crypto = null;
                    if (!nextCrypto.equals((Object)Key.DIR_SIGNING_KEY)) {
                        throw new DescriptorParseException("Unrecognized crypto block in v2 network status.");
                    }
                    this.dirSigningKey = cryptoString;
                    nextCrypto = Key.EMPTY;
                    continue block13;
                }
            }
            if (crypto != null) {
                crypto.append(line).append("\n");
                continue;
            }
            if (this.failUnrecognizedDescriptorLines) {
                throw new DescriptorParseException("Unrecognized line '" + line + "' in v2 network status.");
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.add(line);
        }
    }

    @Override
    protected void parseFooter(int offset, int length) throws DescriptorParseException {
        throw new DescriptorParseException("No directory footer expected in v2 network status.");
    }

    @Override
    protected void parseDirectorySignature(int offset, int length) throws DescriptorParseException {
        Scanner scanner = this.newScanner(offset, length).useDelimiter("\n");
        Key nextCrypto = Key.EMPTY;
        StringBuilder crypto = null;
        block5: while (scanner.hasNext()) {
            String line = scanner.next();
            String[] parts = line.split("[ \t]+");
            Key key = Key.get(parts[0]);
            switch (key) {
                case DIRECTORY_SIGNATURE: {
                    this.parseDirectorySignatureLine(line, parts);
                    nextCrypto = key;
                    continue block5;
                }
                case CRYPTO_BEGIN: {
                    crypto = new StringBuilder();
                    crypto.append(line).append("\n");
                    continue block5;
                }
                case CRYPTO_END: {
                    crypto.append(line).append("\n");
                    String cryptoString = crypto.toString();
                    crypto = null;
                    if (!nextCrypto.equals((Object)Key.DIRECTORY_SIGNATURE)) {
                        throw new DescriptorParseException("Unrecognized crypto block in v2 network status.");
                    }
                    this.directorySignature = cryptoString;
                    nextCrypto = Key.EMPTY;
                    continue block5;
                }
            }
            if (crypto != null) {
                crypto.append(line).append("\n");
                continue;
            }
            if (this.failUnrecognizedDescriptorLines) {
                throw new DescriptorParseException("Unrecognized line '" + line + "' in v2 network status.");
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.add(line);
        }
    }

    private void parseNetworkStatusVersionLine(String line, String[] parts) throws DescriptorParseException {
        if (!line.equals(Key.NETWORK_STATUS_VERSION.keyword + " " + "2")) {
            throw new DescriptorParseException("Illegal network status version number in line '" + line + "'.");
        }
        this.networkStatusVersion = 2;
    }

    private void parseDirSourceLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 4) {
            throw new DescriptorParseException("Illegal line '" + line + "' in v2 network status.");
        }
        if (parts[1].length() < 1) {
            throw new DescriptorParseException("Illegal hostname in '" + line + "'.");
        }
        this.address = ParseHelper.parseIpv4Address(line, parts[2]);
        this.dirPort = ParseHelper.parsePort(line, parts[3]);
    }

    private void parseFingerprintLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "' in v2 network status.");
        }
        this.fingerprint = ParseHelper.parseTwentyByteHexString(line, parts[1]);
    }

    private void parseContactLine(String line, String[] parts) throws DescriptorParseException {
        this.contactLine = line.length() > Key.CONTACT.keyword.length() + 1 ? line.substring(Key.CONTACT.keyword.length() + 1) : "";
    }

    private void parseDirSigningKeyLine(String line, String[] parts) throws DescriptorParseException {
        if (!line.equals(Key.DIR_SIGNING_KEY.keyword)) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    private void parseClientVersionsLine(String line, String[] parts) throws DescriptorParseException {
        this.recommendedClientVersions = this.parseClientOrServerVersions(line, parts);
    }

    private void parseServerVersionsLine(String line, String[] parts) throws DescriptorParseException {
        this.recommendedServerVersions = this.parseClientOrServerVersions(line, parts);
    }

    private void parsePublishedLine(String line, String[] parts) throws DescriptorParseException {
        this.publishedMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseDirOptionsLine(String line, String[] parts) throws DescriptorParseException {
        String[] dirOptions = new String[parts.length - 1];
        for (int i = 1; i < parts.length; ++i) {
            dirOptions[i - 1] = parts[i];
        }
        this.dirOptions = dirOptions;
    }

    private void parseDirectorySignatureLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length < 2) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        this.nickname = ParseHelper.parseNickname(line, parts[1]);
    }

    @Override
    public String getStatusDigest() {
        return this.getDigestSha1Hex();
    }

    @Override
    public int getNetworkStatusVersion() {
        return this.networkStatusVersion;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public int getDirport() {
        return this.dirPort;
    }

    @Override
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public String getContactLine() {
        return this.contactLine;
    }

    @Override
    public String getDirSigningKey() {
        return this.dirSigningKey;
    }

    @Override
    public List<String> getRecommendedClientVersions() {
        return this.recommendedClientVersions == null ? null : Arrays.asList(this.recommendedClientVersions);
    }

    @Override
    public List<String> getRecommendedServerVersions() {
        return this.recommendedServerVersions == null ? null : Arrays.asList(this.recommendedServerVersions);
    }

    @Override
    public long getPublishedMillis() {
        return this.publishedMillis;
    }

    @Override
    public SortedSet<String> getDirOptions() {
        return new TreeSet<String>(Arrays.asList(this.dirOptions));
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public String getDirectorySignature() {
        return this.directorySignature;
    }
}

