/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.TimeZone;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.ExitList;
import org.torproject.descriptor.ExitListEntry;
import org.torproject.descriptor.impl.DescriptorImpl;
import org.torproject.descriptor.impl.ExitListEntryImpl;
import org.torproject.descriptor.impl.ParseHelper;

public class ExitListImpl
extends DescriptorImpl
implements ExitList {
    private long downloadedMillis;
    private Set<ExitListEntry> oldExitListEntries = new HashSet<ExitListEntry>();
    private Set<ExitList.Entry> exitListEntries = new HashSet<ExitList.Entry>();

    protected ExitListImpl(byte[] rawDescriptorBytes, File descriptorfile, String fileName, boolean failUnrecognizedDescriptorLines) throws DescriptorParseException {
        super(rawDescriptorBytes, new int[]{0, rawDescriptorBytes.length}, descriptorfile, failUnrecognizedDescriptorLines, false);
        this.splitAndParseExitListEntries();
        this.setPublishedMillisFromFileName(fileName);
    }

    private void setPublishedMillisFromFileName(String fileName) throws DescriptorParseException {
        if (this.downloadedMillis == 0L && fileName.length() == "2012-02-01-04-06-24".length()) {
            try {
                SimpleDateFormat fileNameFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
                fileNameFormat.setLenient(false);
                fileNameFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                this.downloadedMillis = fileNameFormat.parse(fileName).getTime();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (this.downloadedMillis == 0L) {
            throw new DescriptorParseException("Unrecognized exit list file name '" + fileName + "'.");
        }
    }

    private void splitAndParseExitListEntries() throws DescriptorParseException {
        Scanner scanner = this.newScanner().useDelimiter("\n");
        StringBuilder sb = new StringBuilder();
        boolean firstEntry = true;
        block14: while (scanner.hasNext()) {
            String keyword;
            String line = scanner.next();
            if (line.startsWith("@")) {
                if (!scanner.hasNext()) {
                    throw new DescriptorParseException("Descriptor is empty.");
                }
                line = scanner.next();
            }
            String[] parts = line.split(" ");
            switch (keyword = parts[0]) {
                case "Downloaded": {
                    this.downloadedMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
                    continue block14;
                }
                case "ExitNode": {
                    if (!firstEntry) {
                        this.parseExitListEntry(sb.toString());
                    } else {
                        firstEntry = false;
                    }
                    sb = new StringBuilder();
                    sb.append(line).append("\n");
                    continue block14;
                }
                case "Published": {
                    sb.append(line).append("\n");
                    continue block14;
                }
                case "LastStatus": {
                    sb.append(line).append("\n");
                    continue block14;
                }
                case "ExitAddress": {
                    sb.append(line).append("\n");
                    continue block14;
                }
            }
            if (this.failUnrecognizedDescriptorLines) {
                throw new DescriptorParseException("Unrecognized line '" + line + "' in exit list.");
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.add(line);
        }
        this.parseExitListEntry(sb.toString());
    }

    protected void parseExitListEntry(String exitListEntryString) throws DescriptorParseException {
        ExitListEntryImpl exitListEntry = new ExitListEntryImpl(exitListEntryString, this.failUnrecognizedDescriptorLines);
        this.exitListEntries.add(exitListEntry);
        this.oldExitListEntries.addAll(exitListEntry.oldEntries());
        List<String> unrecognizedExitListEntryLines = exitListEntry.getAndClearUnrecognizedLines();
        if (unrecognizedExitListEntryLines != null) {
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.addAll(unrecognizedExitListEntryLines);
        }
    }

    @Override
    public long getDownloadedMillis() {
        return this.downloadedMillis;
    }

    @Override
    @Deprecated
    public Set<ExitListEntry> getExitListEntries() {
        return new HashSet<ExitListEntry>(this.oldExitListEntries);
    }

    @Override
    public Set<ExitList.Entry> getEntries() {
        return new HashSet<ExitList.Entry>(this.exitListEntries);
    }
}

