/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.util.EnumSet;
import java.util.Scanner;
import java.util.SortedMap;
import java.util.TreeMap;
import org.torproject.descriptor.BridgePoolAssignment;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.impl.DescriptorImpl;
import org.torproject.descriptor.impl.Key;
import org.torproject.descriptor.impl.ParseHelper;

public class BridgePoolAssignmentImpl
extends DescriptorImpl
implements BridgePoolAssignment {
    private long publishedMillis;
    private SortedMap<String, String> entries = new TreeMap<String, String>();

    protected BridgePoolAssignmentImpl(byte[] rawDescriptorBytes, int[] offsetAndlength, boolean failUnrecognizedDescriptorLines) throws DescriptorParseException {
        super(rawDescriptorBytes, offsetAndlength, failUnrecognizedDescriptorLines, false);
        this.parseDescriptorBytes();
        this.checkExactlyOnceKeys(EnumSet.of(Key.BRIDGE_POOL_ASSIGNMENT));
        this.checkFirstKey(Key.BRIDGE_POOL_ASSIGNMENT);
        this.clearParsedKeys();
    }

    private void parseDescriptorBytes() throws DescriptorParseException {
        Scanner scanner = this.newScanner().useDelimiter("\n");
        while (scanner.hasNext()) {
            String line = scanner.next();
            if (line.startsWith(Key.BRIDGE_POOL_ASSIGNMENT.keyword + " ")) {
                this.parseBridgePoolAssignmentLine(line);
                continue;
            }
            this.parseBridgeLine(line);
        }
    }

    private void parseBridgePoolAssignmentLine(String line) throws DescriptorParseException {
        String[] parts = line.split("[ \t]+");
        if (parts.length != 3) {
            throw new DescriptorParseException("Illegal line '" + line + "' in bridge pool assignment.");
        }
        this.publishedMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseBridgeLine(String line) throws DescriptorParseException {
        String[] parts = line.split("[ \t]+");
        if (parts.length < 2) {
            throw new DescriptorParseException("Illegal line '" + line + "' in bridge pool assignment.");
        }
        String fingerprint = ParseHelper.parseTwentyByteHexString(line, parts[0]);
        String poolAndDetails = line.substring(line.indexOf(" ") + 1);
        this.entries.put(fingerprint, poolAndDetails);
    }

    @Override
    public long getPublishedMillis() {
        return this.publishedMillis;
    }

    @Override
    public SortedMap<String, String> getEntries() {
        return new TreeMap<String, String>(this.entries);
    }
}

