/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.DescriptorParser;
import org.torproject.descriptor.impl.BridgeExtraInfoDescriptorImpl;
import org.torproject.descriptor.impl.BridgeNetworkStatusImpl;
import org.torproject.descriptor.impl.BridgePoolAssignmentImpl;
import org.torproject.descriptor.impl.BridgeServerDescriptorImpl;
import org.torproject.descriptor.impl.DescriptorImpl;
import org.torproject.descriptor.impl.DirectoryKeyCertificateImpl;
import org.torproject.descriptor.impl.ExitListImpl;
import org.torproject.descriptor.impl.Key;
import org.torproject.descriptor.impl.MicrodescriptorImpl;
import org.torproject.descriptor.impl.RelayDirectoryImpl;
import org.torproject.descriptor.impl.RelayExtraInfoDescriptorImpl;
import org.torproject.descriptor.impl.RelayNetworkStatusConsensusImpl;
import org.torproject.descriptor.impl.RelayNetworkStatusImpl;
import org.torproject.descriptor.impl.RelayNetworkStatusVoteImpl;
import org.torproject.descriptor.impl.RelayServerDescriptorImpl;
import org.torproject.descriptor.impl.TorperfResultImpl;

public class DescriptorParserImpl
implements DescriptorParser {
    private boolean failUnrecognizedDescriptorLines;

    @Override
    public void setFailUnrecognizedDescriptorLines(boolean failUnrecognizedDescriptorLines) {
        this.failUnrecognizedDescriptorLines = failUnrecognizedDescriptorLines;
    }

    @Override
    public List<Descriptor> parseDescriptors(byte[] rawDescriptorBytes, String fileName) throws DescriptorParseException {
        byte[] first100Chars = new byte[Math.min(100, rawDescriptorBytes.length)];
        System.arraycopy(rawDescriptorBytes, 0, first100Chars, 0, first100Chars.length);
        String firstLines = new String(first100Chars);
        if (firstLines.startsWith("@type network-status-consensus-3 1.") || firstLines.startsWith("@type network-status-microdesc-consensus-3 1.") || (firstLines.startsWith(Key.NETWORK_STATUS_VERSION.keyword + " " + "3") || firstLines.contains("\n" + Key.NETWORK_STATUS_VERSION.keyword + " " + "3")) && firstLines.contains("\n" + Key.VOTE_STATUS.keyword + " " + "consensus" + "\n")) {
            return DescriptorParserImpl.parseDescriptors(rawDescriptorBytes, Key.NETWORK_STATUS_VERSION, RelayNetworkStatusConsensusImpl.class, this.failUnrecognizedDescriptorLines);
        }
        if (firstLines.startsWith("@type network-status-vote-3 1.") || (firstLines.startsWith(Key.NETWORK_STATUS_VERSION.keyword + " " + "3" + "\n") || firstLines.contains("\n" + Key.NETWORK_STATUS_VERSION.keyword + " " + "3" + "\n")) && firstLines.contains("\n" + Key.VOTE_STATUS.keyword + " " + "vote" + "\n")) {
            return DescriptorParserImpl.parseDescriptors(rawDescriptorBytes, Key.NETWORK_STATUS_VERSION, RelayNetworkStatusVoteImpl.class, this.failUnrecognizedDescriptorLines);
        }
        if (firstLines.startsWith("@type bridge-network-status 1.") || firstLines.startsWith(Key.R.keyword + " ")) {
            ArrayList<Descriptor> parsedDescriptors = new ArrayList<Descriptor>();
            parsedDescriptors.add(new BridgeNetworkStatusImpl(rawDescriptorBytes, new int[]{0, rawDescriptorBytes.length}, fileName, this.failUnrecognizedDescriptorLines));
            return parsedDescriptors;
        }
        if (firstLines.startsWith("@type bridge-server-descriptor 1.")) {
            return DescriptorParserImpl.parseDescriptors(rawDescriptorBytes, Key.ROUTER, BridgeServerDescriptorImpl.class, this.failUnrecognizedDescriptorLines);
        }
        if (firstLines.startsWith("@type server-descriptor 1.") || firstLines.startsWith(Key.ROUTER.keyword + " ") || firstLines.contains("\n" + Key.ROUTER.keyword + " ")) {
            return DescriptorParserImpl.parseDescriptors(rawDescriptorBytes, Key.ROUTER, RelayServerDescriptorImpl.class, this.failUnrecognizedDescriptorLines);
        }
        if (firstLines.startsWith("@type bridge-extra-info 1.")) {
            return DescriptorParserImpl.parseDescriptors(rawDescriptorBytes, Key.EXTRA_INFO, BridgeExtraInfoDescriptorImpl.class, this.failUnrecognizedDescriptorLines);
        }
        if (firstLines.startsWith("@type extra-info 1.") || firstLines.startsWith(Key.EXTRA_INFO.keyword + " ") || firstLines.contains("\n" + Key.EXTRA_INFO.keyword + " ")) {
            return DescriptorParserImpl.parseDescriptors(rawDescriptorBytes, Key.EXTRA_INFO, RelayExtraInfoDescriptorImpl.class, this.failUnrecognizedDescriptorLines);
        }
        if (firstLines.startsWith("@type microdescriptor 1.") || firstLines.startsWith(Key.ONION_KEY.keyword + "\n") || firstLines.contains("\n" + Key.ONION_KEY.keyword + "\n")) {
            return DescriptorParserImpl.parseDescriptors(rawDescriptorBytes, Key.ONION_KEY, MicrodescriptorImpl.class, this.failUnrecognizedDescriptorLines);
        }
        if (firstLines.startsWith("@type bridge-pool-assignment 1.") || firstLines.startsWith(Key.BRIDGE_POOL_ASSIGNMENT.keyword + " ") || firstLines.contains("\n" + Key.BRIDGE_POOL_ASSIGNMENT.keyword + " ")) {
            return DescriptorParserImpl.parseDescriptors(rawDescriptorBytes, Key.BRIDGE_POOL_ASSIGNMENT, BridgePoolAssignmentImpl.class, this.failUnrecognizedDescriptorLines);
        }
        if (firstLines.startsWith("@type dir-key-certificate-3 1.") || firstLines.startsWith(Key.DIR_KEY_CERTIFICATE_VERSION.keyword + " ") || firstLines.contains("\n" + Key.DIR_KEY_CERTIFICATE_VERSION.keyword + " ")) {
            return DescriptorParserImpl.parseDescriptors(rawDescriptorBytes, Key.DIR_KEY_CERTIFICATE_VERSION, DirectoryKeyCertificateImpl.class, this.failUnrecognizedDescriptorLines);
        }
        if (firstLines.startsWith("@type tordnsel 1.") || firstLines.startsWith("ExitNode ") || firstLines.contains("\nExitNode ")) {
            ArrayList<Descriptor> parsedDescriptors = new ArrayList<Descriptor>();
            parsedDescriptors.add(new ExitListImpl(rawDescriptorBytes, fileName, this.failUnrecognizedDescriptorLines));
            return parsedDescriptors;
        }
        if (firstLines.startsWith("@type network-status-2 1.") || firstLines.startsWith(Key.NETWORK_STATUS_VERSION.keyword + " " + "2" + "\n") || firstLines.contains("\n" + Key.NETWORK_STATUS_VERSION.keyword + " " + "2" + "\n")) {
            return DescriptorParserImpl.parseDescriptors(rawDescriptorBytes, Key.NETWORK_STATUS_VERSION, RelayNetworkStatusImpl.class, this.failUnrecognizedDescriptorLines);
        }
        if (firstLines.startsWith("@type directory 1.") || firstLines.startsWith(Key.SIGNED_DIRECTORY.keyword + "\n") || firstLines.contains("\n" + Key.SIGNED_DIRECTORY.keyword + "\n")) {
            return DescriptorParserImpl.parseDescriptors(rawDescriptorBytes, Key.SIGNED_DIRECTORY, RelayDirectoryImpl.class, this.failUnrecognizedDescriptorLines);
        }
        if (firstLines.startsWith("@type torperf 1.")) {
            return TorperfResultImpl.parseTorperfResults(rawDescriptorBytes, this.failUnrecognizedDescriptorLines);
        }
        throw new DescriptorParseException("Could not detect descriptor type in descriptor starting with '" + firstLines + "'.");
    }

    private static List<Descriptor> parseDescriptors(byte[] rawDescriptorBytes, Key key, Class<? extends DescriptorImpl> descriptorClass, boolean failUnrecognizedDescriptorLines) throws DescriptorParseException {
        boolean containsAnnotations;
        Constructor<? extends DescriptorImpl> constructor;
        ArrayList<Descriptor> parsedDescriptors = new ArrayList<Descriptor>();
        try {
            constructor = descriptorClass.getDeclaredConstructor(byte[].class, int[].class, Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        int startAnnotations = 0;
        int endAllDescriptors = rawDescriptorBytes.length;
        String ascii = new String(rawDescriptorBytes, StandardCharsets.US_ASCII);
        boolean bl = containsAnnotations = ascii.startsWith("@") || ascii.contains("\n@");
        while (startAnnotations < endAllDescriptors) {
            int startDescriptor;
            if (startAnnotations == ascii.indexOf(key.keyword + " ", startAnnotations) || startAnnotations == ascii.indexOf(key.keyword + "\n")) {
                startDescriptor = startAnnotations;
            } else {
                startDescriptor = ascii.indexOf("\n" + key.keyword + " ", startAnnotations - 1);
                if (startDescriptor < 0) {
                    startDescriptor = ascii.indexOf("\n" + key.keyword + "\n", startAnnotations - 1);
                }
                if (startDescriptor < 0) break;
                ++startDescriptor;
            }
            int endDescriptor = -1;
            if (containsAnnotations) {
                endDescriptor = ascii.indexOf("\n@", startDescriptor);
            }
            if (endDescriptor < 0) {
                endDescriptor = ascii.indexOf("\n" + key.keyword + " ", startDescriptor);
            }
            if (endDescriptor < 0) {
                endDescriptor = ascii.indexOf("\n" + key.keyword + "\n", startDescriptor);
            }
            if (endDescriptor < 0) {
                endDescriptor = endAllDescriptors - 1;
            }
            int[] offsetAndLength = new int[]{startAnnotations, ++endDescriptor - startAnnotations};
            parsedDescriptors.add(DescriptorParserImpl.parseDescriptor(rawDescriptorBytes, offsetAndLength, constructor, failUnrecognizedDescriptorLines));
            startAnnotations = endDescriptor;
        }
        return parsedDescriptors;
    }

    private static Descriptor parseDescriptor(byte[] rawDescriptorBytes, int[] offsetAndLength, Constructor<? extends DescriptorImpl> constructor, boolean failUnrecognizedDescriptorLines) throws DescriptorParseException {
        try {
            return constructor.newInstance(rawDescriptorBytes, offsetAndLength, failUnrecognizedDescriptorLines);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException();
        }
    }
}

