/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.TreeMap;
import org.torproject.descriptor.DescriptorParseException;

public class KeyValueMap<T>
extends TreeMap<String, T> {
    private Class<T> clazz;

    public KeyValueMap(Class<T> clazz) {
        this.clazz = clazz;
    }

    private void putPair(String key, T value, String line, String listElement, int keyLength) throws DescriptorParseException {
        if (this.keySet().contains(key)) {
            throw new DescriptorParseException("Line '" + line + "' contains duplicate key '" + key + "'.");
        }
        if (null == key || key.isEmpty() || keyLength > 0 && key.length() != keyLength) {
            throw new DescriptorParseException("Line '" + line + "' contains an illegal key in list element '" + listElement + "'.");
        }
        if (null == value) {
            throw new DescriptorParseException("Line '" + line + "' contains an illegal value in list element '" + listElement + "'.");
        }
        this.put(key, value);
    }

    public KeyValueMap<T> parseKeyValueList(String line, String[] partsNoOpt, int startIndex, int keyLength, String separatorPattern) throws DescriptorParseException {
        int i;
        if (startIndex >= partsNoOpt.length) {
            return this;
        }
        String[] keysAndValues = " ".equals(separatorPattern) ? partsNoOpt : partsNoOpt[startIndex].split(separatorPattern, -1);
        int n = i = " ".equals(separatorPattern) ? startIndex : 0;
        while (i < keysAndValues.length) {
            String listElement = keysAndValues[i];
            String[] keyAndValue = listElement.split("=");
            String key = keyAndValue[0];
            Object value = null;
            if (keyAndValue.length == 2) {
                try {
                    Method method = this.clazz.getMethod("valueOf", String.class);
                    value = method.invoke(this.clazz, keyAndValue[1]);
                }
                catch (IllegalAccessException | SecurityException e) {
                    throw new RuntimeException("This shouldn't happen.", e);
                }
                catch (IllegalArgumentException | InvocationTargetException e) {
                    value = null;
                }
                catch (NoSuchMethodException e) {
                    value = keyAndValue[1];
                }
            }
            this.putPair(key, value, line, listElement, keyLength);
            ++i;
        }
        return this;
    }
}

