/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.DirSourceEntry;
import org.torproject.descriptor.impl.DescriptorImpl;
import org.torproject.descriptor.impl.Key;
import org.torproject.descriptor.impl.ParseHelper;

public class DirSourceEntryImpl
implements DirSourceEntry {
    private DescriptorImpl parent;
    private int offset;
    private int length;
    private boolean failUnrecognizedDescriptorLines;
    private List<String> unrecognizedLines;
    private Set<Key> exactlyOnceKeys = EnumSet.of(Key.DIR_SOURCE, Key.VOTE_DIGEST);
    private Set<Key> atMostOnceKeys = EnumSet.of(Key.CONTACT);
    private String nickname;
    private String identity;
    private boolean isLegacy;
    private String hostname;
    private String ip;
    private int dirPort;
    private int orPort;
    private String contactLine;
    private String voteDigest;

    @Override
    public byte[] getDirSourceEntryBytes() {
        return this.parent.getRawDescriptorBytes(this.offset, this.length);
    }

    protected List<String> getAndClearUnrecognizedLines() {
        List<String> lines = this.unrecognizedLines;
        this.unrecognizedLines = null;
        return lines;
    }

    protected DirSourceEntryImpl(DescriptorImpl parent, int offset, int length, boolean failUnrecognizedDescriptorLines) throws DescriptorParseException {
        this.parent = parent;
        this.offset = offset;
        this.length = length;
        this.failUnrecognizedDescriptorLines = failUnrecognizedDescriptorLines;
        this.parseDirSourceEntryBytes();
        this.checkAndClearKeys();
    }

    private void parsedExactlyOnceKey(Key key) throws DescriptorParseException {
        if (!this.exactlyOnceKeys.contains((Object)key)) {
            throw new DescriptorParseException("Duplicate '" + key.keyword + "' line in dir-source.");
        }
        this.exactlyOnceKeys.remove((Object)key);
    }

    private void parsedAtMostOnceKey(Key key) throws DescriptorParseException {
        if (!this.atMostOnceKeys.contains((Object)key)) {
            throw new DescriptorParseException("Duplicate " + key.keyword + "line in dir-source.");
        }
        this.atMostOnceKeys.remove((Object)key);
    }

    private void checkAndClearKeys() throws DescriptorParseException {
        Iterator<Key> iterator;
        if (!this.exactlyOnceKeys.isEmpty() && (iterator = this.exactlyOnceKeys.iterator()).hasNext()) {
            Key key = iterator.next();
            throw new DescriptorParseException("dir-source does not contain a '" + key.keyword + "' line.");
        }
        this.exactlyOnceKeys = null;
        this.atMostOnceKeys = null;
    }

    private void parseDirSourceEntryBytes() throws DescriptorParseException {
        Scanner scanner = this.parent.newScanner(this.offset, this.length).useDelimiter("\n");
        boolean skipCrypto = false;
        block7: while (scanner.hasNext()) {
            String line = scanner.next();
            String[] parts = line.split(" ");
            Key key = Key.get(parts[0]);
            switch (key) {
                case DIR_SOURCE: {
                    this.parseDirSourceLine(line);
                    continue block7;
                }
                case CONTACT: {
                    this.parseContactLine(line);
                    continue block7;
                }
                case VOTE_DIGEST: {
                    this.parseVoteDigestLine(line);
                    continue block7;
                }
                case CRYPTO_BEGIN: {
                    skipCrypto = true;
                    continue block7;
                }
                case CRYPTO_END: {
                    skipCrypto = false;
                    continue block7;
                }
            }
            if (skipCrypto) continue;
            if (this.failUnrecognizedDescriptorLines) {
                throw new DescriptorParseException("Unrecognized line '" + line + "' in dir-source entry.");
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList<String>();
            }
            this.unrecognizedLines.add(line);
        }
    }

    private void parseDirSourceLine(String line) throws DescriptorParseException {
        this.parsedExactlyOnceKey(Key.DIR_SOURCE);
        String[] parts = line.split("[ \t]+");
        if (parts.length != 7) {
            throw new DescriptorParseException("Invalid line '" + line + "'.");
        }
        String nickname = parts[1];
        if (nickname.endsWith("-legacy")) {
            nickname = nickname.substring(0, nickname.length() - "-legacy".length());
            this.isLegacy = true;
            this.parsedExactlyOnceKey(Key.VOTE_DIGEST);
        }
        this.nickname = ParseHelper.parseNickname(line, nickname);
        this.identity = ParseHelper.parseTwentyByteHexString(line, parts[2]);
        if (parts[3].length() < 1) {
            throw new DescriptorParseException("Illegal hostname in '" + line + "'.");
        }
        this.hostname = parts[3];
        this.ip = ParseHelper.parseIpv4Address(line, parts[4]);
        this.dirPort = ParseHelper.parsePort(line, parts[5]);
        this.orPort = ParseHelper.parsePort(line, parts[6]);
    }

    private void parseContactLine(String line) throws DescriptorParseException {
        this.parsedAtMostOnceKey(Key.CONTACT);
        this.contactLine = line.length() > Key.CONTACT.keyword.length() + 1 ? line.substring(Key.CONTACT.keyword.length() + 1) : "";
    }

    private void parseVoteDigestLine(String line) throws DescriptorParseException {
        this.parsedExactlyOnceKey(Key.VOTE_DIGEST);
        String[] parts = line.split("[ \t]+");
        if (parts.length != 2) {
            throw new DescriptorParseException("Invalid line '" + line + "'.");
        }
        this.voteDigest = ParseHelper.parseTwentyByteHexString(line, parts[1]);
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public boolean isLegacy() {
        return this.isLegacy;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public int getDirPort() {
        return this.dirPort;
    }

    @Override
    public int getOrPort() {
        return this.orPort;
    }

    @Override
    public String getContactLine() {
        return this.contactLine;
    }

    @Override
    public String getVoteDigest() {
        return this.getVoteDigestSha1Hex();
    }

    @Override
    public String getVoteDigestSha1Hex() {
        return this.voteDigest;
    }
}

