/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.coveragedata;

import java.io.Serializable;
import java.util.Arrays;
import net.sourceforge.cobertura.CoverageIgnore;
import net.sourceforge.cobertura.coveragedata.BranchCoverageData;

@CoverageIgnore
public class SwitchData
implements BranchCoverageData,
Comparable<Object>,
Serializable {
    private static final long serialVersionUID = 9L;
    private int switchNumber;
    private long defaultHits;
    private long[] hits;
    private int[] keys;
    private int maxBranches;

    public SwitchData(int switchNumber, int[] keys, int maxBranches) {
        this.switchNumber = switchNumber;
        this.defaultHits = 0L;
        this.hits = new long[keys.length];
        Arrays.fill(this.hits, 0L);
        this.keys = new int[keys.length];
        System.arraycopy(keys, 0, this.keys, 0, keys.length);
        this.maxBranches = maxBranches;
    }

    public SwitchData(int switchNumber, int min, int max, int maxBranches) {
        this.switchNumber = switchNumber;
        this.defaultHits = 0L;
        this.hits = new long[max - min + 1];
        Arrays.fill(this.hits, 0L);
        this.keys = new int[max - min + 1];
        int i = 0;
        while (min <= max) {
            this.keys[i++] = min++;
        }
        this.maxBranches = maxBranches;
    }

    public SwitchData(int switchNumber, int maxBranches) {
        this(switchNumber, new int[0], maxBranches);
    }

    @Override
    public int compareTo(Object o) {
        if (!o.getClass().equals(SwitchData.class)) {
            return Integer.MAX_VALUE;
        }
        return this.switchNumber - ((SwitchData)o).switchNumber;
    }

    void touchBranch(int branch, int new_hits) {
        if (branch == -1) {
            this.defaultHits += (long)new_hits;
        } else {
            if (this.hits.length <= branch) {
                long[] old = this.hits;
                this.hits = new long[branch + 1];
                System.arraycopy(old, 0, this.hits, 0, old.length);
                Arrays.fill(this.hits, old.length, this.hits.length - 1, 0L);
            }
            int n = branch;
            this.hits[n] = this.hits[n] + (long)new_hits;
        }
    }

    public int getSwitchNumber() {
        return this.switchNumber;
    }

    public long getHits(int branch) {
        return this.hits.length > branch ? this.hits[branch] : -1L;
    }

    public long getDefaultHits() {
        return this.defaultHits;
    }

    @Override
    public double getBranchCoverageRate() {
        int branches = this.getNumberOfValidBranches();
        int hit = this.defaultHits > 0L ? 1 : 0;
        int i = this.hits.length - 1;
        while (i >= 0) {
            hit += this.hits[i--] > 0L ? 1 : 0;
        }
        return (double)hit / (double)branches;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        SwitchData switchData = (SwitchData)obj;
        return this.defaultHits == switchData.defaultHits && Arrays.equals(this.hits, switchData.hits) && this.switchNumber == switchData.switchNumber;
    }

    public int hashCode() {
        return this.switchNumber;
    }

    @Override
    public int getNumberOfCoveredBranches() {
        int ret = this.defaultHits > 0L ? 1 : 0;
        for (int i = this.hits.length - 1; i >= 0; --i) {
            if (this.hits[i] <= 0L) continue;
            ++ret;
        }
        return ret;
    }

    @Override
    public int getNumberOfValidBranches() {
        return Math.min(this.hits.length + 1, this.maxBranches);
    }

    @Override
    public void merge(BranchCoverageData coverageData) {
        SwitchData switchData = (SwitchData)coverageData;
        this.defaultHits += switchData.defaultHits;
        for (int i = Math.min(this.hits.length, switchData.hits.length) - 1; i >= 0; --i) {
            int n = i;
            this.hits[n] = this.hits[n] + switchData.hits[i];
        }
        if (switchData.hits.length > this.hits.length) {
            long[] old = this.hits;
            this.hits = new long[switchData.hits.length];
            System.arraycopy(old, 0, this.hits, 0, old.length);
            System.arraycopy(switchData.hits, old.length, this.hits, old.length, this.hits.length - old.length);
        }
        if (this.keys.length == 0 && switchData.keys.length > 0) {
            this.keys = switchData.keys;
        }
        this.maxBranches = Math.min(this.maxBranches, switchData.getMaxBranches());
    }

    public int getMaxBranches() {
        return this.maxBranches;
    }

    public void setMaxBranches(int maxBranches) {
        this.maxBranches = maxBranches;
    }
}

