/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.bind.DatatypeConverter;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.DirectorySignature;
import org.torproject.descriptor.RelayNetworkStatusVote;
import org.torproject.descriptor.impl.DescriptorImpl;
import org.torproject.descriptor.impl.NetworkStatusImpl;
import org.torproject.descriptor.impl.ParseHelper;

public class RelayNetworkStatusVoteImpl
extends NetworkStatusImpl
implements RelayNetworkStatusVote {
    private String digestSha1Hex;
    private String nickname;
    private String identity;
    private String hostname;
    private String address;
    private int dirPort;
    private int orPort;
    private String contactLine;
    private boolean sharedRandParticipate = false;
    private List<String> sharedRandCommitLines = null;
    private int sharedRandPreviousNumReveals = -1;
    private String sharedRandPreviousValue = null;
    private int sharedRandCurrentNumReveals = -1;
    private String sharedRandCurrentValue = null;
    private int dirKeyCertificateVersion;
    private String legacyDirKey;
    private long dirKeyPublishedMillis;
    private long dirKeyExpiresMillis;
    private String dirIdentityKey;
    private String dirSigningKey;
    private String dirKeyCrosscert;
    private String dirKeyCertification;
    private int networkStatusVersion;
    private Integer[] consensusMethods;
    private long publishedMillis;
    private long validAfterMillis;
    private long freshUntilMillis;
    private long validUntilMillis;
    private long voteSeconds;
    private long distSeconds;
    private String[] recommendedClientVersions;
    private String[] recommendedServerVersions;
    private SortedMap<String, SortedSet<Long>> recommendedClientProtocols;
    private SortedMap<String, SortedSet<Long>> recommendedRelayProtocols;
    private SortedMap<String, SortedSet<Long>> requiredClientProtocols;
    private SortedMap<String, SortedSet<Long>> requiredRelayProtocols;
    private List<String> packageLines;
    private String[] knownFlags;
    private long stableUptime;
    private long stableMtbf;
    private long fastBandwidth;
    private double guardWfu;
    private long guardTk;
    private long guardBandwidthIncludingExits;
    private long guardBandwidthExcludingExits;
    private int enoughMtbfInfo;
    private int ignoringAdvertisedBws;
    private SortedMap<String, Integer> consensusParams;

    protected static List<RelayNetworkStatusVote> parseVotes(byte[] votesBytes, boolean failUnrecognizedDescriptorLines) throws DescriptorParseException {
        ArrayList<RelayNetworkStatusVote> parsedVotes = new ArrayList<RelayNetworkStatusVote>();
        List<byte[]> splitVotesBytes = DescriptorImpl.splitRawDescriptorBytes(votesBytes, "network-status-version 3");
        for (byte[] voteBytes : splitVotesBytes) {
            RelayNetworkStatusVoteImpl parsedVote = new RelayNetworkStatusVoteImpl(voteBytes, failUnrecognizedDescriptorLines);
            parsedVotes.add(parsedVote);
        }
        return parsedVotes;
    }

    protected RelayNetworkStatusVoteImpl(byte[] voteBytes, boolean failUnrecognizedDescriptorLines) throws DescriptorParseException {
        super(voteBytes, failUnrecognizedDescriptorLines, false, false);
        HashSet<String> exactlyOnceKeywords = new HashSet<String>(Arrays.asList("vote-status,published,valid-after,fresh-until,valid-until,voting-delay,known-flags,dir-source,dir-key-certificate-version,fingerprint,dir-key-published,dir-key-expires,dir-identity-key,dir-signing-key,dir-key-certification".split(",")));
        this.checkExactlyOnceKeywords(exactlyOnceKeywords);
        HashSet<String> atMostOnceKeywords = new HashSet<String>(Arrays.asList("consensus-methods,client-versions,server-versions,recommended-client-protocols,recommended-relay-protocols,required-client-protocols,required-relay-protocols,flag-thresholds,params,contact,shared-rand-participate,shared-rand-previous-value,shared-rand-current-value,legacy-key,dir-key-crosscert,dir-address,directory-footer".split(",")));
        this.checkAtMostOnceKeywords(atMostOnceKeywords);
        HashSet<String> atLeastOnceKeywords = new HashSet<String>(Arrays.asList("directory-signature"));
        this.checkAtLeastOnceKeywords(atLeastOnceKeywords);
        this.checkFirstKeyword("network-status-version");
        this.clearParsedKeywords();
        this.calculateDigest();
    }

    private void calculateDigest() throws DescriptorParseException {
        try {
            String ascii = new String(this.getRawDescriptorBytes(), "US-ASCII");
            String startToken = "network-status-version ";
            String sigToken = "\ndirectory-signature ";
            if (!ascii.contains(sigToken)) {
                return;
            }
            int start = ascii.indexOf(startToken);
            int sig = ascii.indexOf(sigToken) + sigToken.length();
            if (start >= 0 && sig >= 0 && sig > start) {
                byte[] forDigest = new byte[sig - start];
                System.arraycopy(this.getRawDescriptorBytes(), start, forDigest, 0, sig - start);
                this.digestSha1Hex = DatatypeConverter.printHexBinary((byte[])MessageDigest.getInstance("SHA-1").digest(forDigest)).toLowerCase();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (this.digestSha1Hex == null) {
            throw new DescriptorParseException("Could not calculate vote digest.");
        }
    }

    @Override
    protected void parseHeader(byte[] headerBytes) throws DescriptorParseException {
        this.stableUptime = -1L;
        this.stableMtbf = -1L;
        this.fastBandwidth = -1L;
        this.guardWfu = -1.0;
        this.guardTk = -1L;
        this.guardBandwidthIncludingExits = -1L;
        this.guardBandwidthExcludingExits = -1L;
        this.enoughMtbfInfo = -1;
        this.ignoringAdvertisedBws = -1;
        Scanner scanner = new Scanner(new String(headerBytes)).useDelimiter("\n");
        String nextCrypto = "";
        StringBuilder crypto = null;
        block88: while (scanner.hasNext()) {
            String keyword;
            String line = scanner.next();
            String[] parts = line.split("[ \t]+");
            switch (keyword = parts[0]) {
                case "network-status-version": {
                    this.parseNetworkStatusVersionLine(line, parts);
                    continue block88;
                }
                case "vote-status": {
                    this.parseVoteStatusLine(line, parts);
                    continue block88;
                }
                case "consensus-methods": {
                    this.parseConsensusMethodsLine(line, parts);
                    continue block88;
                }
                case "published": {
                    this.parsePublishedLine(line, parts);
                    continue block88;
                }
                case "valid-after": {
                    this.parseValidAfterLine(line, parts);
                    continue block88;
                }
                case "fresh-until": {
                    this.parseFreshUntilLine(line, parts);
                    continue block88;
                }
                case "valid-until": {
                    this.parseValidUntilLine(line, parts);
                    continue block88;
                }
                case "voting-delay": {
                    this.parseVotingDelayLine(line, parts);
                    continue block88;
                }
                case "client-versions": {
                    this.parseClientVersionsLine(line, parts);
                    continue block88;
                }
                case "server-versions": {
                    this.parseServerVersionsLine(line, parts);
                    continue block88;
                }
                case "recommended-client-protocols": {
                    this.parseRecommendedClientProtocolsLine(line, parts);
                    continue block88;
                }
                case "recommended-relay-protocols": {
                    this.parseRecommendedRelayProtocolsLine(line, parts);
                    continue block88;
                }
                case "required-client-protocols": {
                    this.parseRequiredClientProtocolsLine(line, parts);
                    continue block88;
                }
                case "required-relay-protocols": {
                    this.parseRequiredRelayProtocolsLine(line, parts);
                    continue block88;
                }
                case "package": {
                    this.parsePackageLine(line, parts);
                    continue block88;
                }
                case "known-flags": {
                    this.parseKnownFlagsLine(line, parts);
                    continue block88;
                }
                case "flag-thresholds": {
                    this.parseFlagThresholdsLine(line, parts);
                    continue block88;
                }
                case "params": {
                    this.parseParamsLine(line, parts);
                    continue block88;
                }
                case "dir-source": {
                    this.parseDirSourceLine(line, parts);
                    continue block88;
                }
                case "contact": {
                    this.parseContactLine(line, parts);
                    continue block88;
                }
                case "shared-rand-participate": {
                    this.parseSharedRandParticipateLine(line, parts);
                    continue block88;
                }
                case "shared-rand-commit": {
                    this.parseSharedRandCommitLine(line, parts);
                    continue block88;
                }
                case "shared-rand-previous-value": {
                    this.parseSharedRandPreviousValueLine(line, parts);
                    continue block88;
                }
                case "shared-rand-current-value": {
                    this.parseSharedRandCurrentValueLine(line, parts);
                    continue block88;
                }
                case "dir-key-certificate-version": {
                    this.parseDirKeyCertificateVersionLine(line, parts);
                    continue block88;
                }
                case "dir-address": {
                    this.parseDirAddressLine(line, parts);
                    continue block88;
                }
                case "fingerprint": {
                    this.parseFingerprintLine(line, parts);
                    continue block88;
                }
                case "legacy-dir-key": {
                    this.parseLegacyDirKeyLine(line, parts);
                    continue block88;
                }
                case "dir-key-published": {
                    this.parseDirKeyPublished(line, parts);
                    continue block88;
                }
                case "dir-key-expires": {
                    this.parseDirKeyExpiresLine(line, parts);
                    continue block88;
                }
                case "dir-identity-key": {
                    this.parseDirIdentityKeyLine(line, parts);
                    nextCrypto = "dir-identity-key";
                    continue block88;
                }
                case "dir-signing-key": {
                    this.parseDirSigningKeyLine(line, parts);
                    nextCrypto = "dir-signing-key";
                    continue block88;
                }
                case "dir-key-crosscert": {
                    this.parseDirKeyCrosscertLine(line, parts);
                    nextCrypto = "dir-key-crosscert";
                    continue block88;
                }
                case "dir-key-certification": {
                    this.parseDirKeyCertificationLine(line, parts);
                    nextCrypto = "dir-key-certification";
                    continue block88;
                }
                case "-----BEGIN": {
                    crypto = new StringBuilder();
                    crypto.append(line).append("\n");
                    continue block88;
                }
                case "-----END": {
                    crypto.append(line).append("\n");
                    String cryptoString = crypto.toString();
                    crypto = null;
                    switch (nextCrypto) {
                        case "dir-identity-key": {
                            this.dirIdentityKey = cryptoString;
                            break;
                        }
                        case "dir-signing-key": {
                            this.dirSigningKey = cryptoString;
                            break;
                        }
                        case "dir-key-crosscert": {
                            this.dirKeyCrosscert = cryptoString;
                            break;
                        }
                        case "dir-key-certification": {
                            this.dirKeyCertification = cryptoString;
                            break;
                        }
                        default: {
                            throw new DescriptorParseException("Unrecognized crypto block in vote.");
                        }
                    }
                    nextCrypto = "";
                    continue block88;
                }
            }
            if (crypto != null) {
                crypto.append(line).append("\n");
                continue;
            }
            if (this.failUnrecognizedDescriptorLines) {
                throw new DescriptorParseException("Unrecognized line '" + line + "' in vote.");
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.add(line);
        }
    }

    private void parseNetworkStatusVersionLine(String line, String[] parts) throws DescriptorParseException {
        if (!line.equals("network-status-version 3")) {
            throw new DescriptorParseException("Illegal network status version number in line '" + line + "'.");
        }
        this.networkStatusVersion = 3;
    }

    private void parseVoteStatusLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 2 || !parts[1].equals("vote")) {
            throw new DescriptorParseException("Line '" + line + "' indicates that this is not a vote.");
        }
    }

    private void parseConsensusMethodsLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length < 2) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        Integer[] consensusMethods = new Integer[parts.length - 1];
        for (int i = 1; i < parts.length; ++i) {
            int consensusMethod = -1;
            try {
                consensusMethod = Integer.parseInt(parts[i]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (consensusMethod < 1) {
                throw new DescriptorParseException("Illegal consensus method number in line '" + line + "'.");
            }
            consensusMethods[i - 1] = consensusMethod;
        }
        this.consensusMethods = consensusMethods;
    }

    private void parsePublishedLine(String line, String[] parts) throws DescriptorParseException {
        this.publishedMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseValidAfterLine(String line, String[] parts) throws DescriptorParseException {
        this.validAfterMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseFreshUntilLine(String line, String[] parts) throws DescriptorParseException {
        this.freshUntilMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseValidUntilLine(String line, String[] parts) throws DescriptorParseException {
        this.validUntilMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseVotingDelayLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 3) {
            throw new DescriptorParseException("Wrong number of values in line '" + line + "'.");
        }
        try {
            this.voteSeconds = Long.parseLong(parts[1]);
            this.distSeconds = Long.parseLong(parts[2]);
        }
        catch (NumberFormatException e) {
            throw new DescriptorParseException("Illegal values in line '" + line + "'.");
        }
    }

    private void parseClientVersionsLine(String line, String[] parts) throws DescriptorParseException {
        this.recommendedClientVersions = this.parseClientOrServerVersions(line, parts);
    }

    private void parseServerVersionsLine(String line, String[] parts) throws DescriptorParseException {
        this.recommendedServerVersions = this.parseClientOrServerVersions(line, parts);
    }

    private void parseRecommendedClientProtocolsLine(String line, String[] parts) throws DescriptorParseException {
        this.recommendedClientProtocols = ParseHelper.parseProtocolVersions(line, line, parts);
    }

    private void parseRecommendedRelayProtocolsLine(String line, String[] parts) throws DescriptorParseException {
        this.recommendedRelayProtocols = ParseHelper.parseProtocolVersions(line, line, parts);
    }

    private void parseRequiredClientProtocolsLine(String line, String[] parts) throws DescriptorParseException {
        this.requiredClientProtocols = ParseHelper.parseProtocolVersions(line, line, parts);
    }

    private void parseRequiredRelayProtocolsLine(String line, String[] parts) throws DescriptorParseException {
        this.requiredRelayProtocols = ParseHelper.parseProtocolVersions(line, line, parts);
    }

    private void parsePackageLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length < 5) {
            throw new DescriptorParseException("Wrong number of values in line '" + line + "'.");
        }
        if (this.packageLines == null) {
            this.packageLines = new ArrayList<String>();
        }
        this.packageLines.add(line.substring("package ".length()));
    }

    private void parseKnownFlagsLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length < 2) {
            throw new DescriptorParseException("No known flags in line '" + line + "'.");
        }
        String[] knownFlags = new String[parts.length - 1];
        for (int i = 1; i < parts.length; ++i) {
            knownFlags[i - 1] = parts[i];
        }
        this.knownFlags = knownFlags;
    }

    private void parseFlagThresholdsLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length < 2) {
            throw new DescriptorParseException("No flag thresholds in line '" + line + "'.");
        }
        SortedMap<String, String> flagThresholds = ParseHelper.parseKeyValueStringPairs(line, parts, 1, "=");
        try {
            for (Map.Entry<String, String> e : flagThresholds.entrySet()) {
                switch (e.getKey()) {
                    case "stable-uptime": {
                        this.stableUptime = Long.parseLong(e.getValue());
                        break;
                    }
                    case "stable-mtbf": {
                        this.stableMtbf = Long.parseLong(e.getValue());
                        break;
                    }
                    case "fast-speed": {
                        this.fastBandwidth = Long.parseLong(e.getValue());
                        break;
                    }
                    case "guard-wfu": {
                        this.guardWfu = Double.parseDouble(e.getValue().replaceAll("%", ""));
                        break;
                    }
                    case "guard-tk": {
                        this.guardTk = Long.parseLong(e.getValue());
                        break;
                    }
                    case "guard-bw-inc-exits": {
                        this.guardBandwidthIncludingExits = Long.parseLong(e.getValue());
                        break;
                    }
                    case "guard-bw-exc-exits": {
                        this.guardBandwidthExcludingExits = Long.parseLong(e.getValue());
                        break;
                    }
                    case "enough-mtbf": {
                        this.enoughMtbfInfo = Integer.parseInt(e.getValue());
                        break;
                    }
                    case "ignoring-advertised-bws": {
                        this.ignoringAdvertisedBws = Integer.parseInt(e.getValue());
                        break;
                    }
                }
            }
        }
        catch (NumberFormatException ex) {
            throw new DescriptorParseException("Illegal value in line '" + line + "'.");
        }
    }

    private void parseParamsLine(String line, String[] parts) throws DescriptorParseException {
        this.consensusParams = ParseHelper.parseKeyValueIntegerPairs(line, parts, 1, "=");
    }

    private void parseDirSourceLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 7) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        this.nickname = ParseHelper.parseNickname(line, parts[1]);
        this.identity = ParseHelper.parseTwentyByteHexString(line, parts[2]);
        if (parts[3].length() < 1) {
            throw new DescriptorParseException("Illegal hostname in '" + line + "'.");
        }
        this.hostname = parts[3];
        this.address = ParseHelper.parseIpv4Address(line, parts[4]);
        this.dirPort = ParseHelper.parsePort(line, parts[5]);
        this.orPort = ParseHelper.parsePort(line, parts[6]);
    }

    private void parseContactLine(String line, String[] parts) throws DescriptorParseException {
        this.contactLine = line.length() > "contact ".length() ? line.substring("contact ".length()) : "";
    }

    private void parseSharedRandParticipateLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 1) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        this.sharedRandParticipate = true;
    }

    private void parseSharedRandCommitLine(String line, String[] parts) throws DescriptorParseException {
        if (this.sharedRandCommitLines == null) {
            this.sharedRandCommitLines = new ArrayList<String>();
        }
        this.sharedRandCommitLines.add(line);
    }

    private void parseSharedRandPreviousValueLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 3) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        try {
            this.sharedRandPreviousNumReveals = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        this.sharedRandPreviousValue = parts[2];
    }

    private void parseSharedRandCurrentValueLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 3) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        try {
            this.sharedRandCurrentNumReveals = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        this.sharedRandCurrentValue = parts[2];
    }

    private void parseDirKeyCertificateVersionLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        try {
            this.dirKeyCertificateVersion = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            throw new DescriptorParseException("Illegal dir key certificate version in line '" + line + "'.");
        }
        if (this.dirKeyCertificateVersion < 1) {
            throw new DescriptorParseException("Illegal dir key certificate version in line '" + line + "'.");
        }
    }

    private void parseDirAddressLine(String line, String[] parts) {
    }

    private void parseFingerprintLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        ParseHelper.parseTwentyByteHexString(line, parts[1]);
    }

    private void parseLegacyDirKeyLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        this.legacyDirKey = ParseHelper.parseTwentyByteHexString(line, parts[1]);
    }

    private void parseDirKeyPublished(String line, String[] parts) throws DescriptorParseException {
        this.dirKeyPublishedMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseDirKeyExpiresLine(String line, String[] parts) throws DescriptorParseException {
        this.dirKeyExpiresMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseDirIdentityKeyLine(String line, String[] parts) throws DescriptorParseException {
        if (!line.equals("dir-identity-key")) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    private void parseDirSigningKeyLine(String line, String[] parts) throws DescriptorParseException {
        if (!line.equals("dir-signing-key")) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    private void parseDirKeyCrosscertLine(String line, String[] parts) throws DescriptorParseException {
        if (!line.equals("dir-key-crosscert")) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    private void parseDirKeyCertificationLine(String line, String[] parts) throws DescriptorParseException {
        if (!line.equals("dir-key-certification")) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    @Override
    protected void parseFooter(byte[] footerBytes) throws DescriptorParseException {
        Scanner scanner = new Scanner(new String(footerBytes)).useDelimiter("\n");
        while (scanner.hasNext()) {
            String line = scanner.next();
            if (line.equals("directory-footer")) continue;
            if (this.failUnrecognizedDescriptorLines) {
                throw new DescriptorParseException("Unrecognized line '" + line + "' in vote.");
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.add(line);
        }
    }

    @Override
    public String getDigestSha1Hex() {
        return this.digestSha1Hex;
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public int getDirport() {
        return this.dirPort;
    }

    @Override
    public int getOrport() {
        return this.orPort;
    }

    @Override
    public String getContactLine() {
        return this.contactLine;
    }

    @Override
    public boolean isSharedRandParticipate() {
        return this.sharedRandParticipate;
    }

    @Override
    public List<String> getSharedRandCommitLines() {
        return this.sharedRandCommitLines;
    }

    @Override
    public int getSharedRandPreviousNumReveals() {
        return this.sharedRandPreviousNumReveals;
    }

    @Override
    public String getSharedRandPreviousValue() {
        return this.sharedRandPreviousValue;
    }

    @Override
    public int getSharedRandCurrentNumReveals() {
        return this.sharedRandCurrentNumReveals;
    }

    @Override
    public String getSharedRandCurrentValue() {
        return this.sharedRandCurrentValue;
    }

    @Override
    public int getDirKeyCertificateVersion() {
        return this.dirKeyCertificateVersion;
    }

    @Override
    public String getLegacyDirKey() {
        return this.legacyDirKey;
    }

    @Override
    public long getDirKeyPublishedMillis() {
        return this.dirKeyPublishedMillis;
    }

    @Override
    public long getDirKeyExpiresMillis() {
        return this.dirKeyExpiresMillis;
    }

    @Override
    public String getDirIdentityKey() {
        return this.dirIdentityKey;
    }

    @Override
    public String getDirSigningKey() {
        return this.dirSigningKey;
    }

    @Override
    public String getDirKeyCrosscert() {
        return this.dirKeyCrosscert;
    }

    @Override
    public String getDirKeyCertification() {
        return this.dirKeyCertification;
    }

    @Override
    public String getSigningKeyDigest() {
        String signingKeyDigest = null;
        if (this.signatures != null && !this.signatures.isEmpty()) {
            for (DirectorySignature signature : this.signatures) {
                if (!"sha1".equals(signature.getAlgorithm())) continue;
                signingKeyDigest = signature.getSigningKeyDigestSha1Hex();
                break;
            }
        }
        return signingKeyDigest;
    }

    @Override
    public int getNetworkStatusVersion() {
        return this.networkStatusVersion;
    }

    @Override
    public List<Integer> getConsensusMethods() {
        return this.consensusMethods == null ? null : Arrays.asList(this.consensusMethods);
    }

    @Override
    public long getPublishedMillis() {
        return this.publishedMillis;
    }

    @Override
    public long getValidAfterMillis() {
        return this.validAfterMillis;
    }

    @Override
    public long getFreshUntilMillis() {
        return this.freshUntilMillis;
    }

    @Override
    public long getValidUntilMillis() {
        return this.validUntilMillis;
    }

    @Override
    public long getVoteSeconds() {
        return this.voteSeconds;
    }

    @Override
    public long getDistSeconds() {
        return this.distSeconds;
    }

    @Override
    public List<String> getRecommendedClientVersions() {
        return this.recommendedClientVersions == null ? null : Arrays.asList(this.recommendedClientVersions);
    }

    @Override
    public List<String> getRecommendedServerVersions() {
        return this.recommendedServerVersions == null ? null : Arrays.asList(this.recommendedServerVersions);
    }

    @Override
    public SortedMap<String, SortedSet<Long>> getRecommendedClientProtocols() {
        return this.recommendedClientProtocols;
    }

    @Override
    public SortedMap<String, SortedSet<Long>> getRecommendedRelayProtocols() {
        return this.recommendedRelayProtocols;
    }

    @Override
    public SortedMap<String, SortedSet<Long>> getRequiredClientProtocols() {
        return this.requiredClientProtocols;
    }

    @Override
    public SortedMap<String, SortedSet<Long>> getRequiredRelayProtocols() {
        return this.requiredRelayProtocols;
    }

    @Override
    public List<String> getPackageLines() {
        return this.packageLines == null ? null : new ArrayList<String>(this.packageLines);
    }

    @Override
    public SortedSet<String> getKnownFlags() {
        return new TreeSet<String>(Arrays.asList(this.knownFlags));
    }

    @Override
    public long getStableUptime() {
        return this.stableUptime;
    }

    @Override
    public long getStableMtbf() {
        return this.stableMtbf;
    }

    @Override
    public long getFastBandwidth() {
        return this.fastBandwidth;
    }

    @Override
    public double getGuardWfu() {
        return this.guardWfu;
    }

    @Override
    public long getGuardTk() {
        return this.guardTk;
    }

    @Override
    public long getGuardBandwidthIncludingExits() {
        return this.guardBandwidthIncludingExits;
    }

    @Override
    public long getGuardBandwidthExcludingExits() {
        return this.guardBandwidthExcludingExits;
    }

    @Override
    public int getEnoughMtbfInfo() {
        return this.enoughMtbfInfo;
    }

    @Override
    public int getIgnoringAdvertisedBws() {
        return this.ignoringAdvertisedBws;
    }

    @Override
    public SortedMap<String, Integer> getConsensusParams() {
        return this.consensusParams == null ? null : new TreeMap<String, Integer>(this.consensusParams);
    }
}

