/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.DirSourceEntry;
import org.torproject.descriptor.DirectorySignature;
import org.torproject.descriptor.NetworkStatusEntry;
import org.torproject.descriptor.impl.DescriptorImpl;
import org.torproject.descriptor.impl.DirSourceEntryImpl;
import org.torproject.descriptor.impl.DirectorySignatureImpl;
import org.torproject.descriptor.impl.NetworkStatusEntryImpl;

public abstract class NetworkStatusImpl
extends DescriptorImpl {
    protected SortedMap<String, DirSourceEntry> dirSourceEntries = new TreeMap<String, DirSourceEntry>();
    protected SortedMap<String, NetworkStatusEntry> statusEntries = new TreeMap<String, NetworkStatusEntry>();
    protected List<DirectorySignature> signatures;

    protected NetworkStatusImpl(byte[] rawDescriptorBytes, boolean failUnrecognizedDescriptorLines, boolean containsDirSourceEntries, boolean blankLinesAllowed) throws DescriptorParseException {
        super(rawDescriptorBytes, failUnrecognizedDescriptorLines, blankLinesAllowed);
        this.splitAndParseParts(this.rawDescriptorBytes, containsDirSourceEntries);
    }

    private void splitAndParseParts(byte[] rawDescriptorBytes, boolean containsDirSourceEntries) throws DescriptorParseException {
        int firstDirSourceIndex;
        int directoryFooterIndex;
        if (this.rawDescriptorBytes.length == 0) {
            throw new DescriptorParseException("Descriptor is empty.");
        }
        String descriptorString = new String(rawDescriptorBytes);
        int firstRIndex = this.findFirstIndexOfKeyword(descriptorString, "r");
        int endIndex = descriptorString.length();
        int firstDirectorySignatureIndex = this.findFirstIndexOfKeyword(descriptorString, "directory-signature");
        if (firstDirectorySignatureIndex < 0) {
            firstDirectorySignatureIndex = endIndex;
        }
        if ((directoryFooterIndex = this.findFirstIndexOfKeyword(descriptorString, "directory-footer")) < 0) {
            directoryFooterIndex = firstDirectorySignatureIndex;
        }
        if (firstRIndex < 0) {
            firstRIndex = directoryFooterIndex;
        }
        int n = firstDirSourceIndex = !containsDirSourceEntries ? -1 : this.findFirstIndexOfKeyword(descriptorString, "dir-source");
        if (firstDirSourceIndex < 0) {
            firstDirSourceIndex = firstRIndex;
        }
        if (firstDirSourceIndex > 0) {
            this.parseHeaderBytes(descriptorString, 0, firstDirSourceIndex);
        }
        if (firstRIndex > firstDirSourceIndex) {
            this.parseDirSourceBytes(descriptorString, firstDirSourceIndex, firstRIndex);
        }
        if (directoryFooterIndex > firstRIndex) {
            this.parseStatusEntryBytes(descriptorString, firstRIndex, directoryFooterIndex);
        }
        if (firstDirectorySignatureIndex > directoryFooterIndex) {
            this.parseDirectoryFooterBytes(descriptorString, directoryFooterIndex, firstDirectorySignatureIndex);
        }
        if (endIndex > firstDirectorySignatureIndex) {
            this.parseDirectorySignatureBytes(descriptorString, firstDirectorySignatureIndex, endIndex);
        }
    }

    private int findFirstIndexOfKeyword(String descriptorString, String keyword) {
        if (descriptorString.startsWith(keyword)) {
            return 0;
        }
        if (descriptorString.contains("\n" + keyword + " ")) {
            return descriptorString.indexOf("\n" + keyword + " ") + 1;
        }
        if (descriptorString.contains("\n" + keyword + "\n")) {
            return descriptorString.indexOf("\n" + keyword + "\n") + 1;
        }
        return -1;
    }

    private void parseHeaderBytes(String descriptorString, int start, int end) throws DescriptorParseException {
        byte[] headerBytes = new byte[end - start];
        System.arraycopy(this.rawDescriptorBytes, start, headerBytes, 0, end - start);
        this.parseHeader(headerBytes);
    }

    private void parseDirSourceBytes(String descriptorString, int start, int end) throws DescriptorParseException {
        List<byte[]> splitDirSourceBytes = this.splitByKeyword(descriptorString, "dir-source", start, end);
        for (byte[] dirSourceBytes : splitDirSourceBytes) {
            this.parseDirSource(dirSourceBytes);
        }
    }

    private void parseStatusEntryBytes(String descriptorString, int start, int end) throws DescriptorParseException {
        List<byte[]> splitStatusEntryBytes = this.splitByKeyword(descriptorString, "r", start, end);
        for (byte[] statusEntryBytes : splitStatusEntryBytes) {
            this.parseStatusEntry(statusEntryBytes);
        }
    }

    private void parseDirectoryFooterBytes(String descriptorString, int start, int end) throws DescriptorParseException {
        byte[] directoryFooterBytes = new byte[end - start];
        System.arraycopy(this.rawDescriptorBytes, start, directoryFooterBytes, 0, end - start);
        this.parseFooter(directoryFooterBytes);
    }

    private void parseDirectorySignatureBytes(String descriptorString, int start, int end) throws DescriptorParseException {
        List<byte[]> splitDirectorySignatureBytes = this.splitByKeyword(descriptorString, "directory-signature", start, end);
        for (byte[] directorySignatureBytes : splitDirectorySignatureBytes) {
            this.parseDirectorySignature(directorySignatureBytes);
        }
    }

    private List<byte[]> splitByKeyword(String descriptorString, String keyword, int start, int end) {
        ArrayList<byte[]> splitParts = new ArrayList<byte[]>();
        int from = start;
        while (from < end) {
            int to = descriptorString.indexOf("\n" + keyword + " ", from);
            if (to < 0) {
                to = descriptorString.indexOf("\n" + keyword + "\n", from);
            }
            to = to < 0 ? end : ++to;
            byte[] part = new byte[to - from];
            System.arraycopy(this.rawDescriptorBytes, from, part, 0, to - from);
            from = to;
            splitParts.add(part);
        }
        return splitParts;
    }

    protected abstract void parseHeader(byte[] var1) throws DescriptorParseException;

    protected void parseDirSource(byte[] dirSourceBytes) throws DescriptorParseException {
        DirSourceEntryImpl dirSourceEntry = new DirSourceEntryImpl(dirSourceBytes, this.failUnrecognizedDescriptorLines);
        this.dirSourceEntries.put(dirSourceEntry.getIdentity(), dirSourceEntry);
        List<String> unrecognizedDirSourceLines = dirSourceEntry.getAndClearUnrecognizedLines();
        if (unrecognizedDirSourceLines != null) {
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.addAll(unrecognizedDirSourceLines);
        }
    }

    protected String[] parseClientOrServerVersions(String line, String[] parts) throws DescriptorParseException {
        String[] result = null;
        switch (parts.length) {
            case 1: {
                result = new String[]{};
                break;
            }
            case 2: {
                for (String version : result = parts[1].split(",", -1)) {
                    if (version.length() >= 1) continue;
                    throw new DescriptorParseException("Illegal versions line '" + line + "'.");
                }
                break;
            }
            default: {
                throw new DescriptorParseException("Illegal versions line '" + line + "'.");
            }
        }
        return result;
    }

    protected void parseStatusEntry(byte[] statusEntryBytes) throws DescriptorParseException {
        NetworkStatusEntryImpl statusEntry = new NetworkStatusEntryImpl(statusEntryBytes, false, this.failUnrecognizedDescriptorLines);
        this.statusEntries.put(statusEntry.getFingerprint(), statusEntry);
        List<String> unrecognizedStatusEntryLines = statusEntry.getAndClearUnrecognizedLines();
        if (unrecognizedStatusEntryLines != null) {
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.addAll(unrecognizedStatusEntryLines);
        }
    }

    protected abstract void parseFooter(byte[] var1) throws DescriptorParseException;

    protected void parseDirectorySignature(byte[] directorySignatureBytes) throws DescriptorParseException {
        if (this.signatures == null) {
            this.signatures = new ArrayList<DirectorySignature>();
        }
        DirectorySignatureImpl signature = new DirectorySignatureImpl(directorySignatureBytes, this.failUnrecognizedDescriptorLines);
        this.signatures.add(signature);
        List<String> unrecognizedStatusEntryLines = signature.getAndClearUnrecognizedLines();
        if (unrecognizedStatusEntryLines != null) {
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.addAll(unrecognizedStatusEntryLines);
        }
    }

    public SortedMap<String, DirSourceEntry> getDirSourceEntries() {
        return new TreeMap<String, DirSourceEntry>(this.dirSourceEntries);
    }

    public SortedMap<String, NetworkStatusEntry> getStatusEntries() {
        return new TreeMap<String, NetworkStatusEntry>(this.statusEntries);
    }

    public boolean containsStatusEntry(String fingerprint) {
        return this.statusEntries.containsKey(fingerprint);
    }

    public NetworkStatusEntry getStatusEntry(String fingerprint) {
        return (NetworkStatusEntry)this.statusEntries.get(fingerprint);
    }

    public List<DirectorySignature> getSignatures() {
        return this.signatures == null ? null : new ArrayList<DirectorySignature>(this.signatures);
    }

    public SortedMap<String, DirectorySignature> getDirectorySignatures() {
        TreeMap<String, DirectorySignature> directorySignatures = null;
        if (this.signatures != null) {
            directorySignatures = new TreeMap<String, DirectorySignature>();
            for (DirectorySignature signature : this.signatures) {
                directorySignatures.put(signature.getIdentity(), signature);
            }
        }
        return directorySignatures;
    }
}

