/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.InflaterInputStream;
import org.torproject.descriptor.DescriptorParser;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.impl.DescriptorRequestImpl;
import org.torproject.descriptor.impl.DownloadCoordinator;

public class DirectoryDownloader
implements Runnable {
    private String nickname;
    private String ipPort;
    private DescriptorParser descriptorParser;
    private DownloadCoordinator downloadCoordinator;
    private long connectTimeout;
    private long readTimeout;

    protected DirectoryDownloader(String nickname, String ip, int dirPort) {
        this.nickname = nickname;
        this.ipPort = ip + ":" + String.valueOf(dirPort);
        this.descriptorParser = DescriptorSourceFactory.createDescriptorParser();
    }

    protected void setDownloadCoordinator(DownloadCoordinator downloadCoordinator) {
        this.downloadCoordinator = downloadCoordinator;
    }

    protected void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    protected void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    protected void setFailUnrecognizedDescriptorLines(boolean failUnrecognizedDescriptorLines) {
        this.descriptorParser.setFailUnrecognizedDescriptorLines(failUnrecognizedDescriptorLines);
    }

    @Override
    public void run() {
        boolean keepRunning = true;
        do {
            DescriptorRequestImpl request;
            if ((request = this.downloadCoordinator.createRequest(this.nickname)) != null) {
                String urlString = "http://" + this.ipPort + request.getRequestedResource();
                request.setRequestStart(System.currentTimeMillis());
                HttpURLConnection huc = null;
                try {
                    URL url = new URL(urlString);
                    huc = (HttpURLConnection)url.openConnection();
                    huc.setConnectTimeout((int)this.connectTimeout);
                    huc.setReadTimeout((int)this.readTimeout);
                    huc.setRequestMethod("GET");
                    huc.connect();
                    int responseCode = huc.getResponseCode();
                    request.setResponseCode(responseCode);
                    if (responseCode == 200) {
                        int len;
                        BufferedInputStream in = new BufferedInputStream(new InflaterInputStream(huc.getInputStream()));
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        byte[] data = new byte[8192];
                        while ((len = in.read(data, 0, 8192)) >= 0) {
                            baos.write(data, 0, len);
                        }
                        in.close();
                        byte[] responseBytes = baos.toByteArray();
                        request.setResponseBytes(responseBytes);
                        request.setRequestEnd(System.currentTimeMillis());
                        request.setDescriptors(this.descriptorParser.parseDescriptors(responseBytes, null));
                    }
                }
                catch (Exception e) {
                    request.setException(e);
                    if (huc != null) {
                        huc.disconnect();
                    }
                    keepRunning = false;
                }
                this.downloadCoordinator.deliverResponse(request);
                continue;
            }
            keepRunning = false;
        } while (keepRunning);
    }
}

