/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor;

import org.torproject.descriptor.DescriptorCollector;
import org.torproject.descriptor.DescriptorDownloader;
import org.torproject.descriptor.DescriptorParser;
import org.torproject.descriptor.DescriptorReader;
import org.torproject.descriptor.ImplementationNotAccessibleException;

public final class DescriptorSourceFactory {
    public static final String DOWNLOADER_DEFAULT = "org.torproject.descriptor.impl.DescriptorDownloaderImpl";
    public static final String PARSER_DEFAULT = "org.torproject.descriptor.impl.DescriptorParserImpl";
    public static final String READER_DEFAULT = "org.torproject.descriptor.impl.DescriptorReaderImpl";
    public static final String COLLECTOR_DEFAULT = "org.torproject.descriptor.impl.DescriptorCollectorImpl";
    public static final String PARSER_PROPERTY = "descriptor.parser";
    public static final String READER_PROPERTY = "descriptor.reader";
    public static final String DOWNLOADER_PROPERTY = "descriptor.downloader";
    public static final String COLLECTOR_PROPERTY = "descriptor.collector";

    public static final DescriptorParser createDescriptorParser() {
        return (DescriptorParser)DescriptorSourceFactory.retrieve(PARSER_PROPERTY);
    }

    public static final DescriptorReader createDescriptorReader() {
        return (DescriptorReader)DescriptorSourceFactory.retrieve(READER_PROPERTY);
    }

    public static final DescriptorDownloader createDescriptorDownloader() {
        return (DescriptorDownloader)DescriptorSourceFactory.retrieve(DOWNLOADER_PROPERTY);
    }

    public static final DescriptorCollector createDescriptorCollector() {
        return (DescriptorCollector)DescriptorSourceFactory.retrieve(COLLECTOR_PROPERTY);
    }

    private static final <T> Object retrieve(String type) {
        Object object;
        String clazzName = null;
        try {
            switch (type) {
                case "descriptor.parser": {
                    clazzName = System.getProperty(type, PARSER_DEFAULT);
                    break;
                }
                case "descriptor.downloader": {
                    clazzName = System.getProperty(type, DOWNLOADER_DEFAULT);
                    break;
                }
                case "descriptor.reader": {
                    clazzName = System.getProperty(type, READER_DEFAULT);
                    break;
                }
                case "descriptor.collector": {
                    clazzName = System.getProperty(type, COLLECTOR_DEFAULT);
                }
            }
            object = ClassLoader.getSystemClassLoader().loadClass(clazzName).newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new ImplementationNotAccessibleException("Cannot load class " + clazzName + "for type " + type, ex);
        }
        catch (InstantiationException ex) {
            throw new ImplementationNotAccessibleException("Cannot load class " + clazzName + "for type " + type, ex);
        }
        catch (IllegalAccessException ex) {
            throw new ImplementationNotAccessibleException("Cannot load class " + clazzName + "for type " + type, ex);
        }
        return object;
    }
}

