/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.exonerator;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.exonerator.QueryResponse;

public class QueryServlet
extends HttpServlet {
    private static final long serialVersionUID = 7109011659099295183L;
    private Logger logger;
    private DataSource ds;
    private static final long MILLISECONDS_IN_A_DAY = 86400000L;

    public void init() {
        this.logger = LoggerFactory.getLogger(QueryServlet.class);
        try {
            InitialContext cxt = new InitialContext();
            this.ds = (DataSource)cxt.lookup("java:comp/env/jdbc/exonerator");
            this.logger.info("Successfully looked up data source.");
        }
        catch (NamingException e) {
            this.logger.warn("Could not look up data source", (Throwable)e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String ipParameter = request.getParameter("ip");
            if (null == ipParameter) {
                response.sendError(400, "Missing ip parameter.");
                return;
            }
            String relayIp = this.parseIpParameter(ipParameter);
            if (null == relayIp) {
                response.sendError(400, "Invalid ip parameter.");
                return;
            }
            String timestampParameter = request.getParameter("timestamp");
            if (null == timestampParameter) {
                response.sendError(400, "Missing timestamp parameter.");
                return;
            }
            Long timestamp = this.parseTimestampParameter(timestampParameter);
            if (null == timestamp) {
                response.sendError(400, "Invalid timestamp parameter.");
                return;
            }
            if (this.checkTimestampTooRecent(timestampParameter)) {
                response.sendError(400, "Timestamp too recent.");
                return;
            }
            QueryResponse queryResponse = this.queryDatabase(relayIp, timestamp);
            if (null == queryResponse) {
                response.sendError(500, "Database error.");
            } else {
                response.setContentType("application/json");
                response.setCharacterEncoding("utf-8");
                response.getWriter().write(QueryResponse.toJson(queryResponse));
            }
        }
        catch (Throwable th) {
            this.logger.error("Some problem in doGet.  Returning error.", th);
            response.sendError(500, "General backend error.");
        }
    }

    private String parseIpParameter(String passedIpParameter) {
        String relayIp = null;
        if (passedIpParameter != null && passedIpParameter.length() > 0) {
            String ipParameter = passedIpParameter.trim();
            Pattern ipv4AddressPattern = Pattern.compile("^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
            Pattern ipv6AddressPattern = Pattern.compile("^\\[?[0-9a-fA-F:]{3,39}\\]?$");
            if (ipv4AddressPattern.matcher(ipParameter).matches()) {
                String[] ipParts = ipParameter.split("\\.");
                relayIp = Integer.parseInt(ipParts[0]) + "." + Integer.parseInt(ipParts[1]) + "." + Integer.parseInt(ipParts[2]) + "." + Integer.parseInt(ipParts[3]);
            } else if (ipv6AddressPattern.matcher(ipParameter).matches()) {
                String[] parts;
                if (ipParameter.startsWith("[") && ipParameter.endsWith("]")) {
                    ipParameter = ipParameter.substring(1, ipParameter.length() - 1);
                }
                StringBuilder addressHex = new StringBuilder();
                int start = ipParameter.startsWith("::") ? 1 : 0;
                int end = ipParameter.length() - (ipParameter.endsWith("::") ? 1 : 0);
                for (String part : parts = ipParameter.substring(start, end).split(":", -1)) {
                    if (part.length() == 0) {
                        addressHex.append("x");
                        continue;
                    }
                    if (part.length() <= 4) {
                        addressHex.append(String.format("%4s", part));
                        continue;
                    }
                    addressHex = null;
                    break;
                }
                if (addressHex != null) {
                    String addressHexString = addressHex.toString();
                    if (!(addressHexString = addressHexString.replaceFirst("x", String.format("%" + (33 - addressHexString.length()) + "s", "0"))).contains("x") && addressHexString.length() == 32) {
                        relayIp = ipParameter.toLowerCase();
                    }
                }
            }
        } else {
            relayIp = "";
        }
        return relayIp;
    }

    private String convertIpV4ToHex(String relayIp) {
        String[] relayIpParts = relayIp.split("\\.");
        byte[] address24Bytes = new byte[4];
        for (int i = 0; i < address24Bytes.length; ++i) {
            address24Bytes[i] = (byte)Integer.parseInt(relayIpParts[i]);
        }
        return Hex.encodeHexString((byte[])address24Bytes);
    }

    private String convertIpV6ToHex(String relayIp) {
        String[] parts;
        if (relayIp.startsWith("[") && relayIp.endsWith("]")) {
            relayIp = relayIp.substring(1, relayIp.length() - 1);
        }
        StringBuilder addressHex = new StringBuilder();
        int start = relayIp.startsWith("::") ? 1 : 0;
        int end = relayIp.length() - (relayIp.endsWith("::") ? 1 : 0);
        for (String part : parts = relayIp.substring(start, end).split(":", -1)) {
            if (part.length() == 0) {
                addressHex.append("x");
                continue;
            }
            if (part.length() <= 4) {
                addressHex.append(String.format("%4s", part));
                continue;
            }
            addressHex = null;
            break;
        }
        String address48 = null;
        if (addressHex != null) {
            String addressHexString = addressHex.toString();
            if (!(addressHexString = addressHexString.replaceFirst("x", String.format("%" + (33 - addressHexString.length()) + "s", "0"))).contains("x") && addressHexString.length() == 32) {
                address48 = addressHexString.replaceAll(" ", "0").toLowerCase();
            }
        }
        return address48;
    }

    private Long parseTimestampParameter(String passedTimestampParameter) {
        Long timestamp = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        dateFormat.setLenient(false);
        if (passedTimestampParameter != null && passedTimestampParameter.length() > 0) {
            String timestampParameter = passedTimestampParameter.trim();
            try {
                timestamp = dateFormat.parse(timestampParameter).getTime();
            }
            catch (ParseException e) {
                timestamp = null;
            }
        }
        return timestamp;
    }

    private boolean checkTimestampTooRecent(String timestampParameter) {
        return timestampParameter.compareTo(ZonedDateTime.now(ZoneOffset.UTC).toLocalDate().minusDays(1L).toString()) >= 0;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private QueryResponse queryDatabase(String relayIp, long timestamp) {
        TreeMap exitAddressesByFingeprintBase64AndScanned;
        TreeMap matchesByAddress;
        TreeMap matchesByFingerprintBase64AndValidAfter;
        TreeSet<Long> allDates;
        SimpleDateFormat dateFormat;
        block72: {
            String addressHex;
            String string = addressHex = !relayIp.contains(":") ? this.convertIpV4ToHex(relayIp) : this.convertIpV6ToHex(relayIp);
            if (addressHex == null) {
                return null;
            }
            String address24Hex = addressHex.substring(0, 6);
            dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            SimpleDateFormat validAfterTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            validAfterTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            allDates = new TreeSet<Long>();
            matchesByFingerprintBase64AndValidAfter = new TreeMap();
            matchesByAddress = new TreeMap();
            exitAddressesByFingeprintBase64AndScanned = new TreeMap();
            long requestedConnection = System.currentTimeMillis();
            Calendar utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            try (Connection conn = this.ds.getConnection();){
                CallableStatement cs = conn.prepareCall("{call search_by_date_address24(?, ?)}");
                Iterator iterator = null;
                cs.setDate(1, new Date(timestamp), utcCalendar);
                cs.setString(2, address24Hex);
                try (ResultSet resultSet = cs.executeQuery();){
                    while (resultSet.next()) {
                        Date date = resultSet.getDate(1, utcCalendar);
                        String fingerprintBase64 = resultSet.getString(2);
                        Timestamp scanned = resultSet.getTimestamp(3, utcCalendar);
                        String exitAddress = resultSet.getString(4);
                        Timestamp validAfter = resultSet.getTimestamp(5, utcCalendar);
                        String nickname = resultSet.getString(6);
                        Boolean exit = resultSet.getBoolean(7);
                        String orAddress = resultSet.getString(8);
                        if (null != date) {
                            allDates.add(date.getTime());
                            continue;
                        }
                        if (null != scanned) {
                            long scannedMillis = scanned.getTime();
                            exitAddressesByFingeprintBase64AndScanned.putIfAbsent(fingerprintBase64, new TreeMap());
                            ((SortedMap)exitAddressesByFingeprintBase64AndScanned.get(fingerprintBase64)).put(scannedMillis, exitAddress);
                            continue;
                        }
                        if (null == validAfter) continue;
                        long validAfterMillis = validAfter.getTime();
                        matchesByFingerprintBase64AndValidAfter.putIfAbsent(fingerprintBase64, new TreeMap());
                        if (!((SortedMap)matchesByFingerprintBase64AndValidAfter.get(fingerprintBase64)).containsKey(validAfterMillis)) {
                            String validAfterString = validAfterTimeFormat.format(validAfterMillis);
                            String fingerprint = Hex.encodeHexString((byte[])Base64.decodeBase64((String)(fingerprintBase64 + "="))).toUpperCase();
                            ((SortedMap)matchesByFingerprintBase64AndValidAfter.get(fingerprintBase64)).put(validAfterMillis, new QueryResponse.Match(validAfterString, new TreeSet<String>(), fingerprint, nickname, exit));
                        }
                        QueryResponse.Match match = (QueryResponse.Match)((SortedMap)matchesByFingerprintBase64AndValidAfter.get(fingerprintBase64)).get(validAfterMillis);
                        if (orAddress.contains(":")) {
                            match.addresses.add("[" + orAddress + "]");
                        } else {
                            match.addresses.add(orAddress);
                        }
                        matchesByAddress.putIfAbsent(orAddress, new HashSet());
                        ((Set)matchesByAddress.get(orAddress)).add(match);
                    }
                }
                catch (SQLException sQLException) {
                    this.logger.warn("Result set error.  Returning 'null'.", (Throwable)sQLException);
                    QueryResponse queryResponse = null;
                    if (cs != null) {
                        if (iterator != null) {
                            try {
                                cs.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)((Object)iterator)).addSuppressed(throwable);
                            }
                        } else {
                            cs.close();
                        }
                    }
                    if (conn != null) {
                        if (var16_15 != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable) {
                                var16_15.addSuppressed(throwable);
                            }
                        } else {
                            conn.close();
                        }
                    }
                    return queryResponse;
                }
                try {
                    this.logger.info("Returned a database connection to the pool after {} millis.", (Object)(System.currentTimeMillis() - requestedConnection));
                    break block72;
                }
                catch (Throwable throwable) {
                    iterator = throwable;
                    throw throwable;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                {
                    finally {
                        if (cs != null) {
                            if (iterator != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)((Object)iterator)).addSuppressed(throwable);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                }
                catch (SQLException e) {
                    this.logger.warn("Callable statement error.  Returning 'null'.", (Throwable)e);
                    iterator = null;
                    return iterator;
                }
            }
            catch (Throwable e) {
                this.logger.warn("Database error.  Returning 'null'.", e);
                return null;
            }
        }
        for (Map.Entry e : exitAddressesByFingeprintBase64AndScanned.entrySet()) {
            String fingerprintBase64 = (String)e.getKey();
            if (!matchesByFingerprintBase64AndValidAfter.containsKey(fingerprintBase64)) continue;
            for (Map.Entry entry : ((SortedMap)e.getValue()).entrySet()) {
                long scannedMillis = (Long)entry.getKey();
                String exitAddress = (String)entry.getValue();
                for (QueryResponse.Match match : ((SortedMap)matchesByFingerprintBase64AndValidAfter.get(fingerprintBase64)).subMap(scannedMillis, scannedMillis + 86400000L).values()) {
                    match.addresses.add(exitAddress);
                    matchesByAddress.putIfAbsent(exitAddress, new HashSet());
                    ((Set)matchesByAddress.get(exitAddress)).add(match);
                }
            }
        }
        QueryResponse response = new QueryResponse();
        response.queryAddress = relayIp;
        response.queryDate = dateFormat.format(timestamp);
        if (!allDates.isEmpty()) {
            response.firstDateInDatabase = dateFormat.format(allDates.first());
            response.lastDateInDatabase = dateFormat.format(allDates.last());
            response.relevantStatuses = allDates.contains(timestamp) || allDates.contains(timestamp - 86400000L) || allDates.contains(timestamp + 86400000L);
        }
        if (matchesByAddress.containsKey(relayIp)) {
            ArrayList matchesList = new ArrayList((Collection)matchesByAddress.get(relayIp));
            matchesList.sort((m1, m2) -> {
                if (m1 == m2) {
                    return 0;
                }
                if (!m1.timestamp.equals(m2.timestamp)) {
                    return m1.timestamp.compareTo(m2.timestamp);
                }
                return m1.fingerprint.compareTo(m2.fingerprint);
            });
            response.matches = matchesList.toArray(new QueryResponse.Match[0]);
        } else {
            TreeSet<String> nearbyAddresses = new TreeSet<String>();
            String relayIpHex24Or48 = !relayIp.contains(":") ? this.convertIpV4ToHex(relayIp).substring(0, 6) : this.convertIpV6ToHex(relayIp).substring(0, 12);
            for (String string : matchesByAddress.keySet()) {
                String nearbyAddressHex24Or48 = !string.contains(":") ? this.convertIpV4ToHex(string).substring(0, 6) : this.convertIpV6ToHex(string).substring(0, 12);
                if (!relayIpHex24Or48.equals(nearbyAddressHex24Or48)) continue;
                nearbyAddresses.add(string);
            }
            if (!nearbyAddresses.isEmpty()) {
                response.nearbyAddresses = nearbyAddresses.toArray(new String[0]);
            }
        }
        return response;
    }
}

