/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

public final class HashtableOfLong {
    public long[] keyTable;
    public Object[] valueTable;
    public int elementSize = 0;
    int threshold;

    public HashtableOfLong() {
        this(13);
    }

    public HashtableOfLong(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.75f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.keyTable = new long[n2];
        this.valueTable = new Object[n2];
    }

    public boolean containsKey(long l) {
        long l2;
        int n = this.keyTable.length;
        int n2 = (int)(l >>> 32) % n;
        while ((l2 = this.keyTable[n2]) != 0L) {
            if (l2 == l) {
                return true;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return false;
    }

    public Object get(long l) {
        long l2;
        int n = this.keyTable.length;
        int n2 = (int)(l >>> 32) % n;
        while ((l2 = this.keyTable[n2]) != 0L) {
            if (l2 == l) {
                return this.valueTable[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    public Object put(long l, Object object) {
        long l2;
        int n = this.keyTable.length;
        int n2 = (int)(l >>> 32) % n;
        while ((l2 = this.keyTable[n2]) != 0L) {
            if (l2 == l) {
                this.valueTable[n2] = object;
                return this.valueTable[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        this.keyTable[n2] = l;
        this.valueTable[n2] = object;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return object;
    }

    private void rehash() {
        HashtableOfLong hashtableOfLong = new HashtableOfLong(this.elementSize * 2);
        int n = this.keyTable.length;
        while (--n >= 0) {
            long l = this.keyTable[n];
            if (l == 0L) continue;
            hashtableOfLong.put(l, this.valueTable[n]);
        }
        this.keyTable = hashtableOfLong.keyTable;
        this.valueTable = hashtableOfLong.valueTable;
        this.threshold = hashtableOfLong.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String string = "";
        int n = 0;
        int n2 = this.valueTable.length;
        while (n < n2) {
            Object object = this.valueTable[n];
            if (object != null) {
                string = String.valueOf(string) + this.keyTable[n] + " -> " + object.toString() + "\n";
            }
            ++n;
        }
        return string;
    }
}

