/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.RecoveredAnnotation;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredInitializer;
import org.eclipse.jdt.internal.compiler.parser.RecoveredLocalVariable;
import org.eclipse.jdt.internal.compiler.parser.RecoveredMethod;
import org.eclipse.jdt.internal.compiler.parser.RecoveredStatement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredType;
import org.eclipse.jdt.internal.compiler.parser.TerminalTokens;

public class RecoveredBlock
extends RecoveredStatement
implements TerminalTokens {
    public Block blockDeclaration;
    public RecoveredStatement[] statements;
    public int statementCount;
    public boolean preserveContent = false;
    public RecoveredLocalVariable pendingArgument;
    int pendingModifiers;
    int pendingModifersSourceStart = -1;
    RecoveredAnnotation[] pendingAnnotations;
    int pendingAnnotationCount;

    public RecoveredBlock(Block block, RecoveredElement recoveredElement, int n) {
        super(block, recoveredElement, n);
        this.blockDeclaration = block;
        this.foundOpeningBrace = true;
        this.preserveContent = this.parser().methodRecoveryActivated || this.parser().statementRecoveryActivated;
    }

    public RecoveredElement add(AbstractMethodDeclaration abstractMethodDeclaration, int n) {
        if (this.parent != null && this.parent instanceof RecoveredMethod) {
            RecoveredMethod recoveredMethod = (RecoveredMethod)this.parent;
            if (recoveredMethod.methodBody == this && recoveredMethod.parent == null) {
                this.resetPendingModifiers();
                return this;
            }
        }
        return super.add(abstractMethodDeclaration, n);
    }

    public RecoveredElement add(Block block, int n) {
        this.resetPendingModifiers();
        if (this.blockDeclaration.sourceEnd != 0 && block.sourceStart > this.blockDeclaration.sourceEnd) {
            return this.parent.add(block, n);
        }
        RecoveredBlock recoveredBlock = new RecoveredBlock(block, (RecoveredElement)this, n);
        if (this.pendingArgument != null) {
            recoveredBlock.attach(this.pendingArgument);
            this.pendingArgument = null;
        }
        if (this.parser().statementRecoveryActivated) {
            this.addBlockStatement(recoveredBlock);
        }
        this.attach(recoveredBlock);
        if (block.sourceEnd == 0) {
            return recoveredBlock;
        }
        return this;
    }

    public RecoveredElement add(LocalDeclaration localDeclaration, int n) {
        return this.add(localDeclaration, n, false);
    }

    public RecoveredElement add(LocalDeclaration localDeclaration, int n, boolean bl) {
        if (localDeclaration.isRecoveredFromLoneIdentifier()) {
            return this;
        }
        if (this.blockDeclaration.sourceEnd != 0 && localDeclaration.declarationSourceStart > this.blockDeclaration.sourceEnd) {
            this.resetPendingModifiers();
            if (bl) {
                return this;
            }
            return this.parent.add(localDeclaration, n);
        }
        RecoveredLocalVariable recoveredLocalVariable = new RecoveredLocalVariable(localDeclaration, (RecoveredElement)this, n);
        if (this.pendingAnnotationCount > 0) {
            recoveredLocalVariable.attach(this.pendingAnnotations, this.pendingAnnotationCount, this.pendingModifiers, this.pendingModifersSourceStart);
        }
        this.resetPendingModifiers();
        if (localDeclaration instanceof Argument) {
            this.pendingArgument = recoveredLocalVariable;
            return this;
        }
        this.attach(recoveredLocalVariable);
        if (localDeclaration.declarationSourceEnd == 0) {
            return recoveredLocalVariable;
        }
        return this;
    }

    public RecoveredElement add(Statement statement, int n) {
        return this.add(statement, n, false);
    }

    public RecoveredElement add(Statement statement, int n, boolean bl) {
        this.resetPendingModifiers();
        if (this.blockDeclaration.sourceEnd != 0 && statement.sourceStart > this.blockDeclaration.sourceEnd) {
            if (bl) {
                return this;
            }
            return this.parent.add(statement, n);
        }
        RecoveredStatement recoveredStatement = new RecoveredStatement(statement, this, n);
        this.attach(recoveredStatement);
        if (statement.sourceEnd == 0) {
            return recoveredStatement;
        }
        return this;
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int n) {
        return this.add(typeDeclaration, n, false);
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int n, boolean bl) {
        if (this.blockDeclaration.sourceEnd != 0 && typeDeclaration.declarationSourceStart > this.blockDeclaration.sourceEnd) {
            this.resetPendingModifiers();
            if (bl) {
                return this;
            }
            return this.parent.add(typeDeclaration, n);
        }
        RecoveredType recoveredType = new RecoveredType(typeDeclaration, (RecoveredElement)this, n);
        if (this.pendingAnnotationCount > 0) {
            recoveredType.attach(this.pendingAnnotations, this.pendingAnnotationCount, this.pendingModifiers, this.pendingModifersSourceStart);
        }
        this.resetPendingModifiers();
        this.attach(recoveredType);
        if (typeDeclaration.declarationSourceEnd == 0) {
            return recoveredType;
        }
        return this;
    }

    public RecoveredElement addAnnotationName(int n, int n2, int n3, int n4) {
        if (this.pendingAnnotations == null) {
            this.pendingAnnotations = new RecoveredAnnotation[5];
            this.pendingAnnotationCount = 0;
        } else if (this.pendingAnnotationCount == this.pendingAnnotations.length) {
            this.pendingAnnotations = new RecoveredAnnotation[2 * this.pendingAnnotationCount];
            System.arraycopy(this.pendingAnnotations, 0, this.pendingAnnotations, 0, this.pendingAnnotationCount);
        }
        RecoveredAnnotation recoveredAnnotation = new RecoveredAnnotation(n, n2, n3, this, n4);
        this.pendingAnnotations[this.pendingAnnotationCount++] = recoveredAnnotation;
        return recoveredAnnotation;
    }

    public void addModifier(int n, int n2) {
        this.pendingModifiers |= n;
        if (this.pendingModifersSourceStart < 0) {
            this.pendingModifersSourceStart = n2;
        }
    }

    void attach(RecoveredStatement recoveredStatement) {
        if (this.statements == null) {
            this.statements = new RecoveredStatement[5];
            this.statementCount = 0;
        } else if (this.statementCount == this.statements.length) {
            this.statements = new RecoveredStatement[2 * this.statementCount];
            System.arraycopy(this.statements, 0, this.statements, 0, this.statementCount);
        }
        this.statements[this.statementCount++] = recoveredStatement;
    }

    void attachPendingModifiers(RecoveredAnnotation[] recoveredAnnotationArray, int n, int n2, int n3) {
        this.pendingAnnotations = recoveredAnnotationArray;
        this.pendingAnnotationCount = n;
        this.pendingModifiers = n2;
        this.pendingModifersSourceStart = n3;
    }

    public ASTNode parseTree() {
        return this.blockDeclaration;
    }

    public void resetPendingModifiers() {
        this.pendingAnnotations = null;
        this.pendingAnnotationCount = 0;
        this.pendingModifiers = 0;
        this.pendingModifersSourceStart = -1;
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.tabString(n));
        stringBuffer.append("Recovered block:\n");
        this.blockDeclaration.print(n + 1, stringBuffer);
        if (this.statements != null) {
            int n2 = 0;
            while (n2 < this.statementCount) {
                stringBuffer.append("\n");
                stringBuffer.append(this.statements[n2].toString(n + 1));
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public Block updatedBlock(int n, Set set) {
        RecoveredStatement recoveredStatement;
        if (!this.preserveContent || this.statementCount == 0) {
            return null;
        }
        Statement[] statementArray = new Statement[this.statementCount];
        int n2 = 0;
        RecoveredStatement recoveredStatement2 = this.statements[this.statementCount - 1];
        RecoveredMethod recoveredMethod = this.enclosingMethod();
        RecoveredInitializer recoveredInitializer = this.enclosingInitializer();
        int n3 = 0;
        if (recoveredMethod != null) {
            n3 = recoveredMethod.methodDeclaration.bodyEnd;
            if (recoveredInitializer != null && recoveredMethod.methodDeclaration.sourceStart < recoveredInitializer.fieldDeclaration.sourceStart) {
                n3 = recoveredInitializer.fieldDeclaration.declarationSourceEnd;
            }
        } else {
            n3 = recoveredInitializer != null ? recoveredInitializer.fieldDeclaration.declarationSourceEnd : this.blockDeclaration.sourceEnd - 1;
        }
        if (recoveredStatement2 instanceof RecoveredLocalVariable) {
            recoveredStatement = (RecoveredLocalVariable)recoveredStatement2;
            if (recoveredStatement.localDeclaration.declarationSourceEnd == 0) {
                recoveredStatement.localDeclaration.declarationSourceEnd = n3;
                recoveredStatement.localDeclaration.declarationEnd = n3;
            }
        } else if (recoveredStatement2 instanceof RecoveredBlock) {
            recoveredStatement = (RecoveredBlock)recoveredStatement2;
            if (((RecoveredBlock)recoveredStatement).blockDeclaration.sourceEnd == 0) {
                ((RecoveredBlock)recoveredStatement).blockDeclaration.sourceEnd = n3;
            }
        } else if (!(recoveredStatement2 instanceof RecoveredType) && recoveredStatement2.statement.sourceEnd == 0) {
            recoveredStatement2.statement.sourceEnd = n3;
        }
        int n4 = this.blockDeclaration.sourceStart;
        int n5 = 0;
        while (n5 < this.statementCount) {
            block28: {
                Statement statement = this.statements[n5].updatedStatement(n, set);
                if (statement != null) {
                    int n6 = 0;
                    while (n6 < n5) {
                        if (statementArray[n6] instanceof LocalDeclaration) {
                            LocalDeclaration localDeclaration = (LocalDeclaration)statementArray[n6];
                            if (localDeclaration.initialization != null && statement.sourceStart >= localDeclaration.initialization.sourceStart && statement.sourceEnd <= localDeclaration.initialization.sourceEnd) break block28;
                        }
                        ++n6;
                    }
                    statementArray[n2++] = statement;
                    if (statement instanceof LocalDeclaration) {
                        LocalDeclaration localDeclaration = (LocalDeclaration)statement;
                        if (localDeclaration.declarationSourceEnd > n4) {
                            n4 = localDeclaration.declarationSourceEnd;
                        }
                    } else if (statement instanceof TypeDeclaration) {
                        TypeDeclaration typeDeclaration = (TypeDeclaration)statement;
                        if (typeDeclaration.declarationSourceEnd > n4) {
                            n4 = typeDeclaration.declarationSourceEnd;
                        }
                    } else if (statement.sourceEnd > n4) {
                        n4 = statement.sourceEnd;
                    }
                }
            }
            ++n5;
        }
        if (n2 == 0) {
            return null;
        }
        if (n2 != this.statementCount) {
            this.blockDeclaration.statements = new Statement[n2];
            System.arraycopy(statementArray, 0, this.blockDeclaration.statements, 0, n2);
        } else {
            this.blockDeclaration.statements = statementArray;
        }
        if (this.blockDeclaration.sourceEnd == 0) {
            this.blockDeclaration.sourceEnd = n4 < n3 ? n3 : n4;
        }
        return this.blockDeclaration;
    }

    public Statement updatedStatement(int n, Set set) {
        return this.updatedBlock(n, set);
    }

    public RecoveredElement updateOnClosingBrace(int n, int n2) {
        if (--this.bracketBalance <= 0 && this.parent != null) {
            this.updateSourceEndIfNecessary(n, n2);
            RecoveredMethod recoveredMethod = this.enclosingMethod();
            if (recoveredMethod != null && recoveredMethod.methodBody == this) {
                return this.parent.updateOnClosingBrace(n, n2);
            }
            RecoveredInitializer recoveredInitializer = this.enclosingInitializer();
            if (recoveredInitializer != null && recoveredInitializer.initializerBody == this) {
                return this.parent.updateOnClosingBrace(n, n2);
            }
            return this.parent;
        }
        return this;
    }

    public RecoveredElement updateOnOpeningBrace(int n, int n2) {
        Block block = new Block(0);
        block.sourceStart = this.parser().scanner.startPosition;
        return this.add(block, 1);
    }

    public void updateParseTree() {
        this.updatedBlock(0, new HashSet());
    }

    public RecoveredElement add(FieldDeclaration fieldDeclaration, int n) {
        char[][] cArray;
        this.resetPendingModifiers();
        if ((fieldDeclaration.modifiers & 0xFFFFFFEF) != 0 || fieldDeclaration.type == null || (cArray = fieldDeclaration.type.getTypeName()).length == 1 && CharOperation.equals(cArray[0], TypeBinding.VOID.sourceName())) {
            this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(fieldDeclaration.declarationSourceStart - 1));
            return this.parent.add(fieldDeclaration, n);
        }
        if (this.blockDeclaration.sourceEnd != 0 && fieldDeclaration.declarationSourceStart > this.blockDeclaration.sourceEnd) {
            return this.parent.add(fieldDeclaration, n);
        }
        return this;
    }
}

