/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.HashMap;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.lookup.AnnotatableTypeSystem;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionTypeBinding18;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedAnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.Util;

public class TypeSystem {
    private int typeid = 128;
    private TypeBinding[][] types;
    protected HashedParameterizedTypes parameterizedTypes;
    private SimpleLookupTable annotationTypes;
    LookupEnvironment environment;

    public TypeSystem(LookupEnvironment lookupEnvironment) {
        this.environment = lookupEnvironment;
        this.annotationTypes = new SimpleLookupTable(16);
        this.typeid = 128;
        this.types = new TypeBinding[256][];
        this.parameterizedTypes = new HashedParameterizedTypes();
    }

    public final TypeBinding getUnannotatedType(TypeBinding typeBinding) {
        int n;
        UnresolvedReferenceBinding unresolvedReferenceBinding = null;
        if (typeBinding.isUnresolvedType() && CharOperation.indexOf('$', typeBinding.sourceName()) > 0) {
            unresolvedReferenceBinding = (UnresolvedReferenceBinding)typeBinding;
            n = this.environment.mayTolerateMissingType ? 1 : 0;
            this.environment.mayTolerateMissingType = true;
            try {
                typeBinding = BinaryTypeBinding.resolveType(typeBinding, this.environment, true);
            }
            finally {
                this.environment.mayTolerateMissingType = n;
            }
        }
        if (typeBinding.id == Integer.MAX_VALUE) {
            if (typeBinding.hasTypeAnnotations()) {
                throw new IllegalStateException();
            }
            n = this.types.length;
            if (this.typeid == n) {
                this.types = new TypeBinding[n * 2][];
                System.arraycopy(this.types, 0, this.types, 0, n);
            }
            typeBinding.id = this.typeid++;
            this.types[typeBinding.id] = new TypeBinding[4];
            if (unresolvedReferenceBinding != null) {
                unresolvedReferenceBinding.id = typeBinding.id;
            }
        } else {
            TypeBinding typeBinding2;
            TypeBinding typeBinding3 = typeBinding2 = this.types[typeBinding.id] == null ? null : this.types[typeBinding.id][0];
            if (typeBinding.hasTypeAnnotations() && typeBinding2 == null) {
                throw new IllegalStateException();
            }
            if (typeBinding2 != null) {
                return typeBinding2;
            }
            this.types[typeBinding.id] = new TypeBinding[4];
        }
        TypeBinding typeBinding4 = typeBinding;
        this.types[typeBinding.id][0] = typeBinding4;
        return typeBinding4;
    }

    public void forceRegisterAsDerived(TypeBinding typeBinding) {
        TypeBinding typeBinding2;
        int n = typeBinding.id;
        if (n != Integer.MAX_VALUE && this.types[n] != null) {
            typeBinding2 = this.types[n][0];
            if (typeBinding2 == typeBinding) {
                this.types[n][0] = typeBinding2 = typeBinding.clone(null);
            }
        } else {
            throw new IllegalStateException("Type was not yet registered as expected: " + typeBinding);
        }
        this.cacheDerivedType(typeBinding2, typeBinding);
    }

    public TypeBinding[] getAnnotatedTypes(TypeBinding typeBinding) {
        return Binding.NO_TYPES;
    }

    public ArrayBinding getArrayType(TypeBinding typeBinding, int n) {
        TypeBinding typeBinding2;
        if (typeBinding instanceof ArrayBinding) {
            n += typeBinding.dimensions();
            typeBinding = typeBinding.leafComponentType();
        }
        TypeBinding typeBinding3 = this.getUnannotatedType(typeBinding);
        TypeBinding[] typeBindingArray = this.types[typeBinding3.id];
        int n2 = typeBindingArray.length;
        int n3 = 0;
        while (n3 < n2) {
            typeBinding2 = typeBindingArray[n3];
            if (typeBinding2 == null) break;
            if (typeBinding2.isArrayType() && !typeBinding2.hasTypeAnnotations() && typeBinding2.leafComponentType() == typeBinding3 && typeBinding2.dimensions() == n) {
                return (ArrayBinding)typeBinding2;
            }
            ++n3;
        }
        if (n3 == n2) {
            TypeBinding[] typeBindingArray2 = typeBindingArray;
            typeBindingArray = new TypeBinding[n2 * 2];
            System.arraycopy(typeBindingArray2, 0, typeBindingArray, 0, n2);
            this.types[typeBinding3.id] = typeBindingArray;
        }
        typeBinding2 = typeBindingArray[n3] = new ArrayBinding(typeBinding3, n, this.environment);
        int n4 = this.types.length;
        if (this.typeid == n4) {
            this.types = new TypeBinding[n4 * 2][];
            System.arraycopy(this.types, 0, this.types, 0, n4);
        }
        this.types[this.typeid] = new TypeBinding[1];
        typeBinding2.id = this.typeid++;
        TypeBinding typeBinding4 = typeBinding2;
        this.types[typeBinding2.id][0] = typeBinding4;
        return (ArrayBinding)typeBinding4;
    }

    public ArrayBinding getArrayType(TypeBinding typeBinding, int n, AnnotationBinding[] annotationBindingArray) {
        return this.getArrayType(typeBinding, n);
    }

    public ReferenceBinding getMemberType(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        return referenceBinding;
    }

    public ParameterizedTypeBinding getParameterizedType(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding2) {
        ReferenceBinding referenceBinding3 = (ReferenceBinding)this.getUnannotatedType(referenceBinding);
        int n = typeBindingArray == null ? 0 : typeBindingArray.length;
        TypeBinding[] typeBindingArray2 = typeBindingArray == null ? null : new TypeBinding[n];
        int n2 = 0;
        while (n2 < n) {
            typeBindingArray2[n2] = this.getUnannotatedType(typeBindingArray[n2]);
            ++n2;
        }
        ReferenceBinding referenceBinding4 = referenceBinding2 == null ? null : (ReferenceBinding)this.getUnannotatedType(referenceBinding2);
        ParameterizedTypeBinding parameterizedTypeBinding = this.parameterizedTypes.get(referenceBinding3, typeBindingArray2, referenceBinding4, Binding.NO_ANNOTATIONS);
        if (parameterizedTypeBinding != null) {
            return parameterizedTypeBinding;
        }
        parameterizedTypeBinding = new ParameterizedTypeBinding(referenceBinding3, typeBindingArray2, referenceBinding4, this.environment);
        this.cacheDerivedType(referenceBinding3, parameterizedTypeBinding);
        this.parameterizedTypes.put(referenceBinding, typeBindingArray, referenceBinding2, parameterizedTypeBinding);
        int n3 = this.types.length;
        if (this.typeid == n3) {
            this.types = new TypeBinding[n3 * 2][];
            System.arraycopy(this.types, 0, this.types, 0, n3);
        }
        this.types[this.typeid] = new TypeBinding[1];
        parameterizedTypeBinding.id = this.typeid++;
        ParameterizedTypeBinding parameterizedTypeBinding2 = parameterizedTypeBinding;
        this.types[parameterizedTypeBinding.id][0] = parameterizedTypeBinding2;
        return parameterizedTypeBinding2;
    }

    public ParameterizedTypeBinding getParameterizedType(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding2, AnnotationBinding[] annotationBindingArray) {
        return this.getParameterizedType(referenceBinding, typeBindingArray, referenceBinding2);
    }

    public RawTypeBinding getRawType(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        TypeBinding typeBinding;
        ReferenceBinding referenceBinding3 = (ReferenceBinding)this.getUnannotatedType(referenceBinding);
        ReferenceBinding referenceBinding4 = referenceBinding2 == null ? null : (ReferenceBinding)this.getUnannotatedType(referenceBinding2);
        TypeBinding[] typeBindingArray = this.types[referenceBinding3.id];
        int n = typeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            typeBinding = typeBindingArray[n2];
            if (typeBinding == null) break;
            if (typeBinding.isRawType() && typeBinding.actualType() == referenceBinding3 && !typeBinding.hasTypeAnnotations() && typeBinding.enclosingType() == referenceBinding4) {
                return (RawTypeBinding)typeBinding;
            }
            ++n2;
        }
        if (n2 == n) {
            TypeBinding[] typeBindingArray2 = typeBindingArray;
            typeBindingArray = new TypeBinding[n * 2];
            System.arraycopy(typeBindingArray2, 0, typeBindingArray, 0, n);
            this.types[referenceBinding3.id] = typeBindingArray;
        }
        typeBinding = typeBindingArray[n2] = new RawTypeBinding(referenceBinding3, referenceBinding4, this.environment);
        int n3 = this.types.length;
        if (this.typeid == n3) {
            this.types = new TypeBinding[n3 * 2][];
            System.arraycopy(this.types, 0, this.types, 0, n3);
        }
        this.types[this.typeid] = new TypeBinding[1];
        typeBinding.id = this.typeid++;
        TypeBinding typeBinding2 = typeBinding;
        this.types[typeBinding.id][0] = typeBinding2;
        return (RawTypeBinding)typeBinding2;
    }

    public RawTypeBinding getRawType(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2, AnnotationBinding[] annotationBindingArray) {
        return this.getRawType(referenceBinding, referenceBinding2);
    }

    public WildcardBinding getWildcard(ReferenceBinding referenceBinding, int n, TypeBinding typeBinding, TypeBinding[] typeBindingArray, int n2) {
        TypeBinding typeBinding2;
        if (referenceBinding == null) {
            referenceBinding = ReferenceBinding.LUB_GENERIC;
        }
        ReferenceBinding referenceBinding2 = (ReferenceBinding)this.getUnannotatedType(referenceBinding);
        int n3 = typeBindingArray == null ? 0 : typeBindingArray.length;
        Object[] objectArray = typeBindingArray == null ? null : new TypeBinding[n3];
        int n4 = 0;
        while (n4 < n3) {
            objectArray[n4] = this.getUnannotatedType(typeBindingArray[n4]);
            ++n4;
        }
        TypeBinding typeBinding3 = typeBinding == null ? null : this.getUnannotatedType(typeBinding);
        TypeBinding[] typeBindingArray2 = this.types[referenceBinding2.id];
        int n5 = typeBindingArray2.length;
        int n6 = 0;
        while (n6 < n5) {
            typeBinding2 = typeBindingArray2[n6];
            if (typeBinding2 == null) break;
            if (typeBinding2.isWildcard() && typeBinding2.actualType() == referenceBinding2 && !typeBinding2.hasTypeAnnotations() && typeBinding2.rank() == n && typeBinding2.boundKind() == n2 && typeBinding2.bound() == typeBinding3 && Util.effectivelyEqual(typeBinding2.additionalBounds(), objectArray)) {
                return (WildcardBinding)typeBinding2;
            }
            ++n6;
        }
        if (n6 == n5) {
            TypeBinding[] typeBindingArray3 = typeBindingArray2;
            typeBindingArray2 = new TypeBinding[n5 * 2];
            System.arraycopy(typeBindingArray3, 0, typeBindingArray2, 0, n5);
            this.types[referenceBinding2.id] = typeBindingArray2;
        }
        typeBinding2 = typeBindingArray2[n6] = new WildcardBinding(referenceBinding2, n, typeBinding3, (TypeBinding[])objectArray, n2, this.environment);
        int n7 = this.types.length;
        if (this.typeid == n7) {
            this.types = new TypeBinding[n7 * 2][];
            System.arraycopy(this.types, 0, this.types, 0, n7);
        }
        this.types[this.typeid] = new TypeBinding[1];
        typeBinding2.id = this.typeid++;
        TypeBinding typeBinding4 = typeBinding2;
        this.types[typeBinding2.id][0] = typeBinding4;
        return (WildcardBinding)typeBinding4;
    }

    public final CaptureBinding getCapturedWildcard(WildcardBinding wildcardBinding, ReferenceBinding referenceBinding, int n, int n2, ASTNode aSTNode, int n3) {
        int n4;
        WildcardBinding wildcardBinding2 = (WildcardBinding)this.getUnannotatedType(wildcardBinding);
        TypeBinding[] typeBindingArray = this.types[wildcardBinding2.id];
        int n5 = n4 = typeBindingArray.length;
        int n6 = n4 - 1;
        while (n6 >= -1) {
            if (n6 == -1) {
                n6 = n5;
                break;
            }
            TypeBinding typeBinding = typeBindingArray[n6];
            if (typeBinding == null) {
                n5 = n6;
            } else if (typeBinding.isCapture()) {
                CaptureBinding captureBinding = (CaptureBinding)typeBinding;
                if (captureBinding.cud != aSTNode) {
                    n6 = n5;
                    break;
                }
                if (captureBinding.sourceType == referenceBinding && captureBinding.start == n && captureBinding.end == n2) {
                    return captureBinding;
                }
            }
            --n6;
        }
        if (n6 == n4) {
            TypeBinding[] typeBindingArray2 = typeBindingArray;
            typeBindingArray = new TypeBinding[n4 * 2];
            System.arraycopy(typeBindingArray2, 0, typeBindingArray, 0, n4);
            this.types[wildcardBinding2.id] = typeBindingArray;
        }
        typeBindingArray[n6] = new CaptureBinding(wildcardBinding, referenceBinding, n, n2, aSTNode, n3);
        return typeBindingArray[n6];
    }

    public WildcardBinding getWildcard(ReferenceBinding referenceBinding, int n, TypeBinding typeBinding, TypeBinding[] typeBindingArray, int n2, AnnotationBinding[] annotationBindingArray) {
        return this.getWildcard(referenceBinding, n, typeBinding, typeBindingArray, n2);
    }

    public TypeBinding getAnnotatedType(TypeBinding typeBinding, AnnotationBinding[][] annotationBindingArray) {
        return typeBinding;
    }

    protected final TypeBinding[] getDerivedTypes(TypeBinding typeBinding) {
        typeBinding = this.getUnannotatedType(typeBinding);
        return this.types[typeBinding.id];
    }

    private TypeBinding cacheDerivedType(TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (typeBinding == null || typeBinding2 == null || typeBinding.id == Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        TypeBinding[] typeBindingArray = this.types[typeBinding.id];
        int n = typeBindingArray.length;
        int n2 = 0;
        int n3 = n;
        int n4 = (n2 + n3) / 2;
        do {
            if (typeBindingArray[n4] == null) {
                if (n4 == n2 || n4 > 0 && typeBindingArray[n4 - 1] != null) break;
                n3 = n4 - 1;
                continue;
            }
            n2 = n4 + 1;
        } while ((n4 = (n2 + n3) / 2) < n && n2 <= n3);
        if (n4 == n) {
            TypeBinding[] typeBindingArray2 = typeBindingArray;
            typeBindingArray = new TypeBinding[n * 2];
            System.arraycopy(typeBindingArray2, 0, typeBindingArray, 0, n);
            this.types[typeBinding.id] = typeBindingArray;
        }
        typeBindingArray[n4] = typeBinding2;
        return typeBindingArray[n4];
    }

    protected final TypeBinding cacheDerivedType(TypeBinding typeBinding, TypeBinding typeBinding2, TypeBinding typeBinding3) {
        this.cacheDerivedType(typeBinding, typeBinding3);
        if (typeBinding2.id != typeBinding.id) {
            this.cacheDerivedType(typeBinding2, typeBinding3);
        }
        return typeBinding3;
    }

    public final AnnotationBinding getAnnotationType(ReferenceBinding referenceBinding, boolean bl) {
        AnnotationBinding annotationBinding = (AnnotationBinding)this.annotationTypes.get(referenceBinding);
        if (annotationBinding == null) {
            annotationBinding = bl ? new AnnotationBinding(referenceBinding, Binding.NO_ELEMENT_VALUE_PAIRS) : new UnresolvedAnnotationBinding(referenceBinding, Binding.NO_ELEMENT_VALUE_PAIRS, this.environment);
            this.annotationTypes.put(referenceBinding, annotationBinding);
        }
        if (bl) {
            annotationBinding.resolve();
        }
        return annotationBinding;
    }

    public boolean isAnnotatedTypeSystem() {
        return false;
    }

    public void reset() {
        this.annotationTypes = new SimpleLookupTable(16);
        this.typeid = 128;
        this.types = new TypeBinding[256][];
        this.parameterizedTypes = new HashedParameterizedTypes();
    }

    public void updateCaches(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding) {
        int n;
        int n2;
        Object[] objectArray;
        int n3 = unresolvedReferenceBinding.id;
        if (n3 != Integer.MAX_VALUE) {
            objectArray = this.types[n3];
            n2 = 0;
            n = objectArray == null ? 0 : objectArray.length;
            while (n2 < n) {
                if (objectArray[n2] == null) break;
                if (objectArray[n2] == unresolvedReferenceBinding) {
                    referenceBinding.id = n3;
                    objectArray[n2] = referenceBinding;
                }
                ++n2;
            }
        }
        if (this.annotationTypes.get(unresolvedReferenceBinding) != null) {
            objectArray = this.annotationTypes.keyTable;
            n2 = 0;
            n = objectArray.length;
            while (n2 < n) {
                if (objectArray[n2] == unresolvedReferenceBinding) {
                    objectArray[n2] = referenceBinding;
                    break;
                }
                ++n2;
            }
        }
    }

    public final TypeBinding getIntersectionType18(ReferenceBinding[] referenceBindingArray) {
        int n;
        int n2 = n = referenceBindingArray == null ? 0 : referenceBindingArray.length;
        if (n == 0) {
            return null;
        }
        ReferenceBinding referenceBinding = referenceBindingArray[0];
        if (referenceBinding == null || n == 1) {
            return referenceBinding;
        }
        TypeBinding[] typeBindingArray = this.getDerivedTypes(referenceBinding);
        int n3 = typeBindingArray.length;
        int n4 = 0;
        while (n4 < n3) {
            block6: {
                ReferenceBinding[] referenceBindingArray2;
                TypeBinding typeBinding = typeBindingArray[n4];
                if (typeBinding == null) break;
                if (typeBinding.isIntersectionType18() && (referenceBindingArray2 = typeBinding.getIntersectingTypes()).length == n) {
                    int n5 = 0;
                    while (n5 < n) {
                        if (referenceBindingArray[n5] == referenceBindingArray2[n5]) {
                            ++n5;
                            continue;
                        }
                        break block6;
                    }
                    return typeBinding;
                }
            }
            ++n4;
        }
        return this.cacheDerivedType(referenceBinding, new IntersectionTypeBinding18(referenceBindingArray, this.environment));
    }

    public void fixTypeVariableDeclaringElement(TypeVariableBinding typeVariableBinding, Binding binding) {
        int n = typeVariableBinding.id;
        if (n < this.typeid && this.types[n] != null) {
            TypeBinding[] typeBindingArray = this.types[n];
            int n2 = typeBindingArray.length;
            int n3 = 0;
            while (n3 < n2) {
                TypeBinding typeBinding = typeBindingArray[n3];
                if (typeBinding instanceof TypeVariableBinding) {
                    ((TypeVariableBinding)typeBinding).declaringElement = binding;
                }
                ++n3;
            }
        } else {
            typeVariableBinding.declaringElement = binding;
        }
    }

    public final class HashedParameterizedTypes {
        HashMap<ParameterizedTypeBinding, ParameterizedTypeBinding[]> hashedParameterizedTypes = new HashMap(256);

        ParameterizedTypeBinding get(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding2, AnnotationBinding[] annotationBindingArray) {
            ReferenceBinding referenceBinding3 = (ReferenceBinding)TypeSystem.this.getUnannotatedType(referenceBinding);
            int n = typeBindingArray == null ? 0 : typeBindingArray.length;
            Object[] objectArray = typeBindingArray == null ? null : new TypeBinding[n];
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = TypeSystem.this.getUnannotatedType(typeBindingArray[n2]);
                ++n2;
            }
            ReferenceBinding referenceBinding4 = referenceBinding2 == null ? null : (ReferenceBinding)TypeSystem.this.getUnannotatedType(referenceBinding2);
            InternalParameterizedTypeBinding internalParameterizedTypeBinding = new InternalParameterizedTypeBinding(referenceBinding3, (TypeBinding[])objectArray, referenceBinding4, TypeSystem.this.environment);
            ReferenceBinding referenceBinding5 = referenceBinding3;
            ReferenceBinding referenceBinding6 = referenceBinding4;
            Object[] objectArray2 = objectArray;
            if (TypeSystem.this instanceof AnnotatableTypeSystem) {
                referenceBinding5 = referenceBinding;
                referenceBinding6 = referenceBinding2;
                objectArray2 = typeBindingArray;
            }
            ParameterizedTypeBinding[] parameterizedTypeBindingArray = this.hashedParameterizedTypes.get(internalParameterizedTypeBinding);
            int n3 = 0;
            int n4 = parameterizedTypeBindingArray == null ? 0 : parameterizedTypeBindingArray.length;
            while (n3 < n4) {
                ParameterizedTypeBinding parameterizedTypeBinding = parameterizedTypeBindingArray[n3];
                if (parameterizedTypeBinding.actualType() == referenceBinding5 && parameterizedTypeBinding.enclosingType() == referenceBinding6 && Util.effectivelyEqual(parameterizedTypeBinding.typeArguments(), objectArray2) && Util.effectivelyEqual(annotationBindingArray, parameterizedTypeBinding.getTypeAnnotations())) {
                    return parameterizedTypeBinding;
                }
                ++n3;
            }
            return null;
        }

        void put(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding2, ParameterizedTypeBinding parameterizedTypeBinding) {
            int n;
            ReferenceBinding referenceBinding3 = (ReferenceBinding)TypeSystem.this.getUnannotatedType(referenceBinding);
            int n2 = typeBindingArray == null ? 0 : typeBindingArray.length;
            TypeBinding[] typeBindingArray2 = typeBindingArray == null ? null : new TypeBinding[n2];
            int n3 = 0;
            while (n3 < n2) {
                typeBindingArray2[n3] = TypeSystem.this.getUnannotatedType(typeBindingArray[n3]);
                ++n3;
            }
            ReferenceBinding referenceBinding4 = referenceBinding2 == null ? null : (ReferenceBinding)TypeSystem.this.getUnannotatedType(referenceBinding2);
            InternalParameterizedTypeBinding internalParameterizedTypeBinding = new InternalParameterizedTypeBinding(referenceBinding3, typeBindingArray2, referenceBinding4, TypeSystem.this.environment);
            ParameterizedTypeBinding[] parameterizedTypeBindingArray = this.hashedParameterizedTypes.get(internalParameterizedTypeBinding);
            if (parameterizedTypeBindingArray == null) {
                n = 0;
                parameterizedTypeBindingArray = new ParameterizedTypeBinding[1];
            } else {
                n = parameterizedTypeBindingArray.length;
                ParameterizedTypeBinding[] parameterizedTypeBindingArray2 = parameterizedTypeBindingArray;
                parameterizedTypeBindingArray = new ParameterizedTypeBinding[n + 1];
                System.arraycopy(parameterizedTypeBindingArray2, 0, parameterizedTypeBindingArray, 0, n);
            }
            parameterizedTypeBindingArray[n] = parameterizedTypeBinding;
            this.hashedParameterizedTypes.put(internalParameterizedTypeBinding, parameterizedTypeBindingArray);
        }

        private final class InternalParameterizedTypeBinding
        extends ParameterizedTypeBinding {
            public InternalParameterizedTypeBinding(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding2, LookupEnvironment lookupEnvironment) {
                super(referenceBinding, typeBindingArray, referenceBinding2, lookupEnvironment);
            }

            public boolean equals(Object object) {
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)object;
                return this.type == parameterizedTypeBinding.type && this.enclosingType == parameterizedTypeBinding.enclosingType && Util.effectivelyEqual(this.arguments, parameterizedTypeBinding.arguments);
            }

            public int hashCode() {
                int n = this.type.hashCode() + 13 * (this.enclosingType != null ? this.enclosingType.hashCode() : 0);
                int n2 = 0;
                int n3 = this.arguments == null ? 0 : this.arguments.length;
                while (n2 < n3) {
                    n += (n2 + 1) * this.arguments[n2].id * this.arguments[n2].hashCode();
                    ++n2;
                }
                return n;
            }
        }
    }
}

